/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.capture.service.impl;

import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.daap.capture.entity.DaapCaptureSinkFieldEntity;
import com.bringspring.daap.capture.entity.DaapCaptureSinkTableEntity;
import com.bringspring.daap.capture.entity.DaapCaptureSourceFieldEntity;
import com.bringspring.daap.capture.entity.DaapCaptureSourceTableEntity;
import com.bringspring.daap.capture.model.mapping.MappingFieldModel;
import com.bringspring.daap.capture.model.mapping.MappingTableModel;
import com.bringspring.daap.capture.model.sinkfield.SinkFieldModel;
import com.bringspring.daap.capture.model.sinktable.SinkTableModel;
import com.bringspring.daap.capture.model.sourcefield.SourceFieldModel;
import com.bringspring.daap.capture.model.sourcetable.SourceTableModel;
import com.bringspring.daap.capture.service.DaapCaptureConfigService;
import com.bringspring.daap.capture.service.DaapCaptureSinkFieldService;
import com.bringspring.daap.capture.service.DaapCaptureSinkService;
import com.bringspring.daap.capture.service.DaapCaptureSinkTableService;
import com.bringspring.daap.capture.service.DaapCaptureSourceFieldService;
import com.bringspring.daap.capture.service.DaapCaptureSourceTableService;
import com.bringspring.daap.capture.service.DaapCaptureTableMappingService;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.entity.DaapDataTableEntity;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataFieldModel;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.datamodel.service.DaapDataTableService;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.database.MySqlTypeMapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.types.DataType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapCaptureTableMappingServiceImpl
implements DaapCaptureTableMappingService {
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapCaptureConfigService daapCaptureConfigService;
    @Autowired
    private DaapCaptureSourceTableService daapCaptureSourceTableService;
    @Autowired
    private DaapCaptureSourceFieldService daapCaptureSourceFieldService;
    @Autowired
    private DaapCaptureSinkService daapCaptureSinkService;
    @Autowired
    private DaapCaptureSinkTableService daapCaptureSinkTableService;
    @Autowired
    private DaapCaptureSinkFieldService daapCaptureSinkFieldService;
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapDataTableService daapDataTableService;
    @Autowired
    private DaapDataFieldService daapDataFieldService;

    @Override
    public List<MappingTableModel> getMappingTableFieldModels(String configId) throws DataException {
        ArrayList<MappingTableModel> mappingTableModels = new ArrayList<MappingTableModel>();
        if (StringUtils.isNotEmpty((String)configId)) {
            List<DaapCaptureSourceTableEntity> sourceTableList = this.daapCaptureSourceTableService.getSourceTableListByConfigId(configId);
            List tableModels = JsonUtil.getJsonToList(sourceTableList, SourceTableModel.class);
            for (SourceTableModel sourceTable : tableModels) {
                MappingTableModel mappingTableModel = new MappingTableModel();
                List<DaapCaptureSourceFieldEntity> sourceFieldList = this.daapCaptureSourceFieldService.getSourceFieldListByTableId(sourceTable.getId());
                List fieldModels = JsonUtil.getJsonToList(sourceFieldList, SourceFieldModel.class);
                sourceTable.setSourceFieldModels(fieldModels);
                mappingTableModel.setSourceTable(sourceTable);
                DaapCaptureSinkTableEntity sinkTable = this.daapCaptureSinkTableService.getSinkTableByConfigIdAndSourTableName(configId, sourceTable.getTableName());
                SinkTableModel sinkTableModel = (SinkTableModel)JsonUtil.getJsonToBean((Object)sinkTable, SinkTableModel.class);
                List<DaapCaptureSinkFieldEntity> sinkFieldList = this.daapCaptureSinkFieldService.getSinkTableFieldList(sinkTable.getId());
                List sinkFieldModels = JsonUtil.getJsonToList(sinkFieldList, SinkFieldModel.class);
                sinkTableModel.setSinkFieldModels(sinkFieldModels);
                mappingTableModel.setSinkTable(sinkTableModel);
                mappingTableModels.add(mappingTableModel);
            }
        } else {
            throw new DataException("\u91c7\u96c6\u914d\u7f6eID\u4e3a\u7a7a");
        }
        return mappingTableModels;
    }

    @Override
    public MappingFieldModel getMappingTableField(String connectorId, String configId, String dbName, String schemaName, String tableName) throws DataException, SQLException {
        MappingFieldModel mappingFieldModel = new MappingFieldModel();
        if (StringUtils.isNotEmpty((String)configId)) {
            DaapCaptureSourceTableEntity sourceTable = this.daapCaptureSourceTableService.getSourceTable(configId, dbName, schemaName, tableName);
            if (sourceTable == null) {
                mappingFieldModel = this.getDefaultMappingTableField(connectorId, dbName, schemaName, tableName);
            } else {
                List<DaapCaptureSourceFieldEntity> sourceFieldList = this.daapCaptureSourceFieldService.getSourceFieldListByTableId(sourceTable.getId());
                DaapCaptureSinkTableEntity sinkTableEntity = this.daapCaptureSinkTableService.getSinkTableByConfigIdAndSourTableName(configId, tableName);
                List<DaapCaptureSinkFieldEntity> sinkFieldList = this.daapCaptureSinkFieldService.getSinkTableFieldList(sinkTableEntity.getId());
                List fieldModels = JsonUtil.getJsonToList(sourceFieldList, SourceFieldModel.class);
                mappingFieldModel.setSourceFieldModels(fieldModels);
                List sinkFieldModels = JsonUtil.getJsonToList(sinkFieldList, SinkFieldModel.class);
                mappingFieldModel.setSinkFieldModels(sinkFieldModels);
            }
        } else {
            throw new DataException("\u91c7\u96c6\u914d\u7f6eID\u4e3a\u7a7a");
        }
        return mappingFieldModel;
    }

    @Override
    public MappingFieldModel getDefaultMappingTableField(String connectorId, String dbName, String schemaName, String sourceTableName) throws DataException, SQLException {
        MappingFieldModel mappingFieldModel = new MappingFieldModel();
        DaapDataBaseEntity dataBaseEntity = this.daapDataBaseService.getByConnectorIdAndDbName(connectorId, dbName, schemaName);
        DaapDataTableEntity tableEntity = this.daapDataTableService.getListByDataBaseId(dataBaseEntity.getId(), sourceTableName);
        List<DaapDataFieldEntity> fieldsByTable = this.daapDataFieldService.getFieldsByTable(tableEntity.getId());
        List dbTableFieldList = JsonUtil.getJsonToList(fieldsByTable, DaapDataFieldModel.class);
        MySqlTypeMapper mySqlTypeMapper = new MySqlTypeMapper("Mysql5.7", "Mysql8");
        for (DaapDataFieldModel dataFieldModel : dbTableFieldList) {
            int precision = 0;
            int scale = 0;
            String dataType1 = "";
            String dataLength = "";
            String fieldEnd = "";
            try {
                if (dataFieldModel.getDataType().contains("(")) {
                    Pattern pattern1;
                    Matcher matcher1;
                    Pattern pattern = Pattern.compile("\\((.*?)\\)");
                    Matcher matcher = pattern.matcher(dataFieldModel.getDataType());
                    if (matcher.find()) {
                        dataLength = matcher.group(1);
                    }
                    if ((matcher1 = (pattern1 = Pattern.compile("(.+)(?=\\()")).matcher(dataFieldModel.getDataType())).find()) {
                        dataType1 = matcher1.group(1);
                    }
                } else {
                    dataLength = dataFieldModel.getDataLength();
                    dataType1 = dataFieldModel.getDataType();
                }
                int index = dataFieldModel.getDataType().indexOf(")");
                if (index != -1) {
                    fieldEnd = dataFieldModel.getDataType().substring(index + 1);
                }
                if (StringUtils.contains((CharSequence)dataLength, (CharSequence)",")) {
                    precision = Integer.parseInt(dataLength.split(",")[0]);
                    scale = Integer.parseInt(dataLength.split(",")[1]);
                } else if (StringUtils.isNumeric((CharSequence)dataLength)) {
                    precision = Integer.parseInt(dataLength);
                }
            }
            catch (Exception e) {
                precision = Integer.MAX_VALUE;
            }
            DataType dataType = null;
            try {
                dataType = mySqlTypeMapper.mapping(dataType1 + fieldEnd, precision, scale);
                dataFieldModel.setDataType(dataType.toString());
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        List fieldModels = JsonUtil.getJsonToList((Object)dbTableFieldList, SourceFieldModel.class);
        mappingFieldModel.setSourceFieldModels(fieldModels);
        List sinkFieldModels = JsonUtil.getJsonToList((Object)dbTableFieldList, SinkFieldModel.class);
        for (SinkFieldModel sinkFieldModel : sinkFieldModels) {
            sinkFieldModel.setSourceFieldName(sinkFieldModel.getFieldName());
        }
        mappingFieldModel.setSinkFieldModels(sinkFieldModels);
        return mappingFieldModel;
    }
}

