/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.capture.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.daap.capture.constant.EnabledMarkEnum;
import com.bringspring.daap.capture.entity.DaapCaptureConfigEntity;
import com.bringspring.daap.capture.entity.DaapCaptureSourceEntity;
import com.bringspring.daap.capture.model.config.DaapCaptureConfigPagination;
import com.bringspring.daap.capture.service.DaapCaptureConfigService;
import com.bringspring.daap.capture.service.DaapCaptureSourceService;
import com.bringspring.daap.job.entity.DaapFlinkCheckpointEntity;
import com.bringspring.daap.job.entity.DaapFlinkExcepointEntity;
import com.bringspring.daap.job.entity.DaapFlinkManagerInfoEntity;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.entity.DaapJobSourceEntity;
import com.bringspring.daap.job.service.DaapFlinkCheckpointService;
import com.bringspring.daap.job.service.DaapFlinkExcepointService;
import com.bringspring.daap.job.service.DaapFlinkManagerInfoService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.daap.job.service.DaapJobSourceService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CaptureUtils {
    private static final Logger log = LoggerFactory.getLogger(CaptureUtils.class);
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DaapCaptureConfigService daapCaptureConfigService;
    @Autowired
    private DaapFlinkCheckpointService daappFlinkCheckpointService;
    @Autowired
    private DaapFlinkExcepointService daapFlinkExcepointService;
    @Autowired
    private DaapFlinkManagerInfoService daapFlinkManagerInfoService;
    @Autowired
    private DaapCaptureSourceService daapCaptureSourceService;
    @Autowired
    private DaapJobSourceService daapJobSourceService;

    @JsbosTask(fullName="\u540c\u6b65Flink\u4efb\u52a1\u72b6\u6001", description="\u540c\u6b65\u91c7\u96c6\u4efb\u52a1\u5728Flink\u7684\u6267\u884c\u72b6\u6001")
    public void syncCaptureJobEnabled() {
        List<DaapJobClusterEntity> remoteList = this.daapJobClusterService.getRemoteList();
        for (DaapJobClusterEntity clusterEntity : remoteList) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("http://").append(clusterEntity.getJobManagerHost()).append(":").append(clusterEntity.getPort()).append("/jobs");
            String jobStr = HttpUtil.get((String)stringBuffer.toString());
            JSONObject jobs = JSONObject.parseObject((String)jobStr);
            JSONArray jobList = jobs.getJSONArray("jobs");
            for (Object o : jobList) {
                DaapCaptureConfigEntity captureConfigByJobId;
                JSONObject job = (JSONObject)o;
                String status = job.getString("status");
                String jobId = job.getString("id");
                if (status.equals("RUNNING") || !ObjectUtil.isNotNull((Object)(captureConfigByJobId = this.daapCaptureConfigService.getCaptureConfigByJobId(jobId)))) continue;
                captureConfigByJobId.setEnabledMark(EnabledMarkEnum.EXCEPTION_STOP.getCode());
                this.daapCaptureConfigService.updateById(captureConfigByJobId);
            }
        }
        System.out.println("\u5b9a\u65f6\u4efb\u52a1\u793a\u4f8b");
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u83b7\u53d6flink\u91c7\u96c6\u4efb\u52a1\u4fe1\u606f", description="\u83b7\u53d6flink\u91c7\u96c6\u4efb\u52a1\u4fe1\u606f\u5305\u542b(\u68c0\u67e5\u70b9/\u4fdd\u5b58\u70b9/\u5f02\u5e38/\u8fd0\u884c\u65e5\u5fd7)")
    public void getFlinkInfo() throws DataException {
        DaapCaptureConfigPagination daapCaptureConfigPagination = new DaapCaptureConfigPagination();
        List<DaapCaptureConfigEntity> list = this.daapCaptureConfigService.getList(daapCaptureConfigPagination);
        for (DaapCaptureConfigEntity daapCaptureConfigEntity : list) {
            if (!StringUtils.isNotEmpty((String)daapCaptureConfigEntity.getJobId()) || !"30".equals(String.valueOf(daapCaptureConfigEntity.getEnabledMark()))) continue;
            DaapJobClusterEntity daapJobClusterEntity = this.daapJobClusterService.getInfo(daapCaptureConfigEntity.getFlinkResourceId());
            JSONObject jobException = this.daapCaptureConfigService.getJobException(daapCaptureConfigEntity.getJobId(), daapJobClusterEntity.getJobManagerHost(), daapJobClusterEntity.getPort(), 10);
            DaapFlinkExcepointEntity excepointEntity = this.daapFlinkExcepointService.getDaapFlinkExcepointByJobId(daapCaptureConfigEntity.getJobId());
            if (excepointEntity != null) {
                excepointEntity.setExcepointInfo(jobException.toJSONString());
                excepointEntity.setLastModifyTime(new Date());
                this.daapFlinkExcepointService.updateById(excepointEntity);
            } else {
                DaapFlinkExcepointEntity daapFlinkExcepointEntity = new DaapFlinkExcepointEntity();
                daapFlinkExcepointEntity.setId(RandomUtil.uuId());
                daapFlinkExcepointEntity.setCaptureConfigId(daapCaptureConfigEntity.getId());
                daapFlinkExcepointEntity.setJobId(daapCaptureConfigEntity.getJobId());
                daapFlinkExcepointEntity.setExcepointInfo(jobException.toJSONString());
                this.daapFlinkExcepointService.save(daapFlinkExcepointEntity);
            }
            JSONObject jobDetail = this.daapCaptureConfigService.getFlinkJobDetail(daapCaptureConfigEntity.getJobId(), daapJobClusterEntity.getJobManagerHost(), daapJobClusterEntity.getPort());
            DaapFlinkManagerInfoEntity managerInfoEntity = this.daapFlinkManagerInfoService.getDaapFlinkManagerInfoByJobId(daapCaptureConfigEntity.getJobId());
            if (managerInfoEntity != null) {
                managerInfoEntity.setManagerInfo(jobDetail.toJSONString());
                managerInfoEntity.setLastModifyTime(new Date());
                this.daapFlinkManagerInfoService.updateById(managerInfoEntity);
            } else {
                DaapFlinkManagerInfoEntity daapFlinkManagerInfoEntity = new DaapFlinkManagerInfoEntity();
                daapFlinkManagerInfoEntity.setId(RandomUtil.uuId());
                daapFlinkManagerInfoEntity.setCaptureConfigId(daapCaptureConfigEntity.getId());
                daapFlinkManagerInfoEntity.setJobId(daapCaptureConfigEntity.getJobId());
                daapFlinkManagerInfoEntity.setManagerInfo(jobDetail.toJSONString());
                this.daapFlinkManagerInfoService.save(daapFlinkManagerInfoEntity);
            }
            if (!"1".equals(daapCaptureConfigEntity.getCheckpoint().getEnabledMark())) continue;
            JSONObject jobCheckPoint = this.daapCaptureConfigService.getJobCheckPoint(daapCaptureConfigEntity.getJobId(), daapJobClusterEntity.getJobManagerHost(), daapJobClusterEntity.getPort());
            DaapFlinkCheckpointEntity entity = this.daappFlinkCheckpointService.getDaapFlinkCheckpointByJobId(daapCaptureConfigEntity.getJobId());
            if (entity != null) {
                entity.setCheckpointInfo(jobCheckPoint.toJSONString());
                entity.setLastModifyTime(new Date());
                this.daappFlinkCheckpointService.updateById(entity);
                continue;
            }
            DaapFlinkCheckpointEntity daapFlinkCheckpointEntity = new DaapFlinkCheckpointEntity();
            String mainId = RandomUtil.uuId();
            daapFlinkCheckpointEntity.setId(mainId);
            daapFlinkCheckpointEntity.setCaptureConfigId(daapCaptureConfigEntity.getId());
            daapFlinkCheckpointEntity.setJobId(daapCaptureConfigEntity.getJobId());
            daapFlinkCheckpointEntity.setCheckpointInfo(jobCheckPoint.toJSONString());
            this.daappFlinkCheckpointService.save(daapFlinkCheckpointEntity);
        }
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u542f\u52a8Flink\u6279\u5904\u7406\u4efb\u52a1-\u91c7\u96c6\u5411\u5bfc", description="\u5b9a\u65f6\u542f\u52a8Flink\u6279\u5904\u7406\u4efb\u52a1-\u91c7\u96c6\u5411\u5bfc")
    public void clocStartFlinkCaptureSource() {
        List<DaapCaptureSourceEntity> captureSourceList = this.daapCaptureSourceService.getAllBatchList();
        for (DaapCaptureSourceEntity daapCaptureSourceEntity : captureSourceList) {
            try {
                this.daapCaptureConfigService.submitCapture(daapCaptureSourceEntity.getId(), "");
            }
            catch (Exception e) {
                log.error("\u7f16\u53f7\u4e3a" + daapCaptureSourceEntity.getId() + "\u7684\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
    }

    @JsbosTask(fullName="\u5b9a\u65f6\u542f\u52a8Flink\u6279\u5904\u7406\u4efb\u52a1-\u4f5c\u4e1a\u5f00\u53d1", description="\u5b9a\u65f6\u542f\u52a8Flink\u6279\u5904\u7406\u4efb\u52a1-\u4f5c\u4e1a\u5f00\u53d1")
    public void clocStartFlinkJobSource() {
        List<DaapJobSourceEntity> jobSourceList = this.daapJobSourceService.getAllBatchList();
        for (DaapJobSourceEntity daapJobSourceEntity : jobSourceList) {
            try {
                if ("\u6279\u91cf\u83b7\u53d6\u8d44\u4ea7\u53f0\u8d26".equals(daapJobSourceEntity.getName())) continue;
                log.info(daapJobSourceEntity.getName());
                this.daapJobSourceService.submit(daapJobSourceEntity.getId());
            }
            catch (Exception e) {
                log.error("\u7f16\u53f7\u4e3a" + daapJobSourceEntity.getId() + ":\u7684:" + daapJobSourceEntity.getName() + "\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
    }

    @JsbosTask(fullName="\u6c88\u9633\u56ed\u533a\u8d44\u4ea7\u53f0\u8d26\u6279\u5904\u7406\u6bcf\u5929\u4e00\u6b21-\u4f5c\u4e1a\u5f00\u53d1", description="\u6c88\u9633\u56ed\u533a\u8d44\u4ea7\u53f0\u8d26\u6279\u5904\u7406\u6bcf\u5929\u4e00\u6b21-\u4f5c\u4e1a\u5f00\u53d1")
    public void rptFixedAssetsTotalFlinkJobSource() {
        List<DaapJobSourceEntity> jobSourceList = this.daapJobSourceService.getAllBatchList();
        for (DaapJobSourceEntity daapJobSourceEntity : jobSourceList) {
            try {
                if (!"\u6279\u91cf\u83b7\u53d6\u8d44\u4ea7\u53f0\u8d26".equals(daapJobSourceEntity.getName())) continue;
                log.info(daapJobSourceEntity.getName());
                this.daapJobSourceService.submit(daapJobSourceEntity.getId());
            }
            catch (Exception e) {
                log.error("\u7f16\u53f7\u4e3a" + daapJobSourceEntity.getId() + ":\u7684:" + daapJobSourceEntity.getName() + "\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
    }
}

