/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.datamodel.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.entity.DaapDataTableEntity;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabaseCrForm;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabaseInfoVO;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabaseListVO;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabasePagination;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabaseUpForm;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.datamodel.service.DaapDataTableService;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u5143\u5e93"}, value="daap")
@RequestMapping(value={"/api/daap/data/database"})
public class DaapDataDatabaseController {
    private static final Logger log = LoggerFactory.getLogger(DaapDataDatabaseController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapDataTableService daapDataTableService;
    @Autowired
    private DaapDataFieldService daapDataFieldService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapDataDatabasePagination daapDataDatabasePagination) throws IOException {
        List<DaapDataBaseEntity> list = this.daapDataBaseService.getList(daapDataDatabasePagination);
        for (DaapDataBaseEntity daapDataBaseEntity : list) {
            daapDataBaseEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(daapDataBaseEntity.getCreatorUserId()));
            daapDataBaseEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(daapDataBaseEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DaapDataDatabaseListVO.class);
        for (DaapDataDatabaseListVO daapDataDatabaseListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapDataDatabasePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult getEnabledList() throws IOException {
        List connectorList = this.daapConnectorService.list();
        ArrayList listMap = new ArrayList();
        for (DaapConnectorEntity connector : connectorList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<DaapDataBaseEntity> list = this.daapDataBaseService.getByConnectorId(connector.getId());
            map.put("dbName", connector.getDataSourceName());
            map.put("fullId", connector.getId());
            map.put("dataSourceType", connector.getDataSourceType());
            map.put("readonlyStateStr", this.baseDataUtil.switchSelectValue(String.valueOf(connector.getReadonlyState()), "\u53ea\u8bfb", "\u8bfb\u5199"));
            map.put("readonlyState", connector.getReadonlyState());
            map.put("children", list);
            listMap.add(map);
        }
        return ActionResult.success(listMap);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapDataDatabaseCrForm daapDataDatabaseCrForm) throws DataException {
        List<DaapDataBaseEntity> databaseList = this.daapDataBaseService.getByConnectorId(daapDataDatabaseCrForm.getConnectorId());
        int databaseNum = 0;
        for (DaapDataBaseEntity databaseModel : databaseList) {
            if (!databaseModel.getDbName().contains(daapDataDatabaseCrForm.getDbName())) continue;
            ++databaseNum;
        }
        if (databaseNum > 0) {
            daapDataDatabaseCrForm.setDbName(daapDataDatabaseCrForm.getDbName() + "_copy" + databaseNum);
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        daapDataDatabaseCrForm.setCreatorUserId(userInfo.getUserId());
        daapDataDatabaseCrForm.setCreatorTime(DateUtil.getNow());
        DaapDataBaseEntity entity = (DaapDataBaseEntity)JsonUtil.getJsonToBean((Object)daapDataDatabaseCrForm, DaapDataBaseEntity.class);
        entity.setId(mainId);
        this.daapDataBaseService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapDataDatabaseInfoVO> info(@PathVariable(value="id") String id) {
        DaapDataBaseEntity entity = this.daapDataBaseService.getInfo(id);
        DaapDataDatabaseInfoVO vo = (DaapDataDatabaseInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataDatabaseInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapDataDatabaseInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapDataBaseEntity entity = this.daapDataBaseService.getInfo(id);
        DaapDataDatabaseInfoVO vo = (DaapDataDatabaseInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataDatabaseInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapDataDatabaseUpForm daapDataDatabaseUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapDataBaseEntity entity = this.daapDataBaseService.getInfo(id);
        if (entity != null) {
            daapDataDatabaseUpForm.setLastModifyUserId(userInfo.getUserId());
            daapDataDatabaseUpForm.setLastModifyTime(DateUtil.getNow());
            DaapDataBaseEntity subentity = (DaapDataBaseEntity)JsonUtil.getJsonToBean((Object)daapDataDatabaseUpForm, DaapDataBaseEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.daapDataBaseService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws Exception {
        DaapDataBaseEntity entity = this.daapDataBaseService.getInfo(id);
        if (entity != null) {
            DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(entity.getConnectorId());
            if ("1".equals(daapConnectorEntity.getReadonlyState())) {
                this.daapDataBaseService.delete(entity);
                this.deleteTableAndField(entity);
            } else {
                try {
                    this.daapDataBaseService.deleteDataBase(entity);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("database doesn't exist")) {
                        System.err.println(e.getMessage());
                    }
                    throw new Exception(e);
                }
                this.daapDataBaseService.delete(entity);
                this.deleteTableAndField(entity);
            }
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void deleteTableAndField(DaapDataBaseEntity entity) {
        List<DaapDataTableEntity> listByDataBaseList = this.daapDataTableService.getListByDataBaseId(entity.getId());
        if (listByDataBaseList.size() > 0) {
            for (DaapDataTableEntity daapDataTableEntity : listByDataBaseList) {
                this.daapDataTableService.delete(daapDataTableEntity);
                QueryWrapper queryWrapperDaapDataColumn = new QueryWrapper();
                queryWrapperDaapDataColumn.lambda().eq(DaapDataFieldEntity::getTableId, (Object)daapDataTableEntity.getId());
                this.daapDataFieldService.remove((Wrapper)queryWrapperDaapDataColumn);
            }
        }
    }
}

