/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.datamodel.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.entity.DaapDataTableEntity;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataFieldModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableCrForm;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableInfoVO;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableListVO;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTablePagination;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableUpForm;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.datamodel.service.DaapDataTableService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u5143\u8868"}, value="daap")
@RequestMapping(value={"/api/daap/data/table"})
public class DaapDataTableController {
    private static final Logger log = LoggerFactory.getLogger(DaapDataTableController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapDataTableService daapDataTableService;
    @Autowired
    private DaapDataFieldService daapDataFieldService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapDataTablePagination daapDataTablePagination) throws IOException {
        List<DaapDataTableEntity> list = this.daapDataTableService.getList(daapDataTablePagination);
        List listVO = JsonUtil.getJsonToList(list, DaapDataTableListVO.class);
        for (DaapDataTableListVO daapDataTableVO : listVO) {
            daapDataTableVO.setEnabledMark(this.baseDataUtil.switchSelectValue(String.valueOf(daapDataTableVO.getEnabledMark()), "\u751f\u6548", "\u672a\u751f\u6548"));
            daapDataTableVO.setCreatTableStatus(this.baseDataUtil.switchSelectValue(String.valueOf(daapDataTableVO.getCreatTableStatus()), "\u5df2\u521b\u5efa", "\u672a\u521b\u5efa"));
            daapDataTableVO.setCreatorUserId(this.baseDataUtil.userSelectValue(daapDataTableVO.getCreatorUserId()));
            daapDataTableVO.setLastModifyUserId(this.baseDataUtil.userSelectValue(daapDataTableVO.getLastModifyUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapDataTablePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapDataTableCrForm daapDataTableCrForm) throws DataException, Exception {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        daapDataTableCrForm.setCreatorUserId(userInfo.getUserId());
        daapDataTableCrForm.setCreatorTime(DateUtil.getNow());
        DaapDataTableEntity entity = (DaapDataTableEntity)JsonUtil.getJsonToBean((Object)daapDataTableCrForm, DaapDataTableEntity.class);
        entity.setId(mainId);
        this.daapDataTableService.save(entity);
        for (DaapDataFieldModel daapDataFieldModel : daapDataTableCrForm.getDaapDataFieldList()) {
            daapDataFieldModel.setCreatFieldStatus("\u5df2\u521b\u5efa".equals(daapDataFieldModel.getCreatFieldStatus()) ? "1" : "0");
        }
        List daapDataFieldList = JsonUtil.getJsonToList(daapDataTableCrForm.getDaapDataFieldList(), DaapDataFieldEntity.class);
        for (DaapDataFieldEntity entitys : daapDataFieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTableId(entity.getId());
            this.daapDataFieldService.save(entitys);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PostMapping(value={"/commitCreat"})
    @DSTransactional
    public ActionResult commitCreat(@RequestBody @Valid DaapDataTableCrForm daapDataTableCrForm) throws DataException, Exception {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        daapDataTableCrForm.setCreatorUserId(userInfo.getUserId());
        daapDataTableCrForm.setCreatorTime(DateUtil.getNow());
        DaapDataTableEntity entity = (DaapDataTableEntity)JsonUtil.getJsonToBean((Object)daapDataTableCrForm, DaapDataTableEntity.class);
        entity.setId(mainId);
        this.daapDataTableService.creatTable(daapDataTableCrForm);
        entity.setCreatTableStatus(1);
        this.daapDataTableService.save(entity);
        for (DaapDataFieldModel daapDataFieldModel : daapDataTableCrForm.getDaapDataFieldList()) {
            daapDataFieldModel.setCreatFieldStatus("\u5df2\u521b\u5efa".equals(daapDataFieldModel.getCreatFieldStatus()) ? "1" : "0");
        }
        List daapDataFieldList = JsonUtil.getJsonToList(daapDataTableCrForm.getDaapDataFieldList(), DaapDataFieldEntity.class);
        for (DaapDataFieldEntity entitys : daapDataFieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTableId(entity.getId());
            entitys.setCreatFieldStatus(1);
            this.daapDataFieldService.save(entitys);
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u5e76\u521b\u5efa\u7269\u7406\u8868\u7ed3\u6784\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapDataTableInfoVO> info(@PathVariable(value="id") String id) {
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        DaapDataTableInfoVO vo = null;
        if (StringUtils.isNotNull((Object)entity)) {
            vo = (DaapDataTableInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataTableInfoVO.class);
            List<DaapDataFieldEntity> daapDataFieldList = this.daapDataTableService.getDaapDataFieldList(id);
            vo.setDaapDataFieldList(JsonUtil.getJsonToList(daapDataFieldList, DaapDataFieldModel.class));
            for (DaapDataFieldModel daapDataFieldModel : vo.getDaapDataFieldList()) {
                daapDataFieldModel.setCreatFieldStatus(this.baseDataUtil.switchSelectValue(String.valueOf(daapDataFieldModel.getCreatFieldStatus()), "\u5df2\u521b\u5efa", "\u672a\u521b\u5efa"));
            }
        }
        return ActionResult.success(vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapDataTableInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        DaapDataTableInfoVO vo = (DaapDataTableInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataTableInfoVO.class);
        List<DaapDataFieldEntity> daapDataFieldList = this.daapDataTableService.getDaapDataFieldList(id);
        List daapDataFieldModelList = JsonUtil.getJsonToList(daapDataFieldList, DaapDataFieldModel.class);
        vo.setDaapDataFieldList(daapDataFieldModelList);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapDataTableUpForm daapDataTableUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        if (entity != null) {
            daapDataTableUpForm.setLastModifyUserId(userInfo.getUserId());
            daapDataTableUpForm.setLastModifyTime(DateUtil.getNow());
            DaapDataTableEntity subentity = (DaapDataTableEntity)JsonUtil.getJsonToBean((Object)daapDataTableUpForm, DaapDataTableEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.daapDataTableService.update(id, subentity);
            QueryWrapper DaapDataColumnqueryWrapper = new QueryWrapper();
            DaapDataColumnqueryWrapper.lambda().eq(DaapDataFieldEntity::getTableId, (Object)entity.getId());
            this.daapDataFieldService.remove((Wrapper)DaapDataColumnqueryWrapper);
            for (DaapDataFieldModel daapDataFieldModel : daapDataTableUpForm.getDaapDataFieldList()) {
                daapDataFieldModel.setCreatFieldStatus("\u5df2\u521b\u5efa".equals(daapDataFieldModel.getCreatFieldStatus()) ? "1" : "0");
            }
            List daapDataFieldList = JsonUtil.getJsonToList(daapDataTableUpForm.getDaapDataFieldList(), DaapDataFieldEntity.class);
            for (DaapDataFieldEntity entitys : daapDataFieldList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setTableId(entity.getId());
                this.daapDataFieldService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/commitUpdate{id}"})
    @DSTransactional
    public ActionResult commitRequest(@PathVariable(value="id") String id, @RequestBody @Valid DaapDataTableUpForm daapDataTableUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        boolean tableStatus = false;
        if (entity != null) {
            if (!"1".equals(String.valueOf(entity.getCreatTableStatus()))) {
                DaapDataTableCrForm daapDataTableCrForm = (DaapDataTableCrForm)JsonUtil.getJsonToBean((Object)daapDataTableUpForm, DaapDataTableCrForm.class);
                this.daapDataTableService.creatTable(daapDataTableCrForm);
                tableStatus = true;
            } else if (!daapDataTableUpForm.getTableComment().equals(entity.getTableComment())) {
                this.daapDataTableService.updateCreatTable(daapDataTableUpForm);
            }
            daapDataTableUpForm.setLastModifyUserId(userInfo.getUserId());
            daapDataTableUpForm.setLastModifyTime(DateUtil.getNow());
            DaapDataTableEntity subentity = (DaapDataTableEntity)JsonUtil.getJsonToBean((Object)daapDataTableUpForm, DaapDataTableEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setCreatTableStatus(1);
            this.daapDataTableService.update(id, subentity);
            QueryWrapper DaapDataColumnqueryWrapper = new QueryWrapper();
            DaapDataColumnqueryWrapper.lambda().eq(DaapDataFieldEntity::getTableId, (Object)entity.getId());
            this.daapDataFieldService.remove((Wrapper)DaapDataColumnqueryWrapper);
            for (DaapDataFieldModel daapDataFieldModel : daapDataTableUpForm.getDaapDataFieldList()) {
                daapDataFieldModel.setCreatFieldStatus("\u5df2\u521b\u5efa".equals(daapDataFieldModel.getCreatFieldStatus()) ? "1" : "0");
            }
            List daapDataFieldList = JsonUtil.getJsonToList(daapDataTableUpForm.getDaapDataFieldList(), DaapDataFieldEntity.class);
            Collections.sort(daapDataFieldList, (fristDataField, secondDataField) -> secondDataField.getPrimaryKey() - fristDataField.getPrimaryKey());
            for (DaapDataFieldEntity entitys : daapDataFieldList) {
                if (!tableStatus) {
                    this.daapDataFieldService.updateCreatField(daapDataTableUpForm.getDatabaseId(), daapDataTableUpForm.getTableName(), entitys);
                }
                entitys.setId(RandomUtil.uuId());
                entitys.setTableId(entity.getId());
                entitys.setCreatFieldStatus(1);
                this.daapDataFieldService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/creatFieldInfo{id}"})
    @DSTransactional
    public ActionResult creatFieldInfo(@PathVariable(value="id") String id, @RequestBody @Valid DaapDataTableUpForm daapDataTableUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        boolean fieldStatus = false;
        if (entity != null) {
            for (DaapDataFieldModel daapDataFieldModel : daapDataTableUpForm.getDaapDataFieldList()) {
                daapDataFieldModel.setCreatFieldStatus("\u5df2\u521b\u5efa".equals(daapDataFieldModel.getCreatFieldStatus()) ? "1" : "0");
            }
            List daapDataFieldList = JsonUtil.getJsonToList(daapDataTableUpForm.getDaapDataFieldList(), DaapDataFieldEntity.class);
            Collections.sort(daapDataFieldList, (fristDataField, secondDataField) -> secondDataField.getPrimaryKey() - fristDataField.getPrimaryKey());
            for (DaapDataFieldEntity entitys : daapDataFieldList) {
                List<DaapDataFieldEntity> fieldsByTableList = this.daapDataFieldService.getFieldsByTable(entity.getId());
                for (DaapDataFieldEntity dbField : fieldsByTableList) {
                    if (!dbField.getFieldName().equals(entitys.getFieldName())) continue;
                    this.daapDataFieldService.updateCreatField(daapDataTableUpForm.getDatabaseId(), daapDataTableUpForm.getTableName(), entitys);
                    entitys.setId(dbField.getId());
                    entitys.setCreatFieldStatus(1);
                    entitys.setLastModifyUserId(userInfo.getUserId());
                    entitys.setLastModifyTime(new Date());
                    this.daapDataFieldService.updateById(entitys);
                    fieldStatus = true;
                }
            }
            if (fieldStatus) {
                return ActionResult.success((String)"\u540c\u6b65\u6210\u529f");
            }
            return ActionResult.fail((String)"\u540c\u6b65\u5931\u8d25\uff0c\u4f7f\u7528\u540c\u6b65\u529f\u80fd\u8bf7\u52ff\u4fee\u6539\u5b57\u6bb5\u4fe1\u606f\uff0c\u5982\u9700\u8981\u4fee\u6539\u8bf7\u5148\u4fdd\u5b58");
        }
        return ActionResult.fail((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7269\u7406\u8868\u4fe1\u606f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws Exception {
        DaapDataTableEntity entity = this.daapDataTableService.getInfo(id);
        if (entity != null) {
            this.daapDataTableService.delete(entity);
            QueryWrapper queryWrapperDaapDataColumn = new QueryWrapper();
            queryWrapperDaapDataColumn.lambda().eq(DaapDataFieldEntity::getTableId, (Object)entity.getId());
            this.daapDataFieldService.remove((Wrapper)queryWrapperDaapDataColumn);
            if (entity.getCreatTableStatus() == 1) {
                this.daapDataTableService.deleteRealTable(entity);
            }
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

