/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.datamodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.mapper.DaapDataDatabaseMapper;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataDatabasePagination;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.utils.JdbcUtils;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapDataBaseServiceImpl
extends ServiceImpl<DaapDataDatabaseMapper, DaapDataBaseEntity>
implements DaapDataBaseService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<DaapDataBaseEntity> getList(DaapDataDatabasePagination daapDataDatabasePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int daapDataDatabaseNum = 0;
        QueryWrapper daapDataDatabaseQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)daapDataDatabasePagination.getDbName())) {
            ++daapDataDatabaseNum;
            daapDataDatabaseQueryWrapper.lambda().like(DaapDataBaseEntity::getDbName, (Object)daapDataDatabasePagination.getDbName());
        }
        if (AllIdList.size() > 0) {
            daapDataDatabaseQueryWrapper.lambda().in(DaapDataBaseEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)daapDataDatabasePagination.getSidx())) {
            daapDataDatabaseQueryWrapper.lambda().orderByDesc(DaapDataBaseEntity::getId);
        } else {
            try {
                String sidx = daapDataDatabasePagination.getSidx();
                DaapDataBaseEntity daapDataBaseEntity = new DaapDataBaseEntity();
                Field declaredField = daapDataBaseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                daapDataDatabaseQueryWrapper = "asc".equals(daapDataDatabasePagination.getSort().toLowerCase()) ? (QueryWrapper)daapDataDatabaseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)daapDataDatabaseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(daapDataDatabasePagination.getCurrentPage(), daapDataDatabasePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)daapDataDatabaseQueryWrapper);
            return daapDataDatabasePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return daapDataDatabasePagination.setData(list, list.size());
    }

    @Override
    public DaapDataBaseEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataBaseEntity::getId, (Object)id);
        return (DaapDataBaseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<DaapDataBaseEntity> getByConnectorId(String connectorId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataBaseEntity::getConnectorId, (Object)connectorId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public DaapDataBaseEntity getByConnectorIdAndDbName(String connectorId, String dbName, String schemaName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataBaseEntity::getConnectorId, (Object)connectorId);
        queryWrapper.lambda().eq(DaapDataBaseEntity::getDbName, (Object)dbName);
        if (StringUtils.isNotEmpty((String)schemaName)) {
            queryWrapper.lambda().eq(DaapDataBaseEntity::getSchemaName, (Object)schemaName);
        }
        return (DaapDataBaseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void deleteDataBase(DaapDataBaseEntity entity) throws Exception {
        Connection conn;
        DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(entity.getConnectorId());
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
        if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
            dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
        }
        if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = "DROP DATABASE " + entity.getDbName();
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }

    @Override
    public void create(DaapDataBaseEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapDataBaseEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DaapDataBaseEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

