/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.datamodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.mapper.DaapDataFieldMapper;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.utils.JdbcSqlUtils;
import com.bringspring.daap.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapDataFieldServiceImpl
extends ServiceImpl<DaapDataFieldMapper, DaapDataFieldEntity>
implements DaapDataFieldService {
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapConnectorService daapConnectorService;

    @Override
    public List<DaapDataFieldEntity> getFieldsByTable(String tableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataFieldEntity::getTableId, (Object)tableId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void updateCreatField(String dataBaseId, String tableName, DaapDataFieldEntity entitys) throws Exception {
        Connection conn;
        DaapDataBaseEntity daapDataBaseEntity = this.daapDataBaseService.getInfo(dataBaseId);
        DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(daapDataBaseEntity.getConnectorId());
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
        if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
            dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
        }
        if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = "";
        sql = "1".equals(String.valueOf(entitys.getCreatFieldStatus())) ? JdbcSqlUtils.updateFieldSqlString(daapConnectorEntity.getDataSourceType(), tableName, entitys) : JdbcSqlUtils.addFieldSqlString(daapConnectorEntity.getDataSourceType(), tableName, entitys);
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }
}

