/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.datamodel.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.entity.DaapDataTableEntity;
import com.bringspring.daap.datamodel.mapper.DaapDataTableMapper;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableCrForm;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTablePagination;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableUpForm;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.datamodel.service.DaapDataTableService;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.utils.JdbcSqlUtils;
import com.bringspring.daap.utils.JdbcUtils;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapDataTableServiceImpl
extends ServiceImpl<DaapDataTableMapper, DaapDataTableEntity>
implements DaapDataTableService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DaapDataFieldService daapDataFieldService;
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapConnectorService daapConnectorService;

    @Override
    public List<DaapDataTableEntity> getList(DaapDataTablePagination daapDataTablePagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int daapDataTableNum = 0;
        QueryWrapper daapDataTableQueryWrapper = new QueryWrapper();
        boolean daapDataColumnNum = false;
        QueryWrapper daapDataColumnQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)daapDataTablePagination.getTableName())) {
            ++daapDataTableNum;
            daapDataTableQueryWrapper.lambda().like(DaapDataTableEntity::getTableName, (Object)daapDataTablePagination.getTableName());
        }
        if (StringUtils.isNotEmpty((String)daapDataTablePagination.getDatabaseId())) {
            ++daapDataTableNum;
            daapDataTableQueryWrapper.lambda().like(DaapDataTableEntity::getDataBaseId, (Object)daapDataTablePagination.getDatabaseId());
        }
        if (AllIdList.size() > 0) {
            daapDataTableQueryWrapper.lambda().in(DaapDataTableEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)daapDataTablePagination.getSidx())) {
            daapDataTableQueryWrapper.lambda().orderByDesc(DaapDataTableEntity::getTableName);
        } else {
            try {
                String sidx = daapDataTablePagination.getSidx();
                DaapDataTableEntity daapDataTableEntity = new DaapDataTableEntity();
                Field declaredField = daapDataTableEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                daapDataTableQueryWrapper = "asc".equals(daapDataTablePagination.getSort().toLowerCase()) ? (QueryWrapper)daapDataTableQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)daapDataTableQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(daapDataTablePagination.getCurrentPage(), daapDataTablePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)daapDataTableQueryWrapper);
            return daapDataTablePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return daapDataTablePagination.setData(list, list.size());
    }

    @Override
    public List<DaapDataTableEntity> getListByDataBaseId(String dataBaseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataTableEntity::getDataBaseId, (Object)dataBaseId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public DaapDataTableEntity getListByDataBaseId(String dataBaseId, String tableName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataTableEntity::getDataBaseId, (Object)dataBaseId);
        queryWrapper.lambda().eq(DaapDataTableEntity::getTableName, (Object)tableName);
        return (DaapDataTableEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public DaapDataTableEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataTableEntity::getId, (Object)id);
        return (DaapDataTableEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(DaapDataTableEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapDataTableEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DaapDataTableEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<DaapDataFieldEntity> getDaapDataFieldList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapDataFieldEntity::getTableId, (Object)id);
        return this.daapDataFieldService.list((Wrapper)queryWrapper);
    }

    @Override
    public void creatTable(DaapDataTableCrForm daapDataTableCrForm) throws Exception {
        Connection conn;
        DaapDataBaseEntity daapDataBaseEntity = this.daapDataBaseService.getInfo(daapDataTableCrForm.getDatabaseId());
        DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(daapDataBaseEntity.getConnectorId());
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
        if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
            dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
        }
        if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = JdbcSqlUtils.CreatTableSqlString(daapConnectorEntity.getDataSourceType(), daapDataTableCrForm);
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }

    @Override
    public void deleteRealTable(DaapDataTableEntity entity) throws Exception {
        Connection conn;
        DaapDataBaseEntity daapDataBaseEntity = this.daapDataBaseService.getInfo(entity.getDataBaseId());
        DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(daapDataBaseEntity.getConnectorId());
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
        if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
            dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
        }
        if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = "DROP TABLE " + entity.getTableName();
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }

    @Override
    public void updateCreatTable(DaapDataTableUpForm daapDataTableUpForm) throws Exception {
        Connection conn;
        DaapDataBaseEntity daapDataBaseEntity = this.daapDataBaseService.getInfo(daapDataTableUpForm.getDatabaseId());
        DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(daapDataBaseEntity.getConnectorId());
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
        if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
            dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
        }
        if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(daapDataTableUpForm.getTableName()).append(" COMMENT= '").append(daapDataTableUpForm.getTableComment()).append("'");
        String sql = sb.toString();
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }
}

