/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.controller;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.daap.job.entity.DaapConnectorBackUpEntity;
import com.bringspring.daap.job.entity.DaapConnectorBackUpPlanEntity;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpModel;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpVo;
import com.bringspring.daap.job.service.DaapConnectorBackUpPlanService;
import com.bringspring.daap.job.service.DaapConnectorBackUpService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u805a\u5408\u5206\u6790\u8fde\u63a5\u5668\u6570\u636e\u5e93\u5907\u4efd"}, value="daap")
@RequestMapping(value={"/api/daap/dataBackUp"})
public class DaapConnectorBackUpController {
    private static final Logger log = LoggerFactory.getLogger(DaapConnectorBackUpController.class);
    private static final String DB_BACKUP_KEY = "dbBackUpKey";
    @Autowired
    private DaapConnectorBackUpService daapConnectorBackUpService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private DaapConnectorBackUpPlanService daapConnectorBackUpPlanService;
    @Autowired
    private RedisUtil redisUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapConnectorBackUpModel daapConnectorBackUpModel) throws IOException, NoSuchFieldException {
        List<DaapConnectorBackUpEntity> list = this.daapConnectorBackUpService.getList(daapConnectorBackUpModel);
        List listVO = JsonUtil.getJsonToList(list, DaapConnectorBackUpVo.class);
        for (DaapConnectorBackUpVo entity : listVO) {
            DaapConnectorBackUpPlanEntity planEntity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)entity.getBackupPlanId()));
            if (planEntity != null) {
                entity.setBackupPlanId(planEntity.getPlanName());
            }
            entity.setEnabledMark(this.baseDataUtil.switchSelectValue(String.valueOf(entity.getEnabledMark()), "\u6709\u6548", "\u65e0\u6548"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapConnectorBackUpModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/dataBackUpById"})
    public ActionResult dataBackUpById(@RequestBody String json) {
        String resultStr = null;
        if (StringUtils.isNotEmpty((String)json)) {
            JSONObject backUpJson = JSONObject.parseObject((String)json);
            DaapConnectorBackUpEntity entity = (DaapConnectorBackUpEntity)this.daapConnectorBackUpService.getById((Serializable)((Object)backUpJson.getString("id")));
            if (entity != null) {
                try {
                    resultStr = this.daapConnectorBackUpService.mapping(entity, backUpJson);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f\u662f\u5426\u5b58\u5728\uff0c\u5982\u4e0d\u5b58\u5728\u8bf7\u52fe\u9009\u8fd8\u539f\u8868\u7ed3\u6784\u9009\u9879", 7200L);
                    ActionResult actionResult = ActionResult.success((String)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f\u662f\u5426\u5b58\u5728\uff0c\u5982\u4e0d\u5b58\u5728\u8bf7\u52fe\u9009\u8fd8\u539f\u8868\u7ed3\u6784\u9009\u9879");
                    return actionResult;
                }
                finally {
                    String unZipFilePath = entity.getFilePath() + "/unZip/";
                    FileUtil.del((String)unZipFilePath);
                }
            } else {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u5907\u4efd\u8bb0\u5f55\u4e0d\u5b58\u5728", 7200L);
                resultStr = "\u8fd8\u539f\u5931\u8d25\uff0c\u5907\u4efd\u8bb0\u5f55\u4e0d\u5b58\u5728";
            }
        } else {
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38", 7200L);
            resultStr = "\u8fd8\u539f\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38";
        }
        return ActionResult.success((String)resultStr);
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapConnectorBackUpEntity daapConnectorBackUpEntity = (DaapConnectorBackUpEntity)this.daapConnectorBackUpService.getById((Serializable)((Object)id));
        if (daapConnectorBackUpEntity == null) {
            return ActionResult.success((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String zipFilePath = daapConnectorBackUpEntity.getFilePath() + "/" + daapConnectorBackUpEntity.getFileName();
        FileUtil.del((String)zipFilePath);
        String dbZipFilePath = daapConnectorBackUpEntity.getFilePath() + "/" + daapConnectorBackUpEntity.getDbFileName();
        FileUtil.del((String)dbZipFilePath);
        this.daapConnectorBackUpService.removeById(daapConnectorBackUpEntity);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/findFilesPath"})
    public ActionResult findFilesPath(@RequestBody String homePath) {
        JSONObject backUpJson = JSONObject.parseObject((String)homePath);
        ArrayList<String> fileStrList = new ArrayList<String>();
        ArrayList dbZipList = new ArrayList();
        ArrayList filesZipList = new ArrayList();
        List resultDbZipList = new ArrayList();
        List resultFilesZipList = new ArrayList();
        HashMap map = new HashMap();
        if (StringUtils.isNotEmpty((String)backUpJson.getString("homePath"))) {
            List allFileList = FileUtil.loopFiles((String)backUpJson.getString("homePath"));
            for (File file : allFileList) {
                fileStrList.add(StringUtils.replace((String)file.toString(), (String)"\\", (String)"/"));
            }
            for (int i = 0; i < fileStrList.size(); ++i) {
                if (((String)fileStrList.get(i)).contains("\u9644\u4ef6\u5907\u4efd")) {
                    filesZipList.add(fileStrList.get(i));
                    continue;
                }
                dbZipList.add(fileStrList.get(i));
            }
            Collections.reverse(dbZipList);
            Collections.reverse(filesZipList);
            resultDbZipList = dbZipList.size() > 10 ? dbZipList.subList(0, 10) : dbZipList;
            resultFilesZipList = filesZipList.size() > 10 ? filesZipList.subList(0, 10) : filesZipList;
        }
        map.put("resultDbZipList", resultDbZipList);
        map.put("resultFilesZipList", resultFilesZipList);
        return ActionResult.success(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/restorSubmit"})
    public ActionResult restorSubmit(@RequestBody String json) {
        JSONObject backUpJson = JSONObject.parseObject((String)json);
        String resultStr = "";
        if (StringUtils.isEmpty((String)backUpJson.getString("dbFileZip")) && StringUtils.isEmpty((String)backUpJson.getString("filesZip"))) {
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25,\u8bf7\u9009\u62e9\u8981\u8fd8\u539f\u7684\u6570\u636e\u5e93\u6587\u4ef6/\u9644\u4ef6\u6587\u4ef6\uff01\uff0c", 7200L);
            return ActionResult.success((String)"\u8fd8\u539f\u5931\u8d25,\u8bf7\u9009\u62e9\u8981\u8fd8\u539f\u7684\u6570\u636e\u5e93\u6587\u4ef6/\u9644\u4ef6\u6587\u4ef6\uff01");
        }
        if ("0".equals(backUpJson.getString("dbStructure")) && "0".equals(backUpJson.getString("dbData")) && "0".equals(backUpJson.getString("filesInfo"))) {
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25,\u8bf7\u9009\u62e9\u8981\u8fd8\u539f\u7684\u6570\u636e\u7c7b\u578b\uff01", 7200L);
            return ActionResult.success((String)"\u8fd8\u539f\u5931\u8d25,\u8bf7\u9009\u62e9\u8981\u8fd8\u539f\u7684\u6570\u636e\u7c7b\u578b\uff01");
        }
        try {
            resultStr = this.daapConnectorBackUpService.restorSubmit(backUpJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f\u662f\u5426\u5b58\u5728\uff0c\u5982\u4e0d\u5b58\u5728\u8bf7\u52fe\u9009\u8fd8\u539f\u8868\u7ed3\u6784\u9009\u9879", 7200L);
            ActionResult actionResult = ActionResult.success((String)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f\u662f\u5426\u5b58\u5728\uff0c\u5982\u4e0d\u5b58\u5728\u8bf7\u52fe\u9009\u8fd8\u539f\u8868\u7ed3\u6784\u9009\u9879");
            return actionResult;
        }
        finally {
            String unZipFilePath = backUpJson.getString("homePath") + "/unZip/";
            FileUtil.del((String)unZipFilePath);
        }
        return ActionResult.success((String)resultStr);
    }
}

