/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.job.entity.DaapConnectorBackUpPlanEntity;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpPlanForm;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpPlanModel;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpPlanVo;
import com.bringspring.daap.job.service.DaapConnectorBackUpPlanService;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.daap.job.service.DataBackUpAndRestoreService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u805a\u5408\u5206\u6790\u8fde\u63a5\u5668\u6570\u636e\u5e93\u5907\u4efd"}, value="daap")
@RequestMapping(value={"/api/daap/dataBackUpPlan"})
public class DaapConnectorBackUpPlanController {
    private static final Logger log = LoggerFactory.getLogger(DaapConnectorBackUpPlanController.class);
    private static final String DB_BACKUP_KEY = "dbBackUpKey";
    @Autowired
    private DaapConnectorBackUpPlanService daapConnectorBackUpPlanService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DataBackUpAndRestoreService dataBackUpAndRestoreService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RedisUtil redisUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapConnectorBackUpPlanModel daapConnectorBackUpPlanModel) throws IOException, NoSuchFieldException {
        List<DaapConnectorBackUpPlanEntity> list = this.daapConnectorBackUpPlanService.getList(daapConnectorBackUpPlanModel);
        List listVO = JsonUtil.getJsonToList(list, DaapConnectorBackUpPlanVo.class);
        for (DaapConnectorBackUpPlanVo entity : listVO) {
            entity.setEnabledMark(this.baseDataUtil.switchSelectValue(String.valueOf(entity.getEnabledMark()), "\u6709\u6548", "\u65e0\u6548"));
            entity.setBackFiles(this.baseDataUtil.switchSelectValue(String.valueOf(entity.getBackFiles()), "\u5907\u4efd", "\u4e0d\u5907\u4efd"));
            DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(entity.getConnectorId());
            DaapJobClusterEntity daapJobClusterEntity = this.daapJobClusterService.getInfo(entity.getClusterId());
            if (daapConnectorEntity != null) {
                entity.setConnectorId(daapConnectorEntity.getDataSourceName());
            }
            if (daapJobClusterEntity == null) continue;
            entity.setClusterId(daapJobClusterEntity.getName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapConnectorBackUpPlanModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapConnectorBackUpPlanForm daapConnectorBackUpPlanForm) throws DataException {
        String mainId = RandomUtil.uuId();
        daapConnectorBackUpPlanForm.setFilePath(StringUtils.replace((String)daapConnectorBackUpPlanForm.getFilePath(), (String)"\uff1a", (String)":"));
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)JsonUtil.getJsonToBean((Object)((Object)daapConnectorBackUpPlanForm), DaapConnectorBackUpPlanEntity.class);
        entity.setId(mainId);
        entity.setDeleteMark(0);
        this.daapConnectorBackUpPlanService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult findBackUpSql(@PathVariable(value="id") String id) {
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)id));
        String resultStr = null;
        if (entity != null) {
            try {
                resultStr = this.dataBackUpAndRestoreService.mapping(entity);
            }
            catch (Exception e) {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u5907\u4efd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", 7200L);
                e.printStackTrace();
                return ActionResult.success((String)"\u5907\u4efd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u5907\u4efd\u5931\u8d25\uff0c\u5907\u4efd\u8ba1\u5212\u4e0d\u5b58\u5728", 7200L);
            return ActionResult.success((String)"\u5907\u4efd\u5931\u8d25\uff0c\u5907\u4efd\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)resultStr);
    }

    @GetMapping(value={"/findProgressFlag/{redisKey}"})
    public ActionResult findProgressFlag(@PathVariable(value="redisKey") String redisKey) {
        Object resultObj = this.dataBackUpAndRestoreService.findProgressFlag(redisKey);
        return ActionResult.success((Object)resultObj);
    }

    @GetMapping(value={"/findSuccessProgressFlag/{redisKey}"})
    public ActionResult findSuccessProgressFlag(@PathVariable(value="redisKey") String redisKey) {
        Object resultObj = this.redisUtil.getString(redisKey);
        if (resultObj != null && ("100".equals(resultObj.toString()) || "\u5931\u8d25".equals(resultObj.toString()))) {
            this.dataBackUpAndRestoreService.delRedisKey(redisKey);
        }
        resultObj = this.redisUtil.getString(redisKey);
        return ActionResult.success((Object)resultObj);
    }

    @DeleteMapping(value={"/delRedisKey/{redisKey}"})
    public ActionResult delRedisKey(@PathVariable(value="redisKey") String redisKey) {
        this.dataBackUpAndRestoreService.delRedisKey(redisKey);
        return ActionResult.success((String)"\u5220\u9664\u6210");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapConnectorBackUpPlanVo> detailInfo(@PathVariable(value="id") String id) {
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)id));
        DaapConnectorBackUpPlanVo vo = (DaapConnectorBackUpPlanVo)JsonUtil.getJsonToBean((Object)entity, DaapConnectorBackUpPlanVo.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapConnectorBackUpPlanForm daapConnectorBackUpPlanForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)id));
        if (entity != null) {
            daapConnectorBackUpPlanForm.setFilePath(StringUtils.replace((String)daapConnectorBackUpPlanForm.getFilePath(), (String)"\uff1a", (String)":"));
            DaapConnectorBackUpPlanEntity subentity = (DaapConnectorBackUpPlanEntity)JsonUtil.getJsonToBean((Object)((Object)daapConnectorBackUpPlanForm), DaapConnectorBackUpPlanEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(DateUtil.getNowDate());
            this.daapConnectorBackUpPlanService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)id));
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            entity.setDeleteMark(1);
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(userInfo.getUserId());
            this.daapConnectorBackUpPlanService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/goBackDel/{id}"})
    public ActionResult goBackDel(@PathVariable(value="id") String id) {
        DaapConnectorBackUpPlanEntity entity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)id));
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            entity.setDeleteMark(0);
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userInfo.getUserId());
            this.daapConnectorBackUpPlanService.update(id, entity);
        }
        return ActionResult.success((String)"\u64a4\u9500\u6210\u529f");
    }

    @GetMapping(value={"/getResourcesPath"})
    public ActionResult getResourcesPath() {
        String path = this.configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        return ActionResult.success((String)path);
    }
}

