/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataBaseModel;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorCrForm;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorInfoVO;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorListVO;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorPagination;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorUpForm;
import com.bringspring.daap.job.model.daapconnector.DaapConnerctorCopyForm;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u6e90\u7ba1\u7406\u8868"}, value="daap")
@RequestMapping(value={"/api/daap/connector"})
public class DaapConnectorController {
    private static final Logger log = LoggerFactory.getLogger(DaapConnectorController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapConnectorService daapConnectorService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapConnectorPagination daapConnectorPagination) throws IOException {
        List<DaapConnectorEntity> list = this.daapConnectorService.getList(daapConnectorPagination);
        for (DaapConnectorEntity daapConnectorEntity : list) {
            daapConnectorEntity.setEnabledMark(this.baseDataUtil.switchSelectValue(String.valueOf(daapConnectorEntity.getEnabledMark()), "\u6709\u6548", "\u65e0\u6548"));
            daapConnectorEntity.setReadonlyState(this.baseDataUtil.switchSelectValue(String.valueOf(daapConnectorEntity.getReadonlyState()), "\u662f", "\u5426"));
            daapConnectorEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(daapConnectorEntity.getCreatorUserId()));
            daapConnectorEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(daapConnectorEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DaapConnectorListVO.class);
        for (DaapConnectorListVO daapConnectorListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapConnectorPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapConnectorCrForm daapConnectorCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        daapConnectorCrForm.setCreatorUserId(userInfo.getUserId());
        daapConnectorCrForm.setCreatorTime(DateUtil.getNow());
        DaapConnectorEntity entity = (DaapConnectorEntity)JsonUtil.getJsonToBean((Object)daapConnectorCrForm, DaapConnectorEntity.class);
        entity.setId(mainId);
        this.daapConnectorService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapConnectorInfoVO> info(@PathVariable(value="id") String id) {
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        DaapConnectorInfoVO vo = (DaapConnectorInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapConnectorInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapConnectorInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        DaapConnectorInfoVO vo = (DaapConnectorInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapConnectorInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapConnectorUpForm daapConnectorUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        if (entity != null) {
            daapConnectorUpForm.setLastModifyUserId(userInfo.getUserId());
            daapConnectorUpForm.setLastModifyTime(DateUtil.getNow());
            DaapConnectorEntity subentity = (DaapConnectorEntity)JsonUtil.getJsonToBean((Object)daapConnectorUpForm, DaapConnectorEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.daapConnectorService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        if (entity != null) {
            this.daapConnectorService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/syncDataCatalog/{id}"})
    public ActionResult syncDataSource(@PathVariable(value="id") String id) throws DataException {
        this.daapConnectorService.syncDataSource(id);
        return ActionResult.success((String)"\u540c\u6b65\u6570\u636e\u6e90\u7684\u6570\u636e\u5143\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/getDbTableList/{id}"})
    public ActionResult getDbTableList(@PathVariable String id) throws DataException {
        List<DaapDataBaseModel> dataTableModels = this.daapConnectorService.getDbTableList(id);
        return ActionResult.success((String)"\u83b7\u53d6\u6570\u636e\u6e90\u4e0b\u7684\u8868\u5217\u8868\u6570\u636e\u6210\u529f", dataTableModels);
    }

    @PostMapping(value={"/getDbTableListByConnectorId/{id}"})
    public ActionResult getDbTableListByConnectorId(@PathVariable String id) throws DataException {
        List<DaapDataBaseModel> dataTableModels = this.daapConnectorService.getDbTableListByConnectorId(id);
        return ActionResult.success((String)"\u514b\u9686\u6570\u636e\u5143\u6570\u636e\u6210\u529f", dataTableModels);
    }

    @GetMapping(value={"/typeChang/{id}"})
    public ActionResult typeChang(@PathVariable(value="id") String id) throws RuntimeException {
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (ObjectUtil.isNotNull((Object)entity)) {
            DaapConnectorInfoVO vo = (DaapConnectorInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapConnectorInfoVO.class);
            String type = vo.getDataSourceType();
            JSONObject dataSourceProperties = JSON.parseObject((String)vo.getDataSourceProperties());
            dataSourceModel = this.daapConnectorService.typeChang(dataSourceProperties, type);
        }
        return ActionResult.success((Object)dataSourceModel);
    }

    @PostMapping(value={"/fromDataChang"})
    public ActionResult fromDataChang(@RequestBody String json) throws RuntimeException {
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            JSONObject dataSourceProperties = JSONObject.parseObject((String)json);
            String type = dataSourceProperties.getString("connector");
            dataSourceModel = this.daapConnectorService.typeChang(dataSourceProperties, type);
        }
        return ActionResult.success((Object)dataSourceModel);
    }

    @GetMapping(value={"/DataTypeChang/{id}"})
    public ActionResult DataTypeChang(@PathVariable(value="id") String id) throws RuntimeException {
        DaapConnectorEntity entity = this.daapConnectorService.getInfo(id);
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
        if (ObjectUtil.isNotNull((Object)entity)) {
            DaapConnectorInfoVO vo = (DaapConnectorInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapConnectorInfoVO.class);
            String type = vo.getDataSourceType();
            JSONObject dataSourceProperties = JSON.parseObject((String)vo.getDataSourceProperties());
            resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, type);
        }
        return ActionResult.success(resultMap);
    }

    @PostMapping(value={"/copyDataBaseAndTable"})
    public ActionResult copyDataBaseAndTable(@RequestBody @Valid DaapConnerctorCopyForm daapConnerctorCopyForm) throws RuntimeException {
        if (ObjectUtil.isNull((Object)daapConnerctorCopyForm)) {
            return ActionResult.success((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)daapConnerctorCopyForm.getId())) {
            return ActionResult.success((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u8fde\u63a5\u5668\u4fe1\u606f");
        }
        if (ObjectUtil.isEmpty(daapConnerctorCopyForm.getDaapDataBaseList())) {
            return ActionResult.success((String)"\u8bf7\u9009\u62e9\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u7684\u8868\u4fe1\u606f");
        }
        int saveNum = this.daapConnectorService.copyDataBaseAndTable(daapConnerctorCopyForm);
        if (saveNum > 0) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.success((String)"\u7cfb\u7edf\u5f02\u5e38");
    }
}

