/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.capture.service.DaapCaptureConfigService;
import com.bringspring.daap.job.entity.DaapJobSourceEntity;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourceCrForm;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourceInfoVO;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourceListVO;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourcePagination;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourceUpForm;
import com.bringspring.daap.job.service.DaapJobSourceService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f5c\u4e1a\u6e90"}, value="daap")
@RequestMapping(value={"/api/daap/DaapJobSource"})
public class DaapJobSourceController {
    private static final Logger log = LoggerFactory.getLogger(DaapJobSourceController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapJobSourceService daapJobSourceService;
    @Autowired
    private DaapCaptureConfigService daapCaptureConfigService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapJobSourcePagination daapJobSourcePagination) throws IOException {
        List<DaapJobSourceEntity> list = this.daapJobSourceService.getList(daapJobSourcePagination);
        List listVO = JsonUtil.getJsonToList(list, DaapJobSourceListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapJobSourcePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapJobSourceCrForm daapJobSourceCrForm) throws Exception {
        DaapJobSourceEntity entity = (DaapJobSourceEntity)JsonUtil.getJsonToBean((Object)daapJobSourceCrForm, DaapJobSourceEntity.class);
        entity.setId(RandomUtil.uuId());
        this.daapJobSourceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PostMapping(value={"/check/{id}"})
    public ActionResult<DaapJobSourceInfoVO> check(@PathVariable(value="id") String id) throws Exception {
        String check = this.daapJobSourceService.check(id);
        return ActionResult.success((String)check);
    }

    @PostMapping(value={"/submit/{id}"})
    public ActionResult<DaapJobSourceInfoVO> submit(@PathVariable(value="id") String id) throws Exception {
        this.daapJobSourceService.submit(id);
        return ActionResult.success();
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapJobSourceInfoVO> info(@PathVariable(value="id") String id) throws Exception {
        DaapJobSourceEntity entity = this.daapJobSourceService.getInfo(id);
        DaapJobSourceInfoVO vo = (DaapJobSourceInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobSourceInfoVO.class);
        if (StringUtils.isNotEmpty((String)entity.getCaptureConfigId())) {
            String flinkSql = this.daapCaptureConfigService.getCaptureCreatTableSqlById(entity.getCaptureConfigId());
            if ("\u6240\u5173\u8054\u7684\u91c7\u96c6\u5411\u5bfc\u4e0d\u5b58\u5728".equals(flinkSql)) {
                vo.setCaptureConfigSql(null);
            } else {
                vo.setCaptureConfigSql(flinkSql);
            }
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapJobSourceUpForm daapJobSourceUpForm) throws Exception {
        DaapJobSourceEntity entity = this.daapJobSourceService.getInfo(id);
        if (entity != null) {
            DaapJobSourceEntity subentity = (DaapJobSourceEntity)JsonUtil.getJsonToBean((Object)daapJobSourceUpForm, DaapJobSourceEntity.class);
            this.daapJobSourceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/updateHighConfig/{id}"})
    @DSTransactional
    public ActionResult updateHighConfig(@PathVariable(value="id") String id, @RequestBody @Valid DaapJobSourceUpForm daapJobSourceUpForm) throws DataException {
        DaapJobSourceEntity entity = this.daapJobSourceService.getInfo(id);
        if (entity != null) {
            entity.setConfigContent(daapJobSourceUpForm.getConfigContent());
            this.daapJobSourceService.update(id, entity);
            return ActionResult.success((String)"\u66f4\u65b0\u914d\u7f6e\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u914d\u7f6e\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapJobSourceEntity entity = this.daapJobSourceService.getInfo(id);
        if (entity != null) {
            this.daapJobSourceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

