/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.daap.capture.model.mapping.MappingTableSqlModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataFieldModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableCrForm;
import com.bringspring.daap.job.entity.DaapConnectorBackUpEntity;
import com.bringspring.daap.job.entity.DaapConnectorBackUpPlanEntity;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.mapper.DaapConnectorBackUpMapper;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorBackUpModel;
import com.bringspring.daap.job.service.DaapConnectorBackUpPlanService;
import com.bringspring.daap.job.service.DaapConnectorBackUpService;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.daap.utils.JdbcSqlUtils;
import com.bringspring.daap.utils.JdbcUtils;
import com.bringspring.database.MySqlTypeMapper;
import com.bringspring.database.OracleTypeMapper;
import com.bringspring.database.PostgresTypeMapper;
import com.bringspring.database.SqlSeverTypeMapper;
import com.bringspring.files.utils.ZipUtils;
import com.bringspring.flink.handler.service.environment.FlinkEnvironmentHandle;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapConnectorBackUpServiceImpl
extends ServiceImpl<DaapConnectorBackUpMapper, DaapConnectorBackUpEntity>
implements DaapConnectorBackUpService {
    private static final Logger LOG = LoggerFactory.getLogger(DaapConnectorBackUpServiceImpl.class);
    private static final String DB_BACKUP_KEY = "dbBackUpKey";
    @Autowired
    private DaapConnectorBackUpPlanService daapConnectorBackUpPlanService;
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<DaapConnectorBackUpEntity> getList(DaapConnectorBackUpModel daapConnectorBackUpModel) throws NoSuchFieldException {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int daapDataSourceNum = 0;
        QueryWrapper daapConnectorBackUpWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorBackUpModel.getBackupDbName())) {
            ++daapDataSourceNum;
            daapConnectorBackUpWrapper.lambda().like(DaapConnectorBackUpEntity::getBackupDbName, (Object)daapConnectorBackUpModel.getBackupDbName());
        }
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorBackUpModel.getFileName())) {
            ++daapDataSourceNum;
            daapConnectorBackUpWrapper.lambda().like(DaapConnectorBackUpEntity::getFileName, (Object)daapConnectorBackUpModel.getFileName());
        }
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorBackUpModel.getDbFileName())) {
            ++daapDataSourceNum;
            daapConnectorBackUpWrapper.lambda().like(DaapConnectorBackUpEntity::getDbFileName, (Object)daapConnectorBackUpModel.getDbFileName());
        }
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorBackUpModel.getEnabledMark())) {
            ++daapDataSourceNum;
            daapConnectorBackUpWrapper.lambda().like(DaapConnectorBackUpEntity::getEnabledMark, (Object)daapConnectorBackUpModel.getEnabledMark());
        }
        String sidx = daapConnectorBackUpModel.getSidx();
        DaapConnectorBackUpEntity daapConnectorBackUpEntity = new DaapConnectorBackUpEntity();
        Field declaredField = daapConnectorBackUpEntity.getClass().getDeclaredField(sidx);
        declaredField.setAccessible(true);
        String value = declaredField.getAnnotation(TableField.class).value();
        QueryWrapper queryWrapper = daapConnectorBackUpWrapper = "asc".equals(daapConnectorBackUpModel.getSort().toLowerCase()) ? (QueryWrapper)daapConnectorBackUpWrapper.orderByAsc((Object)value) : (QueryWrapper)daapConnectorBackUpWrapper.orderByDesc((Object)value);
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(daapConnectorBackUpModel.getCurrentPage(), daapConnectorBackUpModel.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)daapConnectorBackUpWrapper);
            return daapConnectorBackUpModel.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return daapConnectorBackUpModel.setData(list, list.size());
    }

    @Override
    public String mapping(DaapConnectorBackUpEntity entity, JSONObject backUpJson) throws Exception {
        if (this.redisUtil.getString(DB_BACKUP_KEY) != null) {
            return "\u5df2\u6709\u5907\u4efd\u8ba1\u5212/\u8fd8\u539f\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u7a0d\u540e\u91cd\u8bd5";
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)0, 7200L);
        JSONArray backUpList = backUpJson.getJSONArray("backUpList");
        String backUpStr = JSON.toJSONString((Object)backUpList);
        DaapConnectorBackUpPlanEntity planEntity = (DaapConnectorBackUpPlanEntity)this.daapConnectorBackUpPlanService.getById((Serializable)((Object)entity.getBackupPlanId()));
        if (backUpStr.contains("\u8fd8\u539f\u9644\u4ef6")) {
            String docmentZipFilePath = entity.getFilePath() + "/" + entity.getFileName();
            ZipUtils.unZip((String)docmentZipFilePath, (String)this.configValueUtil.getPath(), (String)"rkkj88888888");
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)15, 7200L);
        if (backUpStr.contains("\u8fd8\u539f\u7ed3\u6784") || backUpStr.contains("\u8fd8\u539f\u6570\u636e")) {
            String zipFilePath = entity.getFilePath() + "/" + entity.getDbFileName();
            String unZipFilePath = entity.getFilePath() + "/unZip/";
            FileUtil.del((String)unZipFilePath);
            ZipUtils.unZip((String)zipFilePath, (String)unZipFilePath, (String)"rkkj88888888");
            List allFileList = FileUtil.loopFiles((String)unZipFilePath);
            ArrayList<File> tableStructureList = new ArrayList<File>();
            ArrayList<File> fieldStructureList = new ArrayList<File>();
            ArrayList<File> dataList = new ArrayList<File>();
            for (File file : allFileList) {
                if ("table_structure".equals(file.getName())) {
                    tableStructureList.add(file);
                    continue;
                }
                if ("field_structure".equals(file.getName())) {
                    fieldStructureList.add(file);
                    continue;
                }
                dataList.add(file);
            }
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)20, 7200L);
            Configuration configuration = new Configuration();
            configuration.setString(String.valueOf(RestOptions.PORT), "8081");
            StreamExecutionEnvironment remoteEnvironment = null;
            DaapJobClusterEntity clusterEntity = this.daapJobClusterService.getInfo(planEntity.getClusterId());
            remoteEnvironment = clusterEntity.getType().equals("remote") ? FlinkEnvironmentHandle.createRemoteEnvironment(clusterEntity.getJobManagerHost(), clusterEntity.getPort()) : StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)configuration);
            remoteEnvironment.setParallelism(2);
            remoteEnvironment.setRuntimeMode(RuntimeExecutionMode.BATCH);
            StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)remoteEnvironment);
            configuration.setString("pipeline.name", entity.getBackupDbName());
            StreamStatementSet statementSet = tableEnv.createStatementSet();
            ArrayList<DaapDataTableCrForm> backList = new ArrayList<DaapDataTableCrForm>();
            try {
                long time1 = System.currentTimeMillis();
                List<Map<String, String>> mapList = DaapConnectorBackUpServiceImpl.findTableStr1(entity.getBackupDbName(), tableStructureList, fieldStructureList);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (Map<String, String> map : mapList) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        resultMap.put(entry.getKey(), entry.getValue());
                    }
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)30, 7200L);
                long time21 = System.currentTimeMillis();
                LOG.info("\u6267\u884c\u5e93\u8868\u89e3\u6790\u8017\u65f6\uff01" + (time21 - time1));
                for (File tableFile : tableStructureList) {
                    String tabName1 = DaapConnectorBackUpServiceImpl.subString(tableFile.toString(), "/unZip/" + entity.getBackupDbName() + "/", "/table_structure/table_structure");
                    JSONObject tableObject = JSON.parseObject((String)((String)resultMap.get(tabName1 + "_table")));
                    JSONArray jsonArray = JSON.parseArray((String)((String)resultMap.get(tabName1 + "_field")));
                    DaapDataTableCrForm daapDataTableCrForm = new DaapDataTableCrForm();
                    ArrayList<DaapDataFieldModel> daapDataFieldList = new ArrayList<DaapDataFieldModel>();
                    if (tableObject != null) {
                        daapDataTableCrForm.setDatabaseId(planEntity.getConnectorId());
                        daapDataTableCrForm.setTableName(tableObject.getString("table"));
                        daapDataTableCrForm.setTableComment(tableObject.getString("tableComment"));
                    }
                    if (jsonArray != null && jsonArray.size() > 0) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            DaapDataFieldModel daapDataFieldModel = new DaapDataFieldModel();
                            daapDataFieldModel.setAllowNull(jsonObject.getIntValue("allowNull"));
                            if (!StringUtils.isNumeric((CharSequence)jsonObject.getString("dataLength"))) {
                                if (jsonObject.getString("dataType").toLowerCase().contains("int")) {
                                    daapDataFieldModel.setDataLength("10");
                                } else {
                                    daapDataFieldModel.setDataLength(null);
                                }
                            } else {
                                daapDataFieldModel.setDataLength(jsonObject.getString("dataLength"));
                            }
                            daapDataFieldModel.setFieldName(jsonObject.getString("field"));
                            daapDataFieldModel.setDataType(jsonObject.getString("columnType"));
                            daapDataFieldModel.setFieldComment(jsonObject.getString("fieldName"));
                            daapDataFieldModel.setPrimaryKey(jsonObject.getIntValue("primaryKey"));
                            daapDataFieldList.add(daapDataFieldModel);
                        }
                    }
                    daapDataTableCrForm.setDaapDataFieldList(daapDataFieldList);
                    backList.add(daapDataTableCrForm);
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)40, 7200L);
                long time2 = System.currentTimeMillis();
                LOG.info("\u5c01\u88c5\u5efa\u8868\u6570\u636e--------------------\uff01" + (time2 - time21));
                String resultStr = "";
                if (backUpStr.contains("\u8fd8\u539f\u7ed3\u6784")) {
                    this.creatTable(backList);
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)50, 7200L);
                long time3 = System.currentTimeMillis();
                LOG.info("\u6267\u884c\u6570\u636e\u5e93\u7ed3\u6784\u521b\u5efa\u8017\u65f6\uff01" + (time3 - time2));
                if (backUpStr.contains("\u8fd8\u539f\u6570\u636e")) {
                    DaapConnectorEntity sourceConnector = this.daapConnectorService.getInfo(planEntity.getConnectorId());
                    DbConnDTO connDTO = this.setResource(sourceConnector);
                    DataSourceModel sourceModel = (DataSourceModel)JsonUtil.getJsonToBean((String)sourceConnector.getDataSourceProperties(), DataSourceModel.class);
                    for (File dataFile : dataList) {
                        String tabName3 = DaapConnectorBackUpServiceImpl.subString(dataFile.toString(), "/unZip/" + entity.getBackupDbName() + "/", "/data/");
                        for (DaapDataTableCrForm daapDataTableCrForm : backList) {
                            if (!tabName3.toUpperCase().equals(daapDataTableCrForm.getTableName().toUpperCase())) continue;
                            MappingTableSqlModel tableSqlModel = this.dataBackUpSql(dataFile.toString(), sourceModel, daapDataTableCrForm, connDTO);
                            tableEnv.executeSql(tableSqlModel.getSourceTableSql());
                            tableEnv.executeSql(tableSqlModel.getSinkTableSql());
                            statementSet.addInsertSql(tableSqlModel.getInsertSql());
                        }
                    }
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)60, 7200L);
                    long time4 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u6784\u5efa\u8017\u65f6\uff01" + (time4 - time3));
                    TableResult result = statementSet.execute();
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)80, 7200L);
                    long time5 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u4efb\u52a1\u63d0\u4ea4\uff01" + (time5 - time4));
                    ((JobClient)result.getJobClient().get()).getJobExecutionResult().get();
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)95, 7200L);
                    long time6 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u4efb\u52a1\u5b8c\u6210---------------\uff01" + (time6 - time5));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)100, 7200L);
        return "\u8fd8\u539f\u6210\u529f";
    }

    @Override
    public String restorSubmit(JSONObject jsonObject) throws Exception {
        if (this.redisUtil.getString(DB_BACKUP_KEY) != null) {
            return "\u5df2\u6709\u5907\u4efd\u8ba1\u5212/\u8fd8\u539f\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u7a0d\u540e\u91cd\u8bd5";
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)0, 7200L);
        if ("1".equals(jsonObject.getString("filesInfo"))) {
            if (StringUtils.isEmpty((CharSequence)jsonObject.getString("filesZip"))) {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u9644\u4ef6\uff01", 7200L);
                return "\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u9644\u4ef6\uff01";
            }
            String docmentZipFilePath = jsonObject.getString("filesZip");
            ZipUtils.unZip((String)docmentZipFilePath, (String)this.configValueUtil.getPath(), (String)"rkkj88888888");
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)15, 7200L);
        if ("1".equals(jsonObject.getString("dbStructure")) || "1".equals(jsonObject.getString("dbData"))) {
            if (StringUtils.isEmpty((CharSequence)jsonObject.getString("dbFileZip"))) {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u4fe1\u606f\u9644\u4ef6\uff01", 7200L);
                return "\u8fd8\u539f\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u4fe1\u606f\u9644\u4ef6\uff01";
            }
            String zipFilePath = jsonObject.getString("dbFileZip");
            String unZipFilePath = jsonObject.getString("homePath") + "/unZip/";
            FileUtil.del((String)unZipFilePath);
            ZipUtils.unZip((String)zipFilePath, (String)unZipFilePath, (String)"rkkj88888888");
            List allFileList = FileUtil.loopFiles((String)unZipFilePath);
            ArrayList<File> tableStructureList = new ArrayList<File>();
            ArrayList<File> fieldStructureList = new ArrayList<File>();
            ArrayList<File> dataList = new ArrayList<File>();
            for (File file : allFileList) {
                if ("table_structure".equals(file.getName())) {
                    tableStructureList.add(file);
                    continue;
                }
                if ("field_structure".equals(file.getName())) {
                    fieldStructureList.add(file);
                    continue;
                }
                dataList.add(file);
            }
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)20, 7200L);
            Configuration configuration = new Configuration();
            configuration.setString(String.valueOf(RestOptions.PORT), "8081");
            StreamExecutionEnvironment remoteEnvironment = null;
            DaapJobClusterEntity clusterEntity = this.daapJobClusterService.getInfo(jsonObject.getString("clusterId"));
            remoteEnvironment = clusterEntity.getType().equals("remote") ? FlinkEnvironmentHandle.createRemoteEnvironment(clusterEntity.getJobManagerHost(), clusterEntity.getPort()) : StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)configuration);
            remoteEnvironment.setParallelism(2);
            remoteEnvironment.setRuntimeMode(RuntimeExecutionMode.BATCH);
            StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)remoteEnvironment);
            File allFile = new File(unZipFilePath);
            File[] fileArray = allFile.listFiles();
            String dbPath = "";
            String dbName = "";
            if (fileArray.length <= 0 || fileArray.length >= 2) {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b63\u786e\u7684\u76ee\u5f55\uff01", 7200L);
                return "\u8fd8\u539f\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b63\u786e\u7684\u76ee\u5f55\uff01";
            }
            dbPath = fileArray[0].toString();
            dbPath = StringUtils.replace((String)dbPath, (String)"\\", (String)"/");
            File lastFile = new File(dbPath);
            if (!lastFile.exists()) {
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)"\u8fd8\u539f\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b63\u786e\u7684\u76ee\u5f55\uff01", 7200L);
                return "\u8fd8\u539f\u5931\u8d25\uff0c\u672a\u627e\u5230\u6b63\u786e\u7684\u76ee\u5f55\uff01";
            }
            dbName = lastFile.getName();
            configuration.setString("pipeline.name", dbName);
            StreamStatementSet statementSet = tableEnv.createStatementSet();
            ArrayList<DaapDataTableCrForm> backList = new ArrayList<DaapDataTableCrForm>();
            try {
                long time1 = System.currentTimeMillis();
                List<Map<String, String>> mapList = DaapConnectorBackUpServiceImpl.findTableStr1(dbName, tableStructureList, fieldStructureList);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (Map<String, String> map : mapList) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        resultMap.put(entry.getKey(), entry.getValue());
                    }
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)30, 7200L);
                long time21 = System.currentTimeMillis();
                LOG.info("\u6267\u884c\u5e93\u8868\u89e3\u6790\u8017\u65f6\uff01" + (time21 - time1));
                for (File tableFile : tableStructureList) {
                    String tabName1 = DaapConnectorBackUpServiceImpl.subString(tableFile.toString(), "/unZip/" + dbName + "/", "/table_structure/table_structure");
                    JSONObject tableObject = JSON.parseObject((String)((String)resultMap.get(tabName1 + "_table")));
                    JSONArray jsonArray = JSON.parseArray((String)((String)resultMap.get(tabName1 + "_field")));
                    DaapDataTableCrForm daapDataTableCrForm = new DaapDataTableCrForm();
                    ArrayList<DaapDataFieldModel> daapDataFieldList = new ArrayList<DaapDataFieldModel>();
                    if (tableObject != null) {
                        daapDataTableCrForm.setDatabaseId(jsonObject.getString("connectorId"));
                        daapDataTableCrForm.setTableName(tableObject.getString("table"));
                        daapDataTableCrForm.setTableComment(tableObject.getString("tableComment"));
                    }
                    if (jsonArray != null && jsonArray.size() > 0) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject jsonOFieldbject = jsonArray.getJSONObject(i);
                            DaapDataFieldModel daapDataFieldModel = new DaapDataFieldModel();
                            daapDataFieldModel.setAllowNull(jsonOFieldbject.getIntValue("allowNull"));
                            if (!StringUtils.isNumeric((CharSequence)jsonOFieldbject.getString("dataLength"))) {
                                if (jsonOFieldbject.getString("dataType").toLowerCase().contains("int")) {
                                    daapDataFieldModel.setDataLength("10");
                                } else {
                                    daapDataFieldModel.setDataLength(null);
                                }
                            } else {
                                daapDataFieldModel.setDataLength(jsonOFieldbject.getString("dataLength"));
                            }
                            daapDataFieldModel.setFieldName(jsonOFieldbject.getString("field"));
                            daapDataFieldModel.setDataType(jsonOFieldbject.getString("columnType"));
                            daapDataFieldModel.setFieldComment(jsonOFieldbject.getString("fieldName"));
                            daapDataFieldModel.setPrimaryKey(jsonOFieldbject.getIntValue("primaryKey"));
                            daapDataFieldList.add(daapDataFieldModel);
                        }
                    }
                    daapDataTableCrForm.setDaapDataFieldList(daapDataFieldList);
                    backList.add(daapDataTableCrForm);
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)40, 7200L);
                long time2 = System.currentTimeMillis();
                LOG.info("\u5c01\u88c5\u5efa\u8868\u6570\u636e--------------------\uff01" + (time2 - time21));
                String resultStr = "";
                if ("1".equals(jsonObject.getString("dbStructure"))) {
                    this.creatTable(backList);
                }
                this.redisUtil.insert(DB_BACKUP_KEY, (Object)50, 7200L);
                long time3 = System.currentTimeMillis();
                LOG.info("\u6267\u884c\u6570\u636e\u5e93\u7ed3\u6784\u521b\u5efa\u8017\u65f6\uff01" + (time3 - time2));
                if ("1".equals(jsonObject.getString("dbData"))) {
                    DaapConnectorEntity sourceConnector = this.daapConnectorService.getInfo(jsonObject.getString("connectorId"));
                    DbConnDTO connDTO = this.setResource(sourceConnector);
                    DataSourceModel sourceModel = (DataSourceModel)JsonUtil.getJsonToBean((String)sourceConnector.getDataSourceProperties(), DataSourceModel.class);
                    for (File dataFile : dataList) {
                        String tabName3 = DaapConnectorBackUpServiceImpl.subString(dataFile.toString(), "/unZip/" + dbName + "/", "/data/");
                        for (DaapDataTableCrForm daapDataTableCrForm : backList) {
                            if (!tabName3.toUpperCase().equals(daapDataTableCrForm.getTableName().toUpperCase())) continue;
                            MappingTableSqlModel tableSqlModel = this.dataBackUpSql(dataFile.toString(), sourceModel, daapDataTableCrForm, connDTO);
                            tableEnv.executeSql(tableSqlModel.getSourceTableSql());
                            tableEnv.executeSql(tableSqlModel.getSinkTableSql());
                            statementSet.addInsertSql(tableSqlModel.getInsertSql());
                        }
                    }
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)60, 7200L);
                    long time4 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u6784\u5efa\u8017\u65f6\uff01" + (time4 - time3));
                    TableResult result = statementSet.execute();
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)80, 7200L);
                    long time5 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u4efb\u52a1\u63d0\u4ea4\uff01" + (time5 - time4));
                    ((JobClient)result.getJobClient().get()).getJobExecutionResult().get();
                    this.redisUtil.insert(DB_BACKUP_KEY, (Object)95, 7200L);
                    long time6 = System.currentTimeMillis();
                    LOG.info("\u6267\u884c\u6570\u636e\u8fd8\u539f\u4efb\u52a1\u5b8c\u6210---------------\uff01" + (time6 - time5));
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)100, 7200L);
        return "\u8fd8\u539f\u6210\u529f";
    }

    @Override
    public List<DaapConnectorBackUpEntity> getListByBackUpPlanId(String backUpPlanId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapConnectorBackUpEntity::getBackupPlanId, (Object)backUpPlanId);
        return this.list((Wrapper)queryWrapper);
    }

    public MappingTableSqlModel dataBackUpSql(String path, DataSourceModel sourceModel, DaapDataTableCrForm daapDataTableCrForm, DbConnDTO connDTO) throws DataException {
        String dbType;
        MappingTableSqlModel tableSqlModel = new MappingTableSqlModel();
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        StringBuilder sourceField = new StringBuilder();
        StringBuilder sourceFieldAndType = new StringBuilder();
        StringBuilder sourceIdAndType = new StringBuilder();
        List<DaapDataFieldModel> listCommon = daapDataTableCrForm.getDaapDataFieldList();
        switch (dbType = connDTO.getDbSource().getDbType()) {
            case "MySQL": {
                MySqlTypeMapper mySqlTypeMapper = new MySqlTypeMapper("Mysql5.7", "Mysql8");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    String dataType1 = "";
                    String dataLength = "";
                    String fieldEnd = "";
                    try {
                        if (field.getDataType().contains("(")) {
                            Pattern pattern1;
                            Matcher matcher1;
                            Pattern pattern = Pattern.compile("\\((.*?)\\)");
                            Matcher matcher = pattern.matcher(field.getDataType());
                            if (matcher.find()) {
                                dataLength = matcher.group(1);
                            }
                            if ((matcher1 = (pattern1 = Pattern.compile("(.+)(?=\\()")).matcher(field.getDataType())).find()) {
                                dataType1 = matcher1.group(1);
                            }
                        } else {
                            dataType1 = field.getDataType();
                        }
                        int index = field.getDataType().indexOf(")");
                        if (index != -1) {
                            fieldEnd = field.getDataType().substring(index + 1);
                        }
                        if (StringUtils.contains((CharSequence)dataLength, (CharSequence)",")) {
                            precision = Integer.parseInt(dataLength.split(",")[0]);
                            scale = Integer.parseInt(dataLength.split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)dataLength)) {
                            precision = Integer.parseInt(dataLength);
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = mySqlTypeMapper.mapping(dataType1 + fieldEnd, precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getFieldName()).append(",");
                    }
                    field.setFieldName("`" + field.getFieldName() + "`");
                    sourceFieldAndType.append("  ").append(field.getFieldName()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getFieldName()).append(",").append("\n");
                });
                break;
            }
            case "Oracle": {
                OracleTypeMapper oracleTypeMapper = new OracleTypeMapper("Oracle", "12.2");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = oracleTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getFieldName()).append(",");
                    }
                    field.setFieldName("`" + field.getFieldName() + "`");
                    sourceFieldAndType.append("  ").append(field.getFieldName()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getFieldName()).append(",").append("\n");
                });
                break;
            }
            case "PostgreSQL": {
                PostgresTypeMapper postgresTypeMapper = new PostgresTypeMapper("PostgresSql", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = postgresTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getFieldName()).append(",");
                    }
                    field.setFieldName("`" + field.getFieldName() + "`");
                    sourceFieldAndType.append("  ").append(field.getFieldName()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getFieldName()).append(",").append("\n");
                });
                break;
            }
            case "SQLServer": {
                SqlSeverTypeMapper sqlSeverTypeMapper = new SqlSeverTypeMapper("SQLServer", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = sqlSeverTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getFieldName()).append(",");
                    }
                    field.setFieldName("`" + field.getFieldName() + "`");
                    sourceFieldAndType.append("  ").append(field.getFieldName()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getFieldName()).append(",").append("\n");
                });
                break;
            }
        }
        String sourceCreateSql = "";
        sourceCreateSql = String.format("CREATE TABLE IF NOT EXISTS source_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'filesystem',\n  'path' = '%s',\n  'format' = '%s',\n 'partition.default-name'= '%s'\n);\n", daapDataTableCrForm.getTableName(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "file:///" + path, "json", daapDataTableCrForm.getTableName());
        tableSqlModel.setSourceTableSql(sourceCreateSql);
        String sinkCreateTable = "";
        sinkCreateTable = String.format("CREATE TABLE IF NOT EXISTS sink_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'jdbc',\n  'url' = '%s',\n  'username' = '%s',\n  'password' = '%s',\n  'table-name' = '%s'\n);\n", daapDataTableCrForm.getTableName(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "jdbc:mysql://" + connDTO.getDbSource().getHost() + ":" + connDTO.getDbSource().getPort() + "/" + connDTO.getDbSource().getDbName() + "?useUnicode=true&characterEncoding=UTF-8", sourceModel.getUserName(), sourceModel.getPassword(), daapDataTableCrForm.getTableName());
        tableSqlModel.setSinkTableSql(sinkCreateTable);
        String insertSql = String.format("insert into sink_%s select %s from source_%s ;\n", daapDataTableCrForm.getTableName(), StrUtil.removeSuffix((CharSequence)sourceField.toString(), (CharSequence)",\n"), daapDataTableCrForm.getTableName());
        tableSqlModel.setInsertSql(insertSql);
        return tableSqlModel;
    }

    public void creatTable(List<DaapDataTableCrForm> backList) throws Exception {
        block9: {
            if (backList.size() > 0) {
                Connection conn = null;
                Statement stmt = null;
                try {
                    DaapConnectorEntity daapConnectorEntity = this.daapConnectorService.getInfo(backList.get(0).getDatabaseId());
                    LinkedHashMap<Object, Object> resultMap = new LinkedHashMap();
                    JSONObject dataSourceProperties = JSON.parseObject((String)daapConnectorEntity.getDataSourceProperties());
                    if (daapConnectorEntity.getDataSourceType().contains("CDC")) {
                        resultMap = this.daapConnectorService.DataTypeChang(dataSourceProperties, daapConnectorEntity.getDataSourceType());
                        dataSourceProperties = JSON.parseObject((String)JSON.toJSONString(resultMap));
                    }
                    if ((conn = JdbcUtils.getConn(dataSourceProperties.getString("username"), dataSourceProperties.getString("password"), dataSourceProperties.getString("url"))) != null) {
                        stmt = conn.createStatement();
                        for (DaapDataTableCrForm daapDataTableCrForm : backList) {
                            String dropSql = "DROP TABLE IF EXISTS  " + daapDataTableCrForm.getTableName();
                            String sql = JdbcSqlUtils.CreatTableSqlString(daapConnectorEntity.getDataSourceType(), daapDataTableCrForm);
                            stmt.executeUpdate(dropSql);
                            stmt.executeUpdate(sql);
                        }
                        stmt.close();
                        conn.close();
                        break block9;
                    }
                    throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
                }
                catch (Exception e) {
                    throw new Exception("\u7cfb\u7edf\u5f02\u5e38");
                }
                finally {
                    stmt.close();
                    conn.close();
                }
            }
        }
    }

    public static List<String> findTableStr(File file) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource lines = env.readTextFile(file.toString());
        FlatMapOperator result = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public void flatMap(String value, Collector<String> out) {
                out.collect((Object)value);
            }
        });
        List collect = result.collect();
        return collect;
    }

    public static List<Map<String, String>> findTableStr1(final String dbName, List<File> tableStructureList, List<File> fieldStructureList) throws Exception {
        ArrayList<String> fileStrList = new ArrayList<String>();
        for (File file : tableStructureList) {
            fileStrList.add(file.toString());
        }
        ArrayList<String> ffieldStrList = new ArrayList<String>();
        for (File file : fieldStructureList) {
            ffieldStrList.add(file.toString());
        }
        ExecutionEnvironment executionEnvironment = ExecutionEnvironment.getExecutionEnvironment();
        FlatMapOperator table_files = (FlatMapOperator)executionEnvironment.fromCollection(fileStrList).flatMap((FlatMapFunction)new RichFlatMapFunction<String, Map<String, String>>(){

            public void flatMap(String fileName, Collector<Map<String, String>> out) throws Exception {
                try (Stream<String> lines = Files.lines(Paths.get(fileName, new String[0]));){
                    HashMap map = new HashMap();
                    String tabName1 = DaapConnectorBackUpServiceImpl.subString(fileName, "/unZip/" + dbName + "/", "/table_structure/table_structure");
                    lines.forEach(line -> map.put(tabName1 + "_table", line));
                    out.collect(map);
                }
            }
        }).name("Read Files");
        FlatMapOperator field_files = (FlatMapOperator)executionEnvironment.fromCollection(ffieldStrList).flatMap((FlatMapFunction)new RichFlatMapFunction<String, Map<String, String>>(){

            public void flatMap(String fileName, Collector<Map<String, String>> out) throws Exception {
                try (Stream<String> lines = Files.lines(Paths.get(fileName, new String[0]));){
                    HashMap map = new HashMap();
                    String tabName2 = DaapConnectorBackUpServiceImpl.subString(fileName, "/unZip/" + dbName + "/", "/field_structure/field_structure");
                    lines.forEach(line -> map.put(tabName2 + "_field", line));
                    out.collect(map);
                }
            }
        }).name("Read Files");
        ArrayList<Map<String, String>> collect = new ArrayList<Map<String, String>>();
        collect.addAll(table_files.collect());
        collect.addAll(field_files.collect());
        return collect;
    }

    private DbConnDTO setResource(DaapConnectorEntity dataSourceEntity) throws DataException {
        String dataSourceProperties = dataSourceEntity.getDataSourceProperties();
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((CharSequence)dataSourceProperties)) {
            JSONObject jsonObject = JSONObject.parseObject((String)dataSourceProperties);
            String type = dataSourceEntity.getDataSourceType();
            dataSourceModel = this.daapConnectorService.typeChang(jsonObject, type);
            dataSourceProperties = JSON.toJSONString((Object)dataSourceModel);
        }
        DataSourceModel dbSourceOrDbLink = (DataSourceModel)JsonUtil.getJsonToBean((String)dataSourceProperties, DataSourceModel.class);
        try {
            return new DbConnDTO(DbTypeUtil.getDb((DataSourceMod)dbSourceOrDbLink), dbSourceOrDbLink, ConnUtil.getConn((DataSourceMod)dbSourceOrDbLink));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        try {
            Connection conn = connDTO.getConn();
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            PreparedStatementDTO preparedStatementDTO = null;
            preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, (DataSourceMod)connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, (DataSourceMod)connDTO.getDbSource());
            return JdbcUtil.queryCustomMods((PreparedStatementDTO)preparedStatementDTO, modType);
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public static String subString(String str, String strStart, String strEnd) {
        str = StringUtils.replace((String)str, (String)"\\", (String)"/");
        int strStartIndex = str.indexOf(strStart);
        int strEndIndex = str.lastIndexOf(strEnd);
        if (strStartIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strStart + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        if (strEndIndex < 0) {
            return "\u5b57\u7b26\u4e32 :---->" + str + "<---- \u4e2d\u4e0d\u5b58\u5728 " + strEnd + ", \u65e0\u6cd5\u622a\u53d6\u76ee\u6807\u5b57\u7b26\u4e32";
        }
        String result = str.substring(strStartIndex, strEndIndex).substring(strStart.length());
        return result;
    }
}

