/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.datamodel.entity.DaapDataBaseEntity;
import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.entity.DaapDataTableEntity;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataBaseCopyModel;
import com.bringspring.daap.datamodel.model.daapdatadatabase.DaapDataBaseModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataFieldModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableCopyModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableModel;
import com.bringspring.daap.datamodel.service.DaapDataBaseService;
import com.bringspring.daap.datamodel.service.DaapDataFieldService;
import com.bringspring.daap.datamodel.service.DaapDataTableService;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.mapper.DaapConnectorMapper;
import com.bringspring.daap.job.model.daapconnector.DaapConnectorPagination;
import com.bringspring.daap.job.model.daapconnector.DaapConnerctorCopyForm;
import com.bringspring.daap.job.service.DaapConnectorService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapConnectorServiceImpl
extends ServiceImpl<DaapConnectorMapper, DaapConnectorEntity>
implements DaapConnectorService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapDataBaseService daapDataBaseService;
    @Autowired
    private DaapDataTableService daapDataTableService;
    @Autowired
    private DaapDataFieldService daapDataFieldService;
    @Autowired
    private DaapConnectorService daapConnectorService;

    @Override
    public List<DaapConnectorEntity> getList(DaapConnectorPagination daapConnectorPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int daapDataSourceNum = 0;
        QueryWrapper daapDataSourceQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorPagination.getDataSourceName())) {
            ++daapDataSourceNum;
            daapDataSourceQueryWrapper.lambda().like(DaapConnectorEntity::getDataSourceName, (Object)daapConnectorPagination.getDataSourceName());
        }
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorPagination.getDataSourceType())) {
            ++daapDataSourceNum;
            daapDataSourceQueryWrapper.lambda().eq(DaapConnectorEntity::getDataSourceType, (Object)daapConnectorPagination.getDataSourceType());
        }
        if (StringUtils.isNotEmpty((CharSequence)daapConnectorPagination.getReadonlyState())) {
            ++daapDataSourceNum;
            daapDataSourceQueryWrapper.lambda().eq(DaapConnectorEntity::getReadonlyState, (Object)daapConnectorPagination.getReadonlyState());
        }
        if (AllIdList.size() > 0) {
            daapDataSourceQueryWrapper.lambda().in(DaapConnectorEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((CharSequence)daapConnectorPagination.getSidx())) {
            daapDataSourceQueryWrapper.lambda().orderByDesc(DaapConnectorEntity::getId);
        } else {
            try {
                String sidx = daapConnectorPagination.getSidx();
                DaapConnectorEntity daapConnectorEntity = new DaapConnectorEntity();
                Field declaredField = daapConnectorEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                daapDataSourceQueryWrapper = "asc".equals(daapConnectorPagination.getSort().toLowerCase()) ? (QueryWrapper)daapDataSourceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)daapDataSourceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(daapConnectorPagination.getCurrentPage(), daapConnectorPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)daapDataSourceQueryWrapper);
            return daapConnectorPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return daapConnectorPagination.setData(list, list.size());
    }

    @Override
    public DaapConnectorEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapConnectorEntity::getId, (Object)id);
        return (DaapConnectorEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(DaapConnectorEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapConnectorEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DaapConnectorEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    private <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        try {
            Connection conn = connDTO.getConn();
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            PreparedStatementDTO preparedStatementDTO = null;
            preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, (DataSourceMod)connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, (DataSourceMod)connDTO.getDbSource());
            return JdbcUtil.queryCustomMods((PreparedStatementDTO)preparedStatementDTO, modType);
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    @Override
    @DSTransactional
    public boolean syncDataSource(String dataSourceId) throws DataException {
        DaapConnectorEntity dataSourceEntity = this.getInfo(dataSourceId);
        DbConnDTO connDTO = this.setResource(dataSourceEntity);
        List<DaapDataBaseEntity> databaseList = this.daapDataBaseService.getByConnectorId(dataSourceEntity.getId());
        int databaseNum = 0;
        String dbName = connDTO.getDbSource().getDbName();
        for (DaapDataBaseEntity databaseModel : databaseList) {
            if (!databaseModel.getDbName().contains(connDTO.getDbSource().getDbName())) continue;
            ++databaseNum;
        }
        if (databaseNum > 0) {
            dbName = connDTO.getDbSource().getDbName() + "_copy" + databaseNum;
        }
        DaapDataBaseEntity daapDataBaseEntity = new DaapDataBaseEntity(RandomUtil.uuId(), dataSourceEntity.getId(), dbName, connDTO.getDbSource().getDbSchema(), dataSourceEntity.getDataSourceName(), EnabledMarkEnum.ENABLE.getCode());
        this.daapDataBaseService.create(daapDataBaseEntity);
        List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
        int sortCode = 10;
        for (DbTableModel dbTableModel : tableModelList) {
            List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
            String tableId = RandomUtil.uuId();
            DaapDataTableEntity dataTableEntity = new DaapDataTableEntity(tableId, daapDataBaseEntity.getId(), dbTableModel.getTable(), dbTableModel.getTableComment(), sortCode += 10, EnabledMarkEnum.ENABLE.getCode());
            this.daapDataTableService.create(dataTableEntity);
            int fieldSortCode = 10;
            for (DbTableFieldModel dbTableFieldModel : listCommon) {
                DaapDataFieldEntity dataFieldEntity = new DaapDataFieldEntity(RandomUtil.uuId(), tableId, dbTableFieldModel.getField(), dbTableFieldModel.getColumnType(), null, dbTableFieldModel.getFieldName(), dbTableFieldModel.getPrimaryKey(), dbTableFieldModel.getAllowNull(), dbTableFieldModel.getDefaults(), fieldSortCode += 10, EnabledMarkEnum.ENABLE.getCode());
                this.daapDataFieldService.save(dataFieldEntity);
            }
        }
        return true;
    }

    private DbConnDTO setResource(DaapConnectorEntity dataSourceEntity) throws DataException {
        String dataSourceProperties = dataSourceEntity.getDataSourceProperties();
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((CharSequence)dataSourceProperties)) {
            JSONObject jsonObject = JSONObject.parseObject((String)dataSourceProperties);
            String type = dataSourceEntity.getDataSourceType();
            dataSourceModel = this.daapConnectorService.typeChang(jsonObject, type);
            dataSourceProperties = JSON.toJSONString((Object)dataSourceModel);
        }
        DataSourceModel dbSourceOrDbLink = (DataSourceModel)JsonUtil.getJsonToBean((String)dataSourceProperties, DataSourceModel.class);
        try {
            return new DbConnDTO(DbTypeUtil.getDb((DataSourceMod)dbSourceOrDbLink), dbSourceOrDbLink, ConnUtil.getConn((DataSourceMod)dbSourceOrDbLink));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    @Override
    public List<DaapDataBaseModel> getDbTableList(String dataConnectorId) throws DataException {
        ArrayList<DaapDataBaseModel> dataBaseModels = new ArrayList<DaapDataBaseModel>();
        DaapConnectorEntity dataSourceEntity = this.getInfo(dataConnectorId);
        DbConnDTO connDTO = this.setResource(dataSourceEntity);
        DaapDataBaseModel dataBaseModel = new DaapDataBaseModel(connDTO.getDbSource().getDbName(), connDTO.getDbSource().getDbSchema());
        List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
        ArrayList<DaapDataTableModel> dataTables = new ArrayList<DaapDataTableModel>();
        for (DbTableModel dbTableModel : tableModelList) {
            DaapDataTableModel dataTableModel = new DaapDataTableModel();
            dataTableModel.setParentId(dataBaseModel.getId());
            dataTableModel.setId(dbTableModel.getTable());
            dataTableModel.setName(dbTableModel.getTable());
            dataTableModel.setTableComment(dbTableModel.getTableComment());
            dataTables.add(dataTableModel);
        }
        dataBaseModel.setDataTableModels(dataTables);
        dataBaseModels.add(dataBaseModel);
        return dataBaseModels;
    }

    @Override
    public List<DaapDataBaseModel> getDbTableListByConnectorId(String connectorId) throws DataException {
        List<DaapDataBaseEntity> dataBaseList = this.daapDataBaseService.getByConnectorId(connectorId);
        ArrayList<DaapDataBaseModel> dataBaseModels = new ArrayList<DaapDataBaseModel>();
        if (dataBaseList.size() > 0) {
            for (DaapDataBaseEntity dataBaseInfo : dataBaseList) {
                DaapDataBaseModel daapDataBaseModel = new DaapDataBaseModel();
                ArrayList<DaapDataTableModel> dataTables = new ArrayList<DaapDataTableModel>();
                List<DaapDataTableEntity> dataTableList = this.daapDataTableService.getListByDataBaseId(dataBaseInfo.getId());
                if (dataTableList.size() > 0) {
                    for (DaapDataTableEntity dataTableInfo : dataTableList) {
                        DaapDataTableModel dataTableModel = new DaapDataTableModel();
                        dataTableModel.setParentId(dataTableInfo.getDataBaseId());
                        dataTableModel.setId(dataTableInfo.getId());
                        dataTableModel.setName(dataTableInfo.getTableName());
                        dataTableModel.setTableComment(dataTableInfo.getTableComment());
                        dataTableModel.setIcon("ym-custom ym-custom-table");
                        dataTables.add(dataTableModel);
                    }
                }
                daapDataBaseModel.setId(dataBaseInfo.getId());
                daapDataBaseModel.setParentId(dataBaseInfo.getConnectorId());
                daapDataBaseModel.setName(dataBaseInfo.getDbName());
                daapDataBaseModel.setSchemaName(dataBaseInfo.getSchemaName());
                daapDataBaseModel.setIcon("ym-custom ym-custom-database");
                daapDataBaseModel.setDataTableModels(dataTables);
                dataBaseModels.add(daapDataBaseModel);
            }
        }
        return dataBaseModels;
    }

    @Override
    public List<DaapDataFieldModel> getDbTableFieldList(String dataSourceId, String tableName) throws DataException {
        DaapConnectorEntity dataSourceEntity = this.getInfo(dataSourceId);
        DbConnDTO connDTO = this.setResource(dataSourceEntity);
        List<DbTableFieldModel> tableFieldModels = this.getListCommon(tableName, DbTableFieldModel.class, connDTO);
        ArrayList<DaapDataFieldModel> fieldModels = new ArrayList<DaapDataFieldModel>();
        for (DbTableFieldModel tableFieldModel : tableFieldModels) {
            DaapDataFieldModel dataFieldModel = new DaapDataFieldModel();
            dataFieldModel.setFieldName(tableFieldModel.getField());
            dataFieldModel.setFieldComment(tableFieldModel.getFieldName());
            dataFieldModel.setDataType(tableFieldModel.getDataType());
            dataFieldModel.setDataLength(tableFieldModel.getDataLength());
            dataFieldModel.setAllowNull(tableFieldModel.getAllowNull());
            dataFieldModel.setPrimaryKey(tableFieldModel.getPrimaryKey());
            dataFieldModel.setDefaultValue(tableFieldModel.getDefaults());
            fieldModels.add(dataFieldModel);
        }
        return fieldModels;
    }

    @Override
    public DataSourceModel typeChang(JSONObject dataSourceProperties, String type) throws RuntimeException {
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((CharSequence)type) && type.contains("JDBC")) {
            String[] strArry = new String[3];
            String dbName = "";
            String url = dataSourceProperties.getString("url");
            switch (type) {
                case "MySQL-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:mysql://", (String)"/").split(":");
                    dataSourceModel.setDbType("MySQL");
                    dbName = StringUtils.substringAfterLast((String)url, (String)"/");
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "Oracle-JDBC": {
                    strArry = StringUtils.substringAfter((String)url, (String)"@").split(":");
                    dataSourceModel.setDbType("Oracle");
                    dataSourceModel.setDbSchema(dataSourceProperties.getString("username"));
                    dbName = strArry[2];
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "PostgreSQL-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:postgresql://", (String)"/").split(":");
                    dataSourceModel.setDbType("PostgreSQL");
                    dataSourceModel.setDbSchema(dataSourceProperties.getString("username"));
                    dbName = StringUtils.substringAfterLast((String)url, (String)"/");
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "SQLServer-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:sqlserver://", (String)";").split(":");
                    dataSourceModel.setDbType("SQLServer");
                    dbName = StringUtils.substringAfterLast((String)url, (String)"=");
                    break;
                }
            }
            dataSourceModel.setDbName(dbName);
            dataSourceModel.setHost(strArry[0]);
            dataSourceModel.setPort(Integer.valueOf(Integer.parseInt(strArry[1])));
            dataSourceModel.setUserName(dataSourceProperties.getString("username"));
            dataSourceModel.setPassword(dataSourceProperties.getString("password"));
        } else if (StringUtils.isNotEmpty((CharSequence)type) && type.contains("CDC")) {
            switch (type) {
                case "MySQL-CDC": {
                    dataSourceModel.setDbType("MySQL");
                    break;
                }
                case "Oracle-CDC": {
                    dataSourceModel.setDbType("Oracle");
                    break;
                }
                case "PostgreSQL-CDC": {
                    dataSourceModel.setDbType("PostgreSQL");
                    break;
                }
                case "SQLServer-CDC": {
                    dataSourceModel.setDbType("SQLServer");
                    break;
                }
            }
            dataSourceModel.setDbName(StringUtils.isNotEmpty((CharSequence)dataSourceProperties.getString("database-name")) ? dataSourceProperties.getString("database-name") : dataSourceProperties.getString("database_name"));
            dataSourceModel.setHost(dataSourceProperties.getString("hostname"));
            dataSourceModel.setPort(Integer.valueOf(Integer.parseInt(dataSourceProperties.getString("port"))));
            dataSourceModel.setUserName(dataSourceProperties.getString("username"));
            dataSourceModel.setPassword(dataSourceProperties.getString("password"));
        }
        return dataSourceModel;
    }

    @Override
    public LinkedHashMap<String, String> DataTypeChang(JSONObject dataSourceProperties, String type) throws RuntimeException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)type) && type.contains("JDBC")) {
            String[] strArry = new String[3];
            String dbName = "";
            String url = dataSourceProperties.getString("url");
            switch (type) {
                case "MySQL-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:mysql://", (String)"/").split(":");
                    resultMap.put("connector", "mysql-cdc");
                    dbName = StringUtils.substringAfterLast((String)url, (String)"/");
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "Oracle-JDBC": {
                    strArry = StringUtils.substringAfter((String)url, (String)"@").split(":");
                    resultMap.put("connector", "oracle-cdc");
                    resultMap.put("schema-name", dataSourceProperties.getString("username"));
                    dbName = strArry[2];
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "PostgreSQL-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:postgresql://", (String)"/").split(":");
                    resultMap.put("connector", "postgresql-cdc");
                    resultMap.put("schema-name", dataSourceProperties.getString("username"));
                    dbName = StringUtils.substringAfterLast((String)url, (String)"/");
                    if (!dbName.contains("?")) break;
                    dbName = StringUtils.substringBefore((String)dbName, (String)"?");
                    break;
                }
                case "SQLServer-JDBC": {
                    strArry = StringUtils.substringBetween((String)url, (String)"jdbc:sqlserver://", (String)";").split(":");
                    resultMap.put("connector", "sqlserver-cdc");
                    dbName = StringUtils.substringAfterLast((String)url, (String)"=");
                    break;
                }
            }
            resultMap.put("hostname", strArry[0]);
            resultMap.put("port", strArry[1]);
            resultMap.put("username", dataSourceProperties.getString("username"));
            resultMap.put("password", dataSourceProperties.getString("password"));
            resultMap.put("table-name", dataSourceProperties.getString("table-name"));
            resultMap.put("database-name", dbName);
        } else if (StringUtils.isNotEmpty((CharSequence)type) && type.contains("CDC")) {
            resultMap.put("connector", "jdbc");
            StringBuilder sb = new StringBuilder();
            switch (type) {
                case "MySQL-CDC": {
                    sb.append("jdbc:mysql://").append(dataSourceProperties.getString("hostname")).append(":").append(dataSourceProperties.getString("port")).append("/").append(dataSourceProperties.getString("database-name"));
                    break;
                }
                case "Oracle-CDC": {
                    sb.append("jdbc:oracle:thin:@").append(dataSourceProperties.getString("hostname")).append(":").append(dataSourceProperties.getString("port")).append(":").append(dataSourceProperties.getString("database-name"));
                    resultMap.put("driver", "oracle.jdbc.driver.OracleDriver");
                    break;
                }
                case "PostgreSQL-CDC": {
                    sb.append("jdbc:postgresql://").append(dataSourceProperties.getString("hostname")).append(":").append(dataSourceProperties.getString("port")).append("/").append(dataSourceProperties.getString("database-name"));
                    break;
                }
                case "SQLServer-CDC": {
                    sb.append("jdbc:sqlserver://").append(dataSourceProperties.getString("hostname")).append(":").append(dataSourceProperties.getString("port")).append(";DatabaseName=").append(dataSourceProperties.getString("database-name"));
                    resultMap.put("driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    break;
                }
            }
            resultMap.put("url", sb.toString());
            resultMap.put("username", dataSourceProperties.getString("username"));
            resultMap.put("password", dataSourceProperties.getString("password"));
            resultMap.put("table-name", dataSourceProperties.getString("table-name"));
        }
        return resultMap;
    }

    @Override
    @DSTransactional
    public int copyDataBaseAndTable(DaapConnerctorCopyForm daapConnerctorCopyForm) throws RuntimeException {
        int saveNum = 0;
        List<DaapDataBaseCopyModel> daapDataBaseList = daapConnerctorCopyForm.getDaapDataBaseList();
        if (daapDataBaseList.size() < 1) {
            return saveNum;
        }
        for (DaapDataBaseCopyModel daapDataBaseCopyModel : daapDataBaseList) {
            String dataBaseId = RandomUtil.uuId();
            DaapDataBaseEntity daapDataBaseEntity = this.daapDataBaseService.getInfo(daapDataBaseCopyModel.getId());
            daapDataBaseEntity.setId(dataBaseId);
            daapDataBaseEntity.setConnectorId(daapConnerctorCopyForm.getId());
            List<DaapDataBaseEntity> databaseList = this.daapDataBaseService.getByConnectorId(daapConnerctorCopyForm.getId());
            int databaseNum = 0;
            for (DaapDataBaseEntity databaseModel : databaseList) {
                if (!databaseModel.getDbName().contains(daapDataBaseEntity.getDbName())) continue;
                ++databaseNum;
            }
            if (databaseNum > 0) {
                daapDataBaseEntity.setDbName(daapDataBaseEntity.getDbName() + "_copy" + databaseNum);
            }
            this.daapDataBaseService.save(daapDataBaseEntity);
            List<DaapDataTableCopyModel> daapDataTableList = daapDataBaseCopyModel.getDataTableModelsList();
            if (daapDataTableList.size() > 0) {
                for (DaapDataTableCopyModel daapDataTableCopyModel : daapDataTableList) {
                    String oldDaapDataTableId = daapDataTableCopyModel.getId();
                    String dataTableId = RandomUtil.uuId();
                    DaapDataTableEntity daapDataTableEntity = this.daapDataTableService.getInfo(daapDataTableCopyModel.getId());
                    daapDataTableEntity.setId(dataTableId);
                    daapDataTableEntity.setDataBaseId(dataBaseId);
                    this.daapDataTableService.save(daapDataTableEntity);
                    List<DaapDataFieldEntity> daapDataFieldList = this.daapDataFieldService.getFieldsByTable(oldDaapDataTableId);
                    if (daapDataFieldList.size() <= 0) continue;
                    for (DaapDataFieldEntity entitys : daapDataFieldList) {
                        entitys.setId(RandomUtil.uuId());
                        entitys.setTableId(dataTableId);
                        this.daapDataFieldService.save(entitys);
                    }
                }
            }
            ++saveNum;
        }
        return saveNum;
    }
}

