/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.daap.capture.service.DaapCaptureConfigService;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.entity.DaapJobInstanceEntity;
import com.bringspring.daap.job.entity.DaapJobSourceEntity;
import com.bringspring.daap.job.mapper.DaapJobSourceMapper;
import com.bringspring.daap.job.model.daapconnector.DaapConfigContentVO;
import com.bringspring.daap.job.model.daapjobsource.DaapJobSourcePagination;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.daap.job.service.DaapJobInstanceService;
import com.bringspring.daap.job.service.DaapJobSourceService;
import com.bringspring.flink.handler.service.FlinkHandleService;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.util.FlinkException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapJobSourceServiceImpl
extends ServiceImpl<DaapJobSourceMapper, DaapJobSourceEntity>
implements DaapJobSourceService {
    @Autowired
    private FlinkHandleService flinkHandleService;
    @Autowired
    private DaapJobInstanceService daapJobInstanceService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DaapCaptureConfigService daapCaptureConfigService;

    @Override
    public List<DaapJobSourceEntity> getList(DaapJobSourcePagination daapJobSourcePagination) {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)daapJobSourcePagination.getName())) {
            daapJobSourceQueryWrapper.lambda().like(DaapJobSourceEntity::getName, (Object)daapJobSourcePagination.getName());
        }
        if (StringUtils.isNotEmpty((String)daapJobSourcePagination.getTypeId())) {
            daapJobSourceQueryWrapper.lambda().eq(DaapJobSourceEntity::getTypeId, (Object)daapJobSourcePagination.getTypeId());
        }
        Page page = new Page(daapJobSourcePagination.getCurrentPage(), daapJobSourcePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)daapJobSourceQueryWrapper);
        return daapJobSourcePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public DaapJobSourceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapJobSourceEntity::getId, (Object)id);
        return (DaapJobSourceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String check(String id) throws Exception {
        DaapJobSourceEntity info = this.getInfo(id);
        String flinkSql = "";
        if (StringUtils.isNotEmpty((String)info.getCaptureConfigId()) && "\u6240\u5173\u8054\u7684\u91c7\u96c6\u5411\u5bfc\u4e0d\u5b58\u5728".equals(flinkSql = this.daapCaptureConfigService.getCaptureCreatTableSqlById(info.getCaptureConfigId()))) {
            return "\u6240\u5173\u8054\u7684\u91c7\u96c6\u5411\u5bfc\u4e0d\u5b58\u5728";
        }
        return this.flinkHandleService.check(flinkSql + info.getEtlContent());
    }

    @Override
    public boolean submit(String id) throws Exception {
        String configContent;
        DaapJobSourceEntity info = this.getInfo(id);
        String flinkSql = "";
        if (StringUtils.isNotEmpty((String)info.getCaptureConfigId())) {
            flinkSql = this.daapCaptureConfigService.getCaptureCreatTableSqlById(info.getCaptureConfigId());
        }
        if (StringUtils.isEmpty((String)(configContent = info.getConfigContent()))) {
            throw new FlinkException("\u6ca1\u6709\u627e\u5230Flink\u914d\u7f6e");
        }
        DaapConfigContentVO vo = (DaapConfigContentVO)JsonUtil.getJsonToBean((String)configContent, DaapConfigContentVO.class);
        DaapJobClusterEntity clusterEntity = this.daapJobClusterService.getInfo(vo.getClusterId());
        String flinkJobId = "";
        if (clusterEntity.getType().equals("remote")) {
            flinkJobId = this.flinkHandleService.submitRemoteStreamBySql(clusterEntity.getJobManagerHost(), clusterEntity.getPort(), info.getEtlContent(), info.getName(), flinkSql);
        } else if (clusterEntity.getType().equals("local")) {
            flinkJobId = this.flinkHandleService.submitLocalStreamBySql(info.getEtlContent(), info.getName(), flinkSql);
        }
        DaapJobInstanceEntity daapJobInstanceEntity = new DaapJobInstanceEntity();
        daapJobInstanceEntity.setName(info.getName() + "\u5b9e\u4f8b");
        daapJobInstanceEntity.setLiftCycle("\u8fdb\u884c\u4e2d");
        daapJobInstanceEntity.setId(RandomUtil.uuId());
        daapJobInstanceEntity.setFlinkJobId(flinkJobId);
        daapJobInstanceEntity.setJobSourceId(id);
        daapJobInstanceEntity.setEnabledMark(0);
        this.daapJobInstanceService.create(daapJobInstanceEntity);
        return true;
    }

    @Override
    public void create(DaapJobSourceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapJobSourceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<DaapJobSourceEntity> getAllBatchList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapJobSourceEntity::getReadMethod, (Object)"BATCH");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void delete(DaapJobSourceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

