/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.capture.model.mapping.MappingTableSqlModel;
import com.bringspring.daap.job.entity.DaapConnectorBackUpEntity;
import com.bringspring.daap.job.entity.DaapConnectorBackUpPlanEntity;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.mapper.DaapConnectorBackUpPlanMapper;
import com.bringspring.daap.job.service.DaapConnectorBackUpPlanService;
import com.bringspring.daap.job.service.DaapConnectorBackUpService;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.daap.job.service.DataBackUpAndRestoreService;
import com.bringspring.database.MySqlTypeMapper;
import com.bringspring.database.OracleTypeMapper;
import com.bringspring.database.PostgresTypeMapper;
import com.bringspring.database.SqlSeverTypeMapper;
import com.bringspring.files.utils.ZipUtils;
import com.bringspring.flink.handler.service.environment.FlinkEnvironmentHandle;
import com.bringspring.system.base.model.monitor.DiskModel;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;

@Service
public class DataBackUpAndRestoreServiceImpl
extends ServiceImpl<DaapConnectorBackUpPlanMapper, DaapConnectorBackUpPlanEntity>
implements DataBackUpAndRestoreService {
    private static final Logger LOG = LoggerFactory.getLogger(DataBackUpAndRestoreServiceImpl.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String DB_BACKUP_KEY = "dbBackUpKey";
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DaapConnectorBackUpPlanService daapConnectorBackUpPlanService;
    @Autowired
    private DaapConnectorBackUpService daapConnectorBackUpService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String mapping(DaapConnectorBackUpPlanEntity entity) throws Exception {
        if (this.redisUtil.getString(DB_BACKUP_KEY) != null) {
            return "\u5df2\u6709\u5907\u4efd\u8ba1\u5212/\u8fd8\u539f\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u7a0d\u540e\u91cd\u8bd5";
        }
        this.backUpZipDel();
        String diskPath = "";
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WINDOWS")) {
            diskPath = entity.getFilePath().substring(0, 1).toUpperCase();
        } else {
            int firstCommaIndex = entity.getFilePath().indexOf("/");
            int secondCommaIndex = entity.getFilePath().indexOf("/", firstCommaIndex + 1);
            diskPath = entity.getFilePath().substring(firstCommaIndex + 1, secondCommaIndex);
        }
        LOG.info("\u6587\u4ef6\u5b58\u50a8\u76d8\u7b26-------------------" + diskPath);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(entity.getCreatorUserId());
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        FileSystem fileSystem = os.getFileSystem();
        List fsArray = fileSystem.getFileStores();
        for (OSFileStore file : fsArray) {
            LOG.info(file + "\u78c1\u76d8\u7684\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getTotalSpace() / 1024L / 1024L / 1024L + "G");
            LOG.info(file + "\u78c1\u76d8\u7684\u53ef\u4f7f\u7528\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getUsableSpace() / 1024L / 1024L / 1024L + "G");
            LOG.info(file + "\u78c1\u76d8\u7684\u7a7a\u95f2\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getFreeSpace() / 1024L / 1024L / 1024L + "G");
            LOG.info("------------------------------------------------------------------");
            if (!file.getMount().contains(diskPath) || file.getUsableSpace() / 1024L / 1024L / 1024L >= (long)entity.getDiskSize()) continue;
            this.sendMessage(ids, "\u78c1\u76d8\u7a7a\u95f4\u9884\u8b66", file + "\u78c1\u76d8\u7684\u53ef\u4f7f\u7528\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getUsableSpace() / 1024L / 1024L / 1024L + "G,\u5c0f\u4e8e\u8bbe\u5b9a\u9884\u7559\u7a7a\u95f4" + entity.getDiskSize() + "G,\u8bf7\u5904\u7406\u540e\u518d\u6b21\u5907\u4efd", "");
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)("\u5907\u4efd\u5931\u8d25\uff0c" + file + "\u78c1\u76d8\u7684\u53ef\u4f7f\u7528\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getUsableSpace() / 1024L / 1024L / 1024L + "G,\u5c0f\u4e8e\u8bbe\u5b9a\u9884\u7559\u7a7a\u95f4" + entity.getDiskSize() + "G,\u8bf7\u5904\u7406\u540e\u518d\u6b21\u5907\u4efd"), 7200L);
            return file + "\u78c1\u76d8\u7684\u53ef\u4f7f\u7528\u7a7a\u95f4\u5927\u5c0f\u4e3a\uff1a" + file.getUsableSpace() / 1024L / 1024L / 1024L + "G,\u5c0f\u4e8e\u8bbe\u5b9a\u9884\u7559\u7a7a\u95f4" + entity.getDiskSize() + "G,\u8bf7\u5904\u7406\u540e\u518d\u6b21\u5907\u4efd";
        }
        this.redisUtil.insert(DB_BACKUP_KEY, (Object)0, 7200L);
        String sourceId = entity.getConnectorId();
        String clusterId = entity.getClusterId();
        String path = entity.getFilePath();
        String path1 = entity.getFilePath();
        DaapConnectorEntity sourceConnector = this.daapConnectorService.getInfo(sourceId);
        DbConnDTO connDTO = this.setResource(sourceConnector);
        DataSourceModel sourceModel = (DataSourceModel)JsonUtil.getJsonToBean((String)sourceConnector.getDataSourceProperties(), DataSourceModel.class);
        DaapJobClusterEntity clusterEntity = this.daapJobClusterService.getInfo(clusterId);
        Configuration configuration = new Configuration();
        configuration.setString(String.valueOf(RestOptions.PORT), "8081");
        StreamExecutionEnvironment remoteEnvironment = null;
        remoteEnvironment = clusterEntity.getType().equals("remote") ? FlinkEnvironmentHandle.createRemoteEnvironment(clusterEntity.getJobManagerHost(), clusterEntity.getPort()) : StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)configuration);
        remoteEnvironment.setParallelism(2);
        remoteEnvironment.setRuntimeMode(RuntimeExecutionMode.BATCH);
        StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)remoteEnvironment);
        configuration.setString("pipeline.name", sourceConnector.getDataSourceName());
        path = path + "/" + sourceConnector.getDataSourceName();
        StreamStatementSet statementSet = tableEnv.createStatementSet();
        ArrayList jobIds = new ArrayList();
        List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
        com.bringspring.common.util.FileUtil.deleteFileAll((File)new File(path));
        try {
            this.getTableSql2(path, tableModelList, connDTO.getDbSource().getDbName());
            this.getTableStructureSql2(path, tableModelList, connDTO);
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)50, 7200L);
            for (DbTableModel dbTableModel : tableModelList) {
                MappingTableSqlModel tableSqlModel = this.generateDdl(path, sourceModel, dbTableModel, connDTO);
                tableEnv.executeSql(tableSqlModel.getSourceTableSql());
                tableEnv.executeSql(tableSqlModel.getSinkTableSql());
                statementSet.addInsertSql(tableSqlModel.getInsertSql());
            }
            long time1 = System.currentTimeMillis();
            TableResult result = statementSet.execute();
            long time2 = System.currentTimeMillis();
            LOG.info("\u4efb\u52a1\u6267\u884c\u8017\u65f6----------" + (time2 - time1));
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)60, 7200L);
            ((JobClient)result.getJobClient().get()).getJobExecutionResult().get();
            long time3 = System.currentTimeMillis();
            LOG.info("\u4efb\u52a1\u6267\u884c\u8017\u65f6\u5b8c\u6210----------" + (time3 - time2));
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)70, 7200L);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
            Date date = new Date();
            String format = simpleDateFormat.format(date);
            String filesName = sourceConnector.getDataSourceName() + "-" + format;
            String rootFolder = path;
            String zipFileTargetPath = path1 + "/" + DateUtil.daFormat((Date)new Date());
            String zipFilePath = path1 + "/" + DateUtil.daFormat((Date)new Date()) + "/" + filesName + ".zip";
            ZipUtils.zip((String)rootFolder, (String)zipFileTargetPath, (String)"rkkj88888888", (String)zipFilePath);
            filesName = filesName + ".zip";
            long files = new File(zipFilePath).length();
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)80, 7200L);
            DaapConnectorBackUpEntity daapConnectorBackUpEntity = new DaapConnectorBackUpEntity();
            if ("1".equals(String.valueOf(entity.getBackFiles()))) {
                this.zipProjectFiles(zipFileTargetPath, "rkkj88888888", path1 + "/" + DateUtil.daFormat((Date)new Date()) + "/\u9644\u4ef6\u5907\u4efd-" + format + ".zip");
                String docmentFilesName = "\u9644\u4ef6\u5907\u4efd-" + format + ".zip";
                long files1 = new File(path1 + "/" + DateUtil.daFormat((Date)new Date()) + "/\u9644\u4ef6\u5907\u4efd-" + format + ".zip").length();
                if (files1 > 0L) {
                    daapConnectorBackUpEntity.setFileName(docmentFilesName);
                    daapConnectorBackUpEntity.setFileSize(this.getFileSize(files1));
                }
            }
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)90, 7200L);
            String size = this.getFileSize(files);
            String backId = RandomUtil.uuId();
            daapConnectorBackUpEntity.setId(backId);
            daapConnectorBackUpEntity.setConnectorId(sourceId);
            daapConnectorBackUpEntity.setDbFileSize(size);
            daapConnectorBackUpEntity.setBackupTime(new Date());
            daapConnectorBackUpEntity.setBackupDbName(connDTO.getDbSource().getDbName());
            daapConnectorBackUpEntity.setDbFileName(filesName);
            daapConnectorBackUpEntity.setBackupPlanId(entity.getId());
            daapConnectorBackUpEntity.setFilePath(zipFileTargetPath);
            daapConnectorBackUpEntity.setDescription(sourceConnector.getDataSourceName() + "\u8fde\u63a5\u5668\u4e0b" + connDTO.getDbSource().getDbName() + "\u6570\u636e\u5e93\u5907\u4efd");
            daapConnectorBackUpEntity.setEnabledMark(1);
            this.daapConnectorBackUpService.save(daapConnectorBackUpEntity);
            this.redisUtil.insert(DB_BACKUP_KEY, (Object)100, 7200L);
        }
        catch (Exception e) {
            this.log.error(e.getMessage() + "\u5907\u4efd\u8fc7\u7a0b\u9519\u8bef\u6267\u884c\u5220\u9664\u5f00\u59cb-----------------------------");
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            com.bringspring.common.util.FileUtil.deleteFileAll((File)new File(path));
        }
        return "\u6267\u884c\u6210\u529f";
    }

    @Override
    public Object findProgressFlag(String dbBackUpKey) {
        return this.redisUtil.getString(dbBackUpKey);
    }

    @Override
    public void delRedisKey(String redisKey) {
        this.redisUtil.remove(redisKey);
    }

    private DbConnDTO setResource(DaapConnectorEntity dataSourceEntity) throws DataException {
        String dataSourceProperties = dataSourceEntity.getDataSourceProperties();
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((String)dataSourceProperties)) {
            JSONObject jsonObject = JSONObject.parseObject((String)dataSourceProperties);
            String type = dataSourceEntity.getDataSourceType();
            dataSourceModel = this.daapConnectorService.typeChang(jsonObject, type);
            dataSourceProperties = JSON.toJSONString((Object)dataSourceModel);
        }
        DataSourceModel dbSourceOrDbLink = (DataSourceModel)JsonUtil.getJsonToBean((String)dataSourceProperties, DataSourceModel.class);
        try {
            return new DbConnDTO(DbTypeUtil.getDb((DataSourceMod)dbSourceOrDbLink), dbSourceOrDbLink, ConnUtil.getConn((DataSourceMod)dbSourceOrDbLink));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        try {
            Connection conn = connDTO.getConn();
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            PreparedStatementDTO preparedStatementDTO = null;
            preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, (DataSourceMod)connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, (DataSourceMod)connDTO.getDbSource());
            return JdbcUtil.queryCustomMods((PreparedStatementDTO)preparedStatementDTO, modType);
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public void getTableStructureSql(String path, DataSourceModel sourceModel, DbTableModel dbTableModel, DbConnDTO connDTO) throws Exception {
        List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
        String json = JSON.toJSONString(listCommon);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource dataStream = env.fromElements((Object[])new String[]{json});
        dataStream.writeAsText("file:///" + path + "/" + connDTO.getDbSource().getDbName() + "/" + dbTableModel.getTable() + "/field_structure/field_structure", FileSystem.WriteMode.OVERWRITE).setParallelism(1);
        env.execute("File Generation Example");
    }

    public void getTableStructureSql2(final String pathUrl, List<DbTableModel> tableModelList, DbConnDTO connDTO) throws Exception {
        final String dbName = connDTO.getDbSource().getDbName();
        ArrayList listArray = new ArrayList();
        for (DbTableModel dbTableModel : tableModelList) {
            List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
            String s = JSON.toJSONString(listCommon);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(dbTableModel.getTable(), s);
            listArray.add(map);
        }
        String s1 = JSON.toJSONString(listArray);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        DataStreamSource input = env.fromElements((Object[])new String[]{s1});
        input.process((ProcessFunction)new ProcessFunction<String, String>(){
            private transient PrintWriter writer;

            public void open(Configuration parameters) throws Exception {
            }

            public void processElement(String value, ProcessFunction.Context context, Collector<String> collector) throws Exception {
                JSONArray jsonArray = JSON.parseArray((String)value);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject dbTableModel = jsonArray.getJSONObject(i);
                    if (this.writer != null) {
                        this.writer.close();
                    }
                    Iterator iterator = dbTableModel.keySet().iterator();
                    String key = (String)iterator.next();
                    String value1 = dbTableModel.getString(key);
                    String url = pathUrl + "/" + dbName + "/" + key + "/field_structure/";
                    String fileName = "field_structure";
                    File file = new File(url + fileName);
                    if (!file.exists()) {
                        com.bringspring.common.util.FileUtil.createFile((String)url, (String)fileName);
                    }
                    this.writer = new PrintWriter(file);
                    this.writer.println(value1);
                    collector.collect((Object)value1);
                }
            }

            public void close() throws Exception {
                this.writer.close();
            }
        }).setParallelism(1);
        env.execute();
    }

    public void getTableSql2(final String pathUrl, List<DbTableModel> tableModelList, final String dbName) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        String s = JSON.toJSONString(tableModelList);
        DataStreamSource input = env.fromElements((Object[])new String[]{s});
        input.process((ProcessFunction)new ProcessFunction<String, String>(){
            private transient PrintWriter writer;

            public void open(Configuration parameters) throws Exception {
            }

            public void processElement(String value, ProcessFunction.Context context, Collector<String> collector) throws Exception {
                JSONArray jsonArray = JSON.parseArray((String)value);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject dbTableModel = jsonArray.getJSONObject(i);
                    if (this.writer != null) {
                        this.writer.close();
                    }
                    String url = pathUrl + "/" + dbName + "/" + dbTableModel.getString("table") + "/table_structure/";
                    String fileName = "table_structure";
                    File file = new File(url + fileName);
                    if (!file.exists()) {
                        com.bringspring.common.util.FileUtil.createFile((String)url, (String)fileName);
                    }
                    this.writer = new PrintWriter(file);
                    this.writer.println(JSON.toJSONString((Object)dbTableModel));
                    collector.collect((Object)JSON.toJSONString((Object)dbTableModel));
                }
            }

            public void close() throws Exception {
                this.writer.close();
            }
        }).setParallelism(1);
        env.execute();
    }

    public void getTableSql(String path, DataSourceModel sourceModel, DbTableModel dbTableModel, DbConnDTO connDTO) throws Exception {
        String json = JSON.toJSONString((Object)dbTableModel);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource dataStream = env.fromElements((Object[])new String[]{json});
        dataStream.writeAsText("file:///" + path + "/" + connDTO.getDbSource().getDbName() + "/" + dbTableModel.getTable() + "/table_structure/table_structure", FileSystem.WriteMode.OVERWRITE).setParallelism(1);
        env.execute("File Generation Example");
    }

    public MappingTableSqlModel generateDdl(String path, DataSourceModel sourceModel, DbTableModel dbTableModel, DbConnDTO connDTO) throws DataException {
        String dbType;
        MappingTableSqlModel tableSqlModel = new MappingTableSqlModel();
        StringBuilder sourceField = new StringBuilder();
        StringBuilder sourceFieldAndType = new StringBuilder();
        StringBuilder sourceIdAndType = new StringBuilder();
        List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
        switch (dbType = connDTO.getDbSource().getDbType()) {
            case "MySQL": {
                MySqlTypeMapper mySqlTypeMapper = new MySqlTypeMapper("Mysql5.7", "Mysql8");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    String dataType1 = "";
                    String dataLength = "";
                    String fieldEnd = "";
                    try {
                        if (field.getColumnType().contains("(")) {
                            Pattern pattern1;
                            Matcher matcher1;
                            Pattern pattern = Pattern.compile("\\((.*?)\\)");
                            Matcher matcher = pattern.matcher(field.getColumnType());
                            if (matcher.find()) {
                                dataLength = matcher.group(1);
                            }
                            if ((matcher1 = (pattern1 = Pattern.compile("(.+)(?=\\()")).matcher(field.getColumnType())).find()) {
                                dataType1 = matcher1.group(1);
                            }
                        } else {
                            dataType1 = field.getColumnType();
                        }
                        int index = field.getColumnType().indexOf(")");
                        if (index != -1) {
                            fieldEnd = field.getColumnType().substring(index + 1);
                        }
                        if (StringUtils.contains((CharSequence)dataLength, (CharSequence)",")) {
                            precision = Integer.parseInt(dataLength.split(",")[0]);
                            scale = Integer.parseInt(dataLength.split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)dataLength)) {
                            precision = Integer.parseInt(dataLength);
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = mySqlTypeMapper.mapping(dataType1 + fieldEnd, precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "Oracle": {
                OracleTypeMapper oracleTypeMapper = new OracleTypeMapper("Oracle", "12.2");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = oracleTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "PostgreSQL": {
                PostgresTypeMapper postgresTypeMapper = new PostgresTypeMapper("PostgresSql", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = postgresTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "SQLServer": {
                SqlSeverTypeMapper sqlSeverTypeMapper = new SqlSeverTypeMapper("SQLServer", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    try {
                        if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                            precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                            scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                        } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                            precision = Integer.parseInt(field.getDataLength());
                        }
                    }
                    catch (Exception e) {
                        precision = Integer.MAX_VALUE;
                    }
                    DataType dataType = null;
                    try {
                        dataType = sqlSeverTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
        }
        String sourceCreateSql = "";
        sourceCreateSql = String.format("CREATE TABLE IF NOT EXISTS source_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'jdbc',\n  'url' = '%s',\n  'username' = '%s',\n  'password' = '%s',\n  'table-name' = '%s'\n);\n", dbTableModel.getTable(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "jdbc:mysql://" + connDTO.getDbSource().getHost() + ":" + connDTO.getDbSource().getPort() + "/" + connDTO.getDbSource().getDbName() + "?useUnicode=true&characterEncoding=UTF-8", sourceModel.getUserName(), sourceModel.getPassword(), dbTableModel.getTable());
        tableSqlModel.setSourceTableSql(sourceCreateSql);
        String sinkCreateTable = "";
        sinkCreateTable = String.format("CREATE TABLE IF NOT EXISTS sink_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'filesystem',\n  'path' = '%s',\n  'format' = '%s',\n 'partition.default-name'= '%s'\n);\n", dbTableModel.getTable(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "file:///" + path + "/" + connDTO.getDbSource().getDbName() + "/" + dbTableModel.getTable() + "/data", "json", dbTableModel.getTable());
        tableSqlModel.setSinkTableSql(sinkCreateTable);
        String insertSql = String.format("insert into sink_%s select %s from source_%s ;\n", dbTableModel.getTable(), StrUtil.removeSuffix((CharSequence)sourceField.toString(), (CharSequence)",\n"), dbTableModel.getTable());
        tableSqlModel.setInsertSql(insertSql);
        return tableSqlModel;
    }

    private String getFileSize(Long files) {
        String size = "0BT";
        DecimalFormat df = new DecimalFormat("#.00");
        size = files < 1024L ? df.format((double)files.longValue()) + "BT" : (files < 0x100000L ? df.format((double)files.longValue() / 1024.0) + "KB" : (files < 0x40000000L ? df.format((double)files.longValue() / 1048576.0) + "MB" : df.format((double)files.longValue() / 1.073741824E9) + "GB"));
        return size;
    }

    private void flinkStatus(JobID jobId) throws Exception {
        Configuration config = new Configuration();
        config.setString("rest.address", "localhost:8081");
        RestClusterClient clusterClient = new RestClusterClient(config, (Object)"", null);
        do {
            JobStatus jobStatus = (JobStatus)clusterClient.getJobStatus(jobId).get();
            System.out.println("Job status: " + jobStatus);
            Thread.sleep(1000L);
        } while (!DataBackUpAndRestoreServiceImpl.isJobFinished((ClusterClient<String>)clusterClient, jobId));
        System.out.println("Job finished");
        clusterClient.close();
    }

    private void backUpZipDel() throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List daapConnectorBackUpPlanList = this.daapConnectorBackUpPlanService.list();
        for (DaapConnectorBackUpPlanEntity daapConnectorBackUpPlanEntity : daapConnectorBackUpPlanList) {
            List<DaapConnectorBackUpEntity> daapConnectorBackUpEntityList = this.daapConnectorBackUpService.getListByBackUpPlanId(daapConnectorBackUpPlanEntity.getId());
            for (DaapConnectorBackUpEntity daapConnectorBackUpEntity : daapConnectorBackUpEntityList) {
                Date endTime = new Date();
                Long timeDifference = endTime.getTime() - daapConnectorBackUpEntity.getCreatorTime().getTime();
                Long temp = (long)(daapConnectorBackUpPlanEntity.getFileDay() * 24 * 60 * 60) * 1000L;
                boolean delStatus = false;
                delStatus = timeDifference > temp;
                if (!delStatus) continue;
                String zipFilePath = daapConnectorBackUpEntity.getFilePath();
                this.log.error("\u5220\u9664\u6587\u4ef6\u8def\u5f84" + zipFilePath);
                FileUtil.del((String)zipFilePath);
                this.daapConnectorBackUpService.removeById(daapConnectorBackUpEntity);
            }
        }
    }

    private void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(40));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("diskSizeMessage").getKeyValue());
        sentMessageForm.setTitle(title);
        sentMessageForm.setContent(content);
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getSystemAddress("app") + url);
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    private static boolean isJobFinished(ClusterClient<String> clusterClient, JobID jobID) throws Exception {
        JobStatus jobStatus = (JobStatus)clusterClient.getJobStatus(jobID).get();
        return jobStatus.isGloballyTerminalState();
    }

    private void zipProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        String documentFile = this.configValueUtil.getDocumentFilePath();
        String documentPreview = this.configValueUtil.getDocumentPreviewPath();
        String imContentFile = this.configValueUtil.getImContentFilePath();
        String license = this.configValueUtil.getLicenseFilePath();
        String systemFile = this.configValueUtil.getSystemFilePath();
        String templateCode = this.configValueUtil.getTemplateCodePath();
        String templateFile = this.configValueUtil.getTemplateFilePath();
        String userAvatar = this.configValueUtil.getUserAvatarFilePath();
        String webAnnexFile = this.configValueUtil.getWebAnnexFilePath();
        String biVisualPath = this.configValueUtil.getBiVisualPath();
        ZipUtils.zipProjectFiles((String)documentFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)documentPreview, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)imContentFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)license, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)systemFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)templateCode, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)templateFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)userAvatar, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)webAnnexFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)biVisualPath, (String)zipFileTargetPath, (String)password, (String)filesPath);
    }

    private DiskModel getDiskInfo(OperatingSystem os) {
        DiskModel diskInfo = new DiskModel();
        FileSystem fileSystem = os.getFileSystem();
        List fsArray = fileSystem.getFileStores();
        long total = 0L;
        long available = 0L;
        long used = 0L;
        for (OSFileStore fs : fsArray) {
            total += fs.getTotalSpace();
            available += fs.getUsableSpace();
        }
        used = total - available;
        diskInfo.setTotal(FormatUtil.formatBytes((long)total));
        diskInfo.setAvailable(FormatUtil.formatBytes((long)available));
        diskInfo.setUsed(FormatUtil.formatBytes((long)used));
        diskInfo.setUsageRate(DECIMAL_FORMAT.format((double)used / (double)total * 100.0));
        return diskInfo;
    }
}

