/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.job.task;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.io.FileUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.job.entity.DaapConnectorBackUpEntity;
import com.bringspring.daap.job.entity.DaapConnectorBackUpPlanEntity;
import com.bringspring.daap.job.service.DaapConnectorBackUpPlanService;
import com.bringspring.daap.job.service.DaapConnectorBackUpService;
import com.bringspring.daap.job.service.DataBackUpAndRestoreService;
import com.bringspring.files.utils.ZipUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackUpDelTask {
    private static final Logger LOG = LoggerFactory.getLogger(BackUpDelTask.class);
    @Autowired
    private DaapConnectorBackUpPlanService daapConnectorBackUpPlanService;
    @Autowired
    private DaapConnectorBackUpService daapConnectorBackUpService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DataBackUpAndRestoreService dataBackUpAndRestoreService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @JsbosTask(fullName="\u626b\u63cf\u5907\u4efd\u8bb0\u5f55\uff0c\u6e05\u9664\u8fc7\u671f\u6587\u4ef6", description="\u626b\u63cf\u5907\u4efd\u8bb0\u5f55\uff0c\u6e05\u9664\u8fc7\u671f\u6587\u4ef6")
    public void backUpZipDel() throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List daapConnectorBackUpPlanList = this.daapConnectorBackUpPlanService.list();
        for (DaapConnectorBackUpPlanEntity daapConnectorBackUpPlanEntity : daapConnectorBackUpPlanList) {
            List<DaapConnectorBackUpEntity> daapConnectorBackUpEntityList = this.daapConnectorBackUpService.getListByBackUpPlanId(daapConnectorBackUpPlanEntity.getId());
            for (DaapConnectorBackUpEntity daapConnectorBackUpEntity : daapConnectorBackUpEntityList) {
                Date endTime = new Date();
                Long timeDifference = endTime.getTime() - daapConnectorBackUpEntity.getCreatorTime().getTime();
                Long temp = (long)(daapConnectorBackUpPlanEntity.getFileDay() * 24 * 60 * 60) * 1000L;
                boolean delStatus = false;
                delStatus = timeDifference > temp;
                if (!delStatus) continue;
                String zipFilePath = daapConnectorBackUpEntity.getFilePath() + "/" + daapConnectorBackUpEntity.getFileName();
                FileUtil.del((String)zipFilePath);
                String dbZipFilePath = daapConnectorBackUpEntity.getFilePath() + "/" + daapConnectorBackUpEntity.getDbFileName();
                FileUtil.del((String)dbZipFilePath);
                this.daapConnectorBackUpService.removeById(daapConnectorBackUpEntity);
            }
        }
    }

    @JsbosTask(fullName="\u6267\u884c\u5907\u4efd\u8ba1\u5212", description="\u6267\u884c\u5907\u4efd\u8ba1\u5212")
    public void backUpZip() throws Exception {
        List list = this.daapConnectorBackUpPlanService.list();
        String resultStr = null;
        if (list.size() > 0) {
            for (DaapConnectorBackUpPlanEntity entity : list) {
                if ("1".equals(String.valueOf(entity.getEnabledMark())) && "0".equals(String.valueOf(entity.getDeleteMark()))) {
                    try {
                        resultStr = this.dataBackUpAndRestoreService.mapping(entity);
                        LOG.debug(resultStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOG.error(e.getMessage());
                    }
                    continue;
                }
                LOG.error("\u8be5\u8ba1\u5212\u662f\u65e0\u6548\u72b6\u6001\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e");
            }
        }
    }

    @JsbosTask(fullName="\u6267\u884c\u9644\u4ef6\u589e\u91cf\u5907\u4efd\u8ba1\u5212", description="\u6267\u884c\u9644\u4ef6\u589e\u91cf\u5907\u4efd\u8ba1\u5212")
    public void backSpikeFilesUpZip() throws Exception {
        String path = this.configValueUtil.getDataBackupFilePath();
        path = StringUtils.replace((String)path, (String)"\\", (String)File.separator);
        String zipFileTargetPath = path + File.separator + DateUtil.daFormat((Date)new Date());
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddkkmmss");
        String format = simpleDateFormat.format(date);
        this.zipSpikeProjectFiles(zipFileTargetPath, "rkkj88888888", path + File.separator + DateUtil.daFormat((Date)new Date()) + File.separator + "\u9644\u4ef6\u589e\u91cf\u5907\u4efd-" + format + ".zip");
    }

    private void zipSpikeProjectFiles(String zipFileTargetPath, String password, String filesPath) {
        DateTime yesterday = DateUtil.yesterday();
        String dateStr = yesterday.toDateStr();
        dateStr = dateStr.replaceAll("-", File.separator);
        String documentFile = this.configValueUtil.getDocumentFilePath() + File.separator + dateStr;
        String documentPreview = this.configValueUtil.getDocumentPreviewPath() + File.separator + dateStr;
        String imContentFile = this.configValueUtil.getImContentFilePath() + File.separator + dateStr;
        String license = this.configValueUtil.getLicenseFilePath() + File.separator + dateStr;
        String systemFile = this.configValueUtil.getSystemFilePath() + File.separator + dateStr;
        String templateCode = this.configValueUtil.getTemplateCodePath() + File.separator + dateStr;
        String templateFile = this.configValueUtil.getTemplateFilePath() + File.separator + dateStr;
        String userAvatar = this.configValueUtil.getUserAvatarFilePath() + File.separator + dateStr;
        String webAnnexFile = this.configValueUtil.getWebAnnexFilePath() + File.separator + dateStr;
        String biVisualPath = this.configValueUtil.getBiVisualPath() + File.separator + dateStr;
        String dackUpFilePath = this.configValueUtil.getDataBackupFilePath() + File.separator + "tempZipFile";
        String zipDocumentFile = dackUpFilePath + File.separator + "DocumentFile";
        String zipDocumentPreview = dackUpFilePath + File.separator + "DocumentPreview";
        String zipIMContentFile = dackUpFilePath + File.separator + "IMContentFile";
        String zipLicense = dackUpFilePath + File.separator + "License";
        String zipSystemFile = dackUpFilePath + File.separator + "SystemFile";
        String zipTemplateCode = dackUpFilePath + File.separator + "TemplateCode";
        String zipTemplateFile = dackUpFilePath + File.separator + "TemplateFile";
        String zipUserAvatar = dackUpFilePath + File.separator + "UserAvatar";
        String zipWebAnnexFile = dackUpFilePath + File.separator + "WebAnnexFile";
        String zipBiVisualPath = dackUpFilePath + File.separator + "BiVisualPath";
        String tempDocumentFile = zipDocumentFile + File.separator + dateStr;
        String tempDocumentPreview = zipDocumentPreview + File.separator + dateStr;
        String tempIMContentFile = zipIMContentFile + File.separator + dateStr;
        String tempLicense = zipLicense + File.separator + dateStr;
        String tempSystemFile = zipSystemFile + File.separator + dateStr;
        String tempTemplateCode = zipTemplateCode + File.separator + dateStr;
        String tempTemplateFile = zipTemplateFile + File.separator + dateStr;
        String tempUserAvatar = zipUserAvatar + File.separator + dateStr;
        String tempWebAnnexFile = zipWebAnnexFile + File.separator + dateStr;
        String tempBiVisualPath = zipBiVisualPath + File.separator + dateStr;
        if (new File(documentFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(documentFile), (File)new File(tempDocumentFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempDocumentFile));
        }
        if (new File(documentPreview).exists()) {
            FileUtil.copyFilesFromDir((File)new File(documentPreview), (File)new File(tempDocumentPreview), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempDocumentPreview));
        }
        if (new File(imContentFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(imContentFile), (File)new File(tempIMContentFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempIMContentFile));
        }
        if (new File(license).exists()) {
            FileUtil.copyFilesFromDir((File)new File(license), (File)new File(tempLicense), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempLicense));
        }
        if (new File(systemFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(systemFile), (File)new File(tempSystemFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempSystemFile));
        }
        if (new File(templateCode).exists()) {
            FileUtil.copyFilesFromDir((File)new File(templateCode), (File)new File(tempTemplateCode), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempTemplateCode));
        }
        if (new File(templateFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(templateFile), (File)new File(tempTemplateFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempTemplateFile));
        }
        if (new File(userAvatar).exists()) {
            FileUtil.copyFilesFromDir((File)new File(userAvatar), (File)new File(tempUserAvatar), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempUserAvatar));
        }
        if (new File(webAnnexFile).exists()) {
            FileUtil.copyFilesFromDir((File)new File(webAnnexFile), (File)new File(tempWebAnnexFile), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempWebAnnexFile));
        }
        if (new File(biVisualPath).exists()) {
            FileUtil.copyFilesFromDir((File)new File(biVisualPath), (File)new File(tempBiVisualPath), (boolean)true);
        } else {
            FileUtil.mkdir((File)new File(tempBiVisualPath));
        }
        ZipUtils.zipProjectFiles((String)zipDocumentFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipDocumentPreview, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipIMContentFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipLicense, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipSystemFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipTemplateCode, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipTemplateFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipUserAvatar, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipWebAnnexFile, (String)zipFileTargetPath, (String)password, (String)filesPath);
        ZipUtils.zipProjectFiles((String)zipBiVisualPath, (String)zipFileTargetPath, (String)password, (String)filesPath);
        FileUtil.del((String)dackUpFilePath);
    }
}

