/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.daap.capture.model.mapping.MappingTableSqlModel;
import com.bringspring.daap.job.entity.DaapConnectorBackUpEntity;
import com.bringspring.daap.job.entity.DaapConnectorEntity;
import com.bringspring.daap.job.entity.DaapJobClusterEntity;
import com.bringspring.daap.job.service.DaapConnectorBackUpService;
import com.bringspring.daap.job.service.DaapConnectorService;
import com.bringspring.daap.job.service.DaapJobClusterService;
import com.bringspring.database.MySqlTypeMapper;
import com.bringspring.database.OracleTypeMapper;
import com.bringspring.database.PostgresTypeMapper;
import com.bringspring.database.SqlSeverTypeMapper;
import com.bringspring.flink.handler.service.environment.FlinkEnvironmentHandle;
import io.swagger.annotations.Api;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5907\u4efd\u6570\u636e\u6e90"}, value="dataBack")
@RequestMapping(value={"/api/dataBackAndRestore"})
public class DataBackUpAndRestoreUtlis {
    private static final Logger log = LoggerFactory.getLogger(DataBackUpAndRestoreUtlis.class);
    @Autowired
    private DaapConnectorService daapConnectorService;
    @Autowired
    private DaapJobClusterService daapJobClusterService;
    @Autowired
    private DaapConnectorBackUpService daapConnectorBackUpService;

    @GetMapping(value={"/findBackUpSql"})
    void mapping() throws DataException {
        String sourceId = "471939200497842885";
        String path = "F:/";
        DaapConnectorEntity sourceConnector = this.daapConnectorService.getInfo(sourceId);
        DbConnDTO connDTO = this.setResource(sourceConnector);
        DataSourceModel sourceModel = (DataSourceModel)JsonUtil.getJsonToBean((String)sourceConnector.getDataSourceProperties(), DataSourceModel.class);
        try {
            String clusterId = "443029088886587589";
            DaapJobClusterEntity clusterEntity = this.daapJobClusterService.getInfo(clusterId);
            Configuration configuration = new Configuration();
            configuration.setString(String.valueOf(RestOptions.PORT), "8081");
            StreamExecutionEnvironment remoteEnvironment = StreamExecutionEnvironment.createLocalEnvironmentWithWebUI((Configuration)configuration);
            int flinkPort = (Integer)remoteEnvironment.getConfiguration().get(RestOptions.PORT);
            System.out.println("Flink \u7aef\u53e3\uff1a" + flinkPort);
            if (clusterEntity.getType().equals("remote")) {
                remoteEnvironment = FlinkEnvironmentHandle.createRemoteEnvironment(clusterEntity.getJobManagerHost(), clusterEntity.getPort());
            }
            remoteEnvironment.setParallelism(2);
            StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)remoteEnvironment);
            configuration.setString("pipeline.name", sourceConnector.getDataSourceName());
            path = path + "/" + sourceConnector.getDataSourceName();
            StreamStatementSet statementSet = tableEnv.createStatementSet();
            ArrayList jobIds = new ArrayList();
            List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
            for (DbTableModel dbTableModel : tableModelList) {
                this.getTableStructureSql(path, sourceModel, dbTableModel, connDTO);
                MappingTableSqlModel tableSqlModel = this.generateDdl(path, sourceModel, dbTableModel, connDTO);
                tableEnv.executeSql(tableSqlModel.getSourceTableSql());
                tableEnv.executeSql(tableSqlModel.getSinkTableSql());
                statementSet.addInsertSql(tableSqlModel.getInsertSql());
                TableResult result = statementSet.execute();
                ((JobClient)result.getJobClient().get()).getJobExecutionResult().get();
            }
            FileUtil.toZip((String)(path + "/" + connDTO.getDbSource().getDbName() + ".zip"), (boolean)true, (String[])new String[]{path + "/" + connDTO.getDbSource().getDbName()});
            FileUtil.deleteFileAll((File)new File(path + "/" + connDTO.getDbSource().getDbName()));
            long files = new File(path + "/" + connDTO.getDbSource().getDbName() + ".zip").length();
            String size = this.getFileSize(files);
            DaapConnectorBackUpEntity daapConnectorBackUpEntity = new DaapConnectorBackUpEntity();
            String backId = RandomUtil.uuId();
            daapConnectorBackUpEntity.setId(backId);
            daapConnectorBackUpEntity.setConnectorId(sourceId);
            daapConnectorBackUpEntity.setFileSize(size);
            daapConnectorBackUpEntity.setBackupTime(new Date());
            daapConnectorBackUpEntity.setBackupDbName(connDTO.getDbSource().getDbName());
            daapConnectorBackUpEntity.setFileName(connDTO.getDbSource().getDbName() + ".zip");
            daapConnectorBackUpEntity.setFilePath(path);
            daapConnectorBackUpEntity.setDescription(sourceConnector.getDataSourceName() + "\u8fde\u63a5\u5668\u4e0b" + connDTO.getDbSource().getDbName() + "\u6570\u636e\u5e93\u5907\u4efd");
            daapConnectorBackUpEntity.setEnabledMark(1);
            this.daapConnectorBackUpService.save(daapConnectorBackUpEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataException(e.getMessage());
        }
    }

    private DbConnDTO setResource(DaapConnectorEntity dataSourceEntity) throws DataException {
        String dataSourceProperties = dataSourceEntity.getDataSourceProperties();
        DataSourceModel dataSourceModel = new DataSourceModel();
        if (StringUtils.isNotEmpty((CharSequence)dataSourceProperties)) {
            JSONObject jsonObject = JSONObject.parseObject((String)dataSourceProperties);
            String type = dataSourceEntity.getDataSourceType();
            dataSourceModel = this.daapConnectorService.typeChang(jsonObject, type);
            dataSourceProperties = JSON.toJSONString((Object)dataSourceModel);
        }
        DataSourceModel dbSourceOrDbLink = (DataSourceModel)JsonUtil.getJsonToBean((String)dataSourceProperties, DataSourceModel.class);
        try {
            return new DbConnDTO(DbTypeUtil.getDb((DataSourceMod)dbSourceOrDbLink), dbSourceOrDbLink, ConnUtil.getConn((DataSourceMod)dbSourceOrDbLink));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        try {
            Connection conn = connDTO.getConn();
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            PreparedStatementDTO preparedStatementDTO = null;
            preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, (DataSourceMod)connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, (DataSourceMod)connDTO.getDbSource());
            return JdbcUtil.queryCustomMods((PreparedStatementDTO)preparedStatementDTO, modType);
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public void getTableStructureSql(String path, DataSourceModel sourceModel, DbTableModel dbTableModel, DbConnDTO connDTO) throws Exception {
        List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
        String json = JSON.toJSONString(listCommon);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource dataStream = env.fromElements((Object[])new String[]{json});
        dataStream.writeAsText("file:///" + path + "/" + connDTO.getDbSource().getDbName() + "/" + dbTableModel.getTable() + "/structure/structure", FileSystem.WriteMode.OVERWRITE).setParallelism(1);
        env.execute("File Generation Example");
    }

    public MappingTableSqlModel generateDdl(String path, DataSourceModel sourceModel, DbTableModel dbTableModel, DbConnDTO connDTO) throws DataException {
        String dbType;
        MappingTableSqlModel tableSqlModel = new MappingTableSqlModel();
        StringBuilder sourceField = new StringBuilder();
        StringBuilder sourceFieldAndType = new StringBuilder();
        StringBuilder sourceIdAndType = new StringBuilder();
        List<DbTableFieldModel> listCommon = this.getListCommon(dbTableModel.getTable(), DbTableFieldModel.class, connDTO);
        switch (dbType = connDTO.getDbSource().getDbType()) {
            case "MySQL": {
                MySqlTypeMapper mySqlTypeMapper = new MySqlTypeMapper("Mysql5.7", "Mysql8");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                        precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                        scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                    } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                        precision = Integer.parseInt(field.getDataLength());
                    }
                    DataType dataType = null;
                    try {
                        dataType = mySqlTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "Oracle": {
                OracleTypeMapper oracleTypeMapper = new OracleTypeMapper("Oracle", "12.2");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                        precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                        scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                    } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                        precision = Integer.parseInt(field.getDataLength());
                    }
                    DataType dataType = null;
                    try {
                        dataType = oracleTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "PostgreSQL": {
                PostgresTypeMapper postgresTypeMapper = new PostgresTypeMapper("PostgresSql", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                        precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                        scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                    } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                        precision = Integer.parseInt(field.getDataLength());
                    }
                    DataType dataType = null;
                    try {
                        dataType = postgresTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
            case "SQLServer": {
                SqlSeverTypeMapper sqlSeverTypeMapper = new SqlSeverTypeMapper("SQLServer", "11.x");
                listCommon.forEach(field -> {
                    int precision = 0;
                    int scale = 0;
                    if (StringUtils.contains((CharSequence)field.getDataLength(), (CharSequence)",")) {
                        precision = Integer.parseInt(field.getDataLength().split(",")[0]);
                        scale = Integer.parseInt(field.getDataLength().split(",")[1]);
                    } else if (StringUtils.isNumeric((CharSequence)field.getDataLength())) {
                        precision = Integer.parseInt(field.getDataLength());
                    }
                    DataType dataType = null;
                    try {
                        dataType = sqlSeverTypeMapper.mapping(field.getDataType(), precision, scale);
                    }
                    catch (SQLException throwables) {
                        throwables.printStackTrace();
                    }
                    field.setDataType(dataType.toString());
                    if ("1".equals(String.valueOf(field.getPrimaryKey()))) {
                        sourceIdAndType.append(field.getField()).append(",");
                    }
                    field.setField("`" + field.getField() + "`");
                    sourceFieldAndType.append("  ").append(field.getField()).append(" ").append(field.getDataType()).append(",").append("\n");
                    sourceField.append(field.getField()).append(",").append("\n");
                });
                break;
            }
        }
        String sourceCreateSql = "";
        sourceCreateSql = String.format("CREATE TABLE IF NOT EXISTS source_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'jdbc',\n  'url' = '%s',\n  'username' = '%s',\n  'password' = '%s',\n  'table-name' = '%s'\n);\n", dbTableModel.getTable(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "jdbc:mysql://" + connDTO.getDbSource().getHost() + ":" + connDTO.getDbSource().getPort() + "/" + connDTO.getDbSource().getDbName() + "?useUnicode=true&characterEncoding=UTF-8", sourceModel.getUserName(), sourceModel.getPassword(), dbTableModel.getTable());
        tableSqlModel.setSourceTableSql(sourceCreateSql);
        String sinkCreateTable = "";
        sinkCreateTable = String.format("CREATE TABLE IF NOT EXISTS sink_%s (\n%s  PRIMARY KEY (%s) NOT ENFORCED -- \u4e3b\u952e\n) WITH (\n  'connector' = 'filesystem',\n  'path' = '%s',\n  'format' = '%s',\n 'partition.default-name'= '%s'\n);\n", dbTableModel.getTable(), sourceFieldAndType.toString(), StrUtil.removeSuffix((CharSequence)sourceIdAndType.toString(), (CharSequence)","), "file:///" + path + "/" + connDTO.getDbSource().getDbName() + "/" + dbTableModel.getTable() + "/data", "json", dbTableModel.getTable());
        tableSqlModel.setSinkTableSql(sinkCreateTable);
        String insertSql = String.format("insert into sink_%s select %s from source_%s ;\n", dbTableModel.getTable(), StrUtil.removeSuffix((CharSequence)sourceField.toString(), (CharSequence)",\n"), dbTableModel.getTable());
        tableSqlModel.setInsertSql(insertSql);
        return tableSqlModel;
    }

    private String getFileSize(Long files) {
        String size = "0BT";
        DecimalFormat df = new DecimalFormat("#.00");
        size = files < 1024L ? df.format((double)files.longValue()) + "BT" : (files < 0x100000L ? df.format((double)files.longValue() / 1024.0) + "KB" : (files < 0x40000000L ? df.format((double)files.longValue() / 1048576.0) + "MB" : df.format((double)files.longValue() / 1.073741824E9) + "GB"));
        return size;
    }

    private void flinkStatus(JobID jobId) throws Exception {
        Configuration config = new Configuration();
        config.setString("rest.address", "localhost:8081");
        RestClusterClient clusterClient = new RestClusterClient(config, (Object)"", null);
        do {
            JobStatus jobStatus = (JobStatus)clusterClient.getJobStatus(jobId).get();
            System.out.println("Job status: " + jobStatus);
            Thread.sleep(1000L);
        } while (!DataBackUpAndRestoreUtlis.isJobFinished((ClusterClient<String>)clusterClient, jobId));
        System.out.println("Job finished");
        clusterClient.close();
    }

    private static boolean isJobFinished(ClusterClient<String> clusterClient, JobID jobID) throws Exception {
        JobStatus jobStatus = (JobStatus)clusterClient.getJobStatus(jobID).get();
        return jobStatus.isGloballyTerminalState();
    }
}

