/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.utils;

import com.bringspring.daap.datamodel.entity.DaapDataFieldEntity;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataFieldModel;
import com.bringspring.daap.datamodel.model.daapdatatable.DaapDataTableCrForm;

public class JdbcSqlUtils {
    public static String CreatTableSqlString(String dataSourceType, DaapDataTableCrForm daapDataTableCrForm) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSourceType.contains("MySQL")) {
            stringBuffer.append("CREATE table  ").append(daapDataTableCrForm.getTableName()).append(" ( ");
            String primary = "";
            for (DaapDataFieldModel daapDataFieldModel : daapDataTableCrForm.getDaapDataFieldList()) {
                if (daapDataFieldModel.getAllowNull() == 1) {
                    if ("varchar".equals(daapDataFieldModel.getDataType())) {
                        stringBuffer.append("`").append(daapDataFieldModel.getFieldName()).append("`  ").append(daapDataFieldModel.getDataType()).append(" (").append(daapDataFieldModel.getDataLength()).append(") NULL COMMENT '").append(daapDataFieldModel.getFieldComment()).append("',");
                    } else {
                        stringBuffer.append("`").append(daapDataFieldModel.getFieldName()).append("`  ").append(daapDataFieldModel.getDataType()).append(" NULL COMMENT '").append(daapDataFieldModel.getFieldComment()).append("',");
                    }
                } else if ("varchar".equals(daapDataFieldModel.getDataType())) {
                    stringBuffer.append("`").append(daapDataFieldModel.getFieldName()).append("`  ").append(daapDataFieldModel.getDataType()).append(" (").append(daapDataFieldModel.getDataLength()).append(") not NULL COMMENT '").append(daapDataFieldModel.getFieldComment()).append("',");
                } else {
                    stringBuffer.append("`").append(daapDataFieldModel.getFieldName()).append("`  ").append(daapDataFieldModel.getDataType()).append(" not NULL COMMENT '").append(daapDataFieldModel.getFieldComment()).append("',");
                }
                if (daapDataFieldModel.getPrimaryKey() != 1) continue;
                primary = "PRIMARY KEY (" + daapDataFieldModel.getFieldName() + ")";
            }
            stringBuffer.append(primary).append(") COMMENT= '").append(daapDataTableCrForm.getTableComment()).append("'");
        } else if (dataSourceType.contains("Oracle") || dataSourceType.contains("PostgreSQL") || dataSourceType.contains("SQLServer")) {
            // empty if block
        }
        return stringBuffer.toString();
    }

    public static String updateFieldSqlString(String dataSourceType, String tableName, DaapDataFieldEntity entitys) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSourceType.contains("MySQL") || dataSourceType.contains("Oracle")) {
            stringBuffer.append("ALTER TABLE  `").append(tableName).append("` MODIFY `");
            String primary = "";
            if (entitys.getAllowNull() == 1) {
                if ("varchar".equals(entitys.getDataType())) {
                    stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" (").append(entitys.getDataLength()).append(") NULL COMMENT '").append(entitys.getFieldComment()).append("'");
                } else {
                    stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" NULL COMMENT '").append(entitys.getFieldComment()).append("'");
                }
            } else if ("varchar".equals(entitys.getDataType())) {
                stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" (").append(entitys.getDataLength()).append(") NOT NULL COMMENT '").append(entitys.getFieldComment()).append("'");
            } else {
                stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" NOT NULL COMMENT '").append(entitys.getFieldComment()).append("'");
            }
            if (entitys.getPrimaryKey() == 1) {
                stringBuffer.append(", DROP PRIMARY KEY, ADD PRIMARY KEY (`").append(entitys.getFieldName()).append("`)");
            }
        } else if (dataSourceType.contains("PostgreSQL") || dataSourceType.contains("SQLServer")) {
            // empty if block
        }
        return stringBuffer.toString();
    }

    public static String addFieldSqlString(String dataSourceType, String tableName, DaapDataFieldEntity entitys) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSourceType.contains("MySQL") || dataSourceType.contains("Oracle")) {
            stringBuffer.append("ALTER TABLE  `").append(tableName).append("` ADD `");
            String primary = "";
            if (entitys.getAllowNull() == 1) {
                if ("varchar".equals(entitys.getDataType())) {
                    stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" (").append(entitys.getDataLength()).append(") NULL COMMENT '").append(entitys.getFieldComment()).append("'");
                } else {
                    stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" NULL COMMENT '").append(entitys.getFieldComment()).append("'");
                }
            } else if ("varchar".equals(entitys.getDataType())) {
                stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" (").append(entitys.getDataLength()).append(") NOT NULL COMMENT '").append(entitys.getFieldComment()).append("'");
            } else {
                stringBuffer.append(entitys.getFieldName()).append("` ").append(entitys.getDataType()).append(" NOT NULL COMMENT '").append(entitys.getFieldComment()).append("'");
            }
            if (entitys.getPrimaryKey() == 1) {
                stringBuffer.append(", DROP PRIMARY KEY, ADD PRIMARY KEY (`").append(entitys.getFieldName()).append("`)");
            }
        } else if (dataSourceType.contains("PostgreSQL") || dataSourceType.contains("SQLServer")) {
            // empty if block
        }
        return stringBuffer.toString();
    }
}

