/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.utils;

import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConn(final String userName, final String password, final String url) {
        final Connection[] conn = new Connection[]{null};
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (url.contains(DbType.MYSQL.getDb())) {
                        Class.forName("com.mysql.cj.jdbc.Driver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    } else if (url.contains(DbType.ORACLE.getDb())) {
                        Class.forName("oracle.jdbc.OracleDriver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    } else if (url.contains(DbType.SQL_SERVER.getDb())) {
                        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    } else if (url.contains(DbType.DM.getDb())) {
                        Class.forName("dm.jdbc.driver.DmDriver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    } else if (url.contains(DbType.POSTGRE_SQL.getDb())) {
                        Class.forName("org.postgresql.Driver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    } else if (url.contains("kingbase")) {
                        Class.forName("com.kingbase8.Driver");
                        String connectionUrl = url;
                        conn[0] = DriverManager.getConnection(connectionUrl, userName, password);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                return "jdbc\u8fde\u63a5\u6210\u529f";
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(task);
        try {
            String string = future.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error("\u8fde\u63a5\u6570\u636e\u5e93\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5f02\u5e38254," + e.getStackTrace());
        }
        finally {
            executorService.shutdown();
        }
        return conn[0];
    }
}

