/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.database;

import com.bringspring.database.JdbcDialectTypeMapper;
import java.sql.SQLException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OracleTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(OracleTypeMapper.class);
    private static final String ORACLE_CHAR = "CHAR";
    private static final String ORACLE_VARCHAR2 = "VARCHAR2";
    private static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    private static final String ORACLE_ROWID = "ROW";
    private static final String ORACLE_NUMBER = "NUMBER";
    private static final String ORACLE_DECIMAL = "DECIMAL";
    private static final String ORACLE_FLOAT = "FLOAT";
    private static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    private static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    private static final String ORACLE_DATE = "DATE";
    private static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    private static final String ORACLE_TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    private static final String ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    private static final String ORACLE_INTERVAL_YEAR_TO_MONTH = "INTERVAL YEAR TO MONTH";
    private static final String ORACLE_INTERVAL_DAY_TO_SECOND = "INTERVAL DAY TO SECOND";
    private static final String ORACLE_CLOB = "CLOB";
    private static final String ORACLE_NCLOB = "NCLOB";
    private static final String ORACLE_BLOB = "BLOB";
    private static final String ORACLE_BFILE = "BFILE";
    private static final String ORACLE_RAW = "RAW";
    private static final String ORACLE_XMLTYPE = "XMLTYPE";
    private final String databaseVersion;
    private final String driverVersion;

    public OracleTypeMapper(String databaseVersion, String driverVersion) {
        this.databaseVersion = databaseVersion;
        this.driverVersion = driverVersion;
    }

    @Override
    public DataType mapping(String OracleType, int precision, int scale) throws SQLException {
        switch (OracleType = OracleType.toUpperCase()) {
            case "CHAR": {
                return DataTypes.CHAR((int)precision);
            }
            case "VARCHAR2": 
            case "NVARCHAR2": {
                return DataTypes.VARCHAR((int)precision);
            }
            case "ROW": {
                return DataTypes.ROW();
            }
            case "NUMBER": {
                if (precision > 38) {
                    return DataTypes.DECIMAL((int)38, (int)0);
                }
                return DataTypes.DECIMAL((int)precision, (int)scale);
            }
            case "DECIMAL": {
                return DataTypes.DECIMAL((int)precision, (int)scale);
            }
            case "FLOAT": {
                return DataTypes.FLOAT();
            }
            case "BINARY_FLOAT": {
                return DataTypes.FLOAT();
            }
            case "BINARY_DOUBLE": {
                return DataTypes.DOUBLE();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "TIMESTAMP": 
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP WITH LOCAL TIME ZONE": {
                return DataTypes.TIMESTAMP();
            }
            case "INTERVAL YEAR TO MONTH": {
                return DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH());
            }
            case "INTERVAL DAY TO SECOND": {
                return DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND());
            }
            case "CLOB": 
            case "NCLOB": {
                return DataTypes.STRING();
            }
            case "BLOB": 
            case "BFILE": {
                return DataTypes.BYTES();
            }
            case "RAW": {
                return DataTypes.ROW();
            }
            case "XMLTYPE": {
                return DataTypes.STRING();
            }
        }
        return DataTypes.STRING();
    }
}

