/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.database;

import com.bringspring.database.JdbcDialectTypeMapper;
import java.sql.SQLException;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSeverTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSeverTypeMapper.class);
    private static final String SQLSEVER_BIT = "BIT";
    private static final String SQLSEVER_TINYINT = "TINYINT";
    private static final String SQLSEVER_SMALLINT = "SMALLINT";
    private static final String SQLSEVER_INT = "INT";
    private static final String SQLSEVER_BIGINT = "BIGINT";
    private static final String SQLSEVER_DECIMAL = "DECIMAL";
    private static final String SQLSEVER_NUMERIC = "NUMERIC";
    private static final String SQLSEVER_REAL = "REAL";
    private static final String SQLSEVER_FLOAT = "FLOAT";
    private static final String SQLSEVER_DOUBLE = "DOUBLE";
    private static final String SQLSEVER_DATE = "DATE";
    private static final String SQLSEVER_TIME = "TIME";
    private static final String SQLSEVER_DATETIME = "DATETIME";
    private static final String SQLSEVER_DATETIME2 = "DATETIME2";
    private static final String SQLSEVER_CHAR = "CHAR";
    private static final String SQLSEVER_NCHAR = "NCHAR";
    private static final String SQLSEVER_VARCHAR = "VARCHAR";
    private static final String SQLSEVER_NVARCHAR = "NVARCHAR";
    private static final String SQLSEVER_TEXT = "TEXT";
    private static final String SQLSEVER_NTEXT = "NTEXT";
    private static final String SQLSEVER_BINARY = "BINARY";
    private static final String SQLSEVER_VARBINARY = "VARBINARY";
    private final String databaseVersion;
    private final String driverVersion;

    public SqlSeverTypeMapper(String databaseVersion, String driverVersion) {
        this.databaseVersion = databaseVersion;
        this.driverVersion = driverVersion;
    }

    @Override
    public DataType mapping(String SqlSeverType, int precision, int scale) throws SQLException {
        switch (SqlSeverType = SqlSeverType.toUpperCase()) {
            case "BIT": {
                return DataTypes.BOOLEAN();
            }
            case "TINYINT": {
                return DataTypes.TINYINT();
            }
            case "SMALLINT": {
                return DataTypes.SMALLINT();
            }
            case "INT": {
                return DataTypes.INT();
            }
            case "BIGINT": {
                return DataTypes.BIGINT();
            }
            case "DECIMAL": 
            case "NUMERIC": {
                if (precision > 38) {
                    return DataTypes.DECIMAL((int)38, (int)0);
                }
                return DataTypes.DECIMAL((int)precision, (int)scale);
            }
            case "REAL": {
                return DataTypes.FLOAT();
            }
            case "FLOAT": 
            case "DOUBLE": {
                return DataTypes.DOUBLE();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "TIME": {
                return DataTypes.TIME();
            }
            case "DATETIME": 
            case "DATETIME2": {
                return DataTypes.TIMESTAMP();
            }
            case "CHAR": 
            case "NCHAR": 
            case "VARCHAR": 
            case "NVARCHAR": 
            case "TEXT": 
            case "NTEXT": {
                return DataTypes.STRING();
            }
            case "BINARY": 
            case "VARBINARY": {
                return DataTypes.BYTES();
            }
        }
        return DataTypes.STRING();
    }
}

