/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.executor;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.StringUtils;

public class EnvironmentSetting {
    private String host;
    private Integer port;
    private String[] jarFiles;
    private boolean useRemote;
    public static final EnvironmentSetting LOCAL = new EnvironmentSetting(false);

    public EnvironmentSetting(boolean useRemote) {
        this.useRemote = useRemote;
    }

    public EnvironmentSetting(String ... jarFiles) {
        this.useRemote = false;
        this.jarFiles = jarFiles;
    }

    public EnvironmentSetting(String host, Integer port, String ... jarFiles) {
        this.host = host;
        this.port = port;
        this.useRemote = true;
        this.jarFiles = jarFiles;
    }

    public static EnvironmentSetting build(String address, String ... jarFiles) {
        String[] strs = address.split(":");
        if (strs.length >= 2) {
            return new EnvironmentSetting(strs[0], Integer.parseInt(strs[1]), jarFiles);
        }
        return new EnvironmentSetting(jarFiles);
    }

    public String getAddress() {
        if (StringUtils.isEmpty((String)this.host) && ObjectUtil.isNotNull((Object)this.port)) {
            return this.host + ":" + this.port;
        }
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String[] getJarFiles() {
        return this.jarFiles;
    }

    public boolean isUseRemote() {
        return this.useRemote;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setJarFiles(String[] jarFiles) {
        this.jarFiles = jarFiles;
    }

    public void setUseRemote(boolean useRemote) {
        this.useRemote = useRemote;
    }
}

