/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.executor;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorSetting {
    private static final Logger log = LoggerFactory.getLogger(ExecutorSetting.class);
    public static final ExecutorSetting DEFAULT = new ExecutorSetting(0, 1, true);
    public static final String CHECKPOINT_CONST = "checkpoint";
    public static final String PARALLELISM_CONST = "parallelism";
    public static final String USE_SQL_FRAGMENT = "useSqlFragment";
    public static final String USE_STATEMENT_SET = "useStatementSet";
    public static final String USE_BATCH_MODEL = "useBatchModel";
    public static final String SAVE_POINT_PATH = "savePointPath";
    public static final String JOB_NAME = "jobName";
    public static final String CONFIG_CONST = "config";
    private static final ObjectMapper mapper = new ObjectMapper();
    private boolean useBatchModel;
    private Integer checkpoint;
    private Integer parallelism;
    private boolean useSqlFragment;
    private boolean useStatementSet;
    private String savePointPath;
    private String jobName;
    private Map<String, String> config;

    public ExecutorSetting(boolean useSqlFragment) {
        this(null, useSqlFragment);
    }

    public ExecutorSetting(Integer checkpoint) {
        this(checkpoint, false);
    }

    public ExecutorSetting(Integer checkpoint, boolean useSqlFragment) {
        this(checkpoint, null, useSqlFragment, null, null);
    }

    public ExecutorSetting(Integer checkpoint, Integer parallelism, boolean useSqlFragment) {
        this(checkpoint, parallelism, useSqlFragment, null, null);
    }

    public ExecutorSetting(Integer checkpoint, Integer parallelism, boolean useSqlFragment, String savePointPath, String jobName) {
        this(checkpoint, parallelism, useSqlFragment, savePointPath, jobName, null);
    }

    public ExecutorSetting(Integer checkpoint, Integer parallelism, boolean useSqlFragment, String savePointPath) {
        this(checkpoint, parallelism, useSqlFragment, savePointPath, null, null);
    }

    public ExecutorSetting(Integer checkpoint, Integer parallelism, boolean useSqlFragment, String savePointPath, String jobName, Map<String, String> config) {
        this(checkpoint, parallelism, useSqlFragment, false, false, savePointPath, jobName, config);
    }

    public ExecutorSetting(Integer checkpoint, Integer parallelism, boolean useSqlFragment, boolean useStatementSet, boolean useBatchModel, String savePointPath, String jobName, Map<String, String> config) {
        this.checkpoint = checkpoint;
        this.parallelism = parallelism;
        this.useSqlFragment = useSqlFragment;
        this.useStatementSet = useStatementSet;
        this.useBatchModel = useBatchModel;
        this.savePointPath = savePointPath;
        this.jobName = jobName;
        this.config = config;
    }

    public static ExecutorSetting build(Integer checkpoint, Integer parallelism, boolean useSqlFragment, boolean useStatementSet, boolean useBatchModel, String savePointPath, String jobName, String configJson) {
        List configList = new ArrayList();
        if (StringUtils.isNotEmpty((String)configJson)) {
            try {
                configList = (List)mapper.readValue(configJson, ArrayList.class);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage());
            }
        }
        HashMap<String, String> config = new HashMap<String, String>();
        for (Map item : configList) {
            if (!ObjectUtil.isNotNull((Object)item) || !StringUtils.isEmpty((String[])new String[]{(String)item.get("key"), (String)item.get("value")})) continue;
            config.put((String)item.get("key"), (String)item.get("value"));
        }
        return new ExecutorSetting(checkpoint, parallelism, useSqlFragment, useStatementSet, useBatchModel, savePointPath, jobName, config);
    }

    public static ExecutorSetting build(Map<String, String> settingMap) {
        Integer checkpoint = NumberUtils.createInteger((String)settingMap.get(CHECKPOINT_CONST));
        Integer parallelism = NumberUtils.createInteger((String)settingMap.get(PARALLELISM_CONST));
        return ExecutorSetting.build(checkpoint, parallelism, "1".equals(settingMap.get(USE_SQL_FRAGMENT)), "1".equals(settingMap.get(USE_STATEMENT_SET)), "1".equals(settingMap.get(USE_BATCH_MODEL)), settingMap.get(SAVE_POINT_PATH), settingMap.get(JOB_NAME), settingMap.get(CONFIG_CONST));
    }

    public boolean isValidParallelism() {
        return ObjectUtil.isNotNull((Object)this.getParallelism()) && this.getParallelism() > 0;
    }

    public boolean isValidJobName() {
        return StringUtils.isNotEmpty((String)this.getJobName());
    }

    public boolean isValidConfig() {
        return MapUtil.isNotEmpty(this.getConfig());
    }

    public String toString() {
        return String.format("ExecutorSetting{checkpoint=%d, parallelism=%d, useSqlFragment=%s, useStatementSet=%s, savePointPath='%s', jobName='%s', config=%s}", this.checkpoint, this.parallelism, this.useSqlFragment, this.useStatementSet, this.savePointPath, this.jobName, this.config);
    }

    public void setUseBatchModel(boolean useBatchModel) {
        this.useBatchModel = useBatchModel;
    }

    public void setCheckpoint(Integer checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public void setUseSqlFragment(boolean useSqlFragment) {
        this.useSqlFragment = useSqlFragment;
    }

    public void setUseStatementSet(boolean useStatementSet) {
        this.useStatementSet = useStatementSet;
    }

    public void setSavePointPath(String savePointPath) {
        this.savePointPath = savePointPath;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public boolean isUseBatchModel() {
        return this.useBatchModel;
    }

    public Integer getCheckpoint() {
        return this.checkpoint;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public boolean isUseSqlFragment() {
        return this.useSqlFragment;
    }

    public boolean isUseStatementSet() {
        return this.useStatementSet;
    }

    public String getSavePointPath() {
        return this.savePointPath;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

