/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.flink.catalog.impl;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.daap.job.DataSourceTypeEnum;
import com.bringspring.exception.DaapException;
import com.bringspring.flink.catalog.model.CatalogDatebase;
import com.bringspring.flink.catalog.model.CatalogTable;
import com.bringspring.system.base.model.dblink.DbLinkBaseForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.jdbc.catalog.JdbcCatalogUtils;
import org.apache.flink.connector.jdbc.databases.mysql.catalog.MySqlCatalog;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.DefaultCatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.types.AbstractDataType;

public class JsbosCatalogImpl {
    public boolean SyncCatalog(String catalogName, String catalogType, String sourceProperties) throws DaapException {
        if (StringUtils.isEmpty((String[])new String[]{catalogName, catalogType})) {
            throw new DaapException("\u6570\u636e\u5143\u540d\u79f0/\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DataSourceTypeEnum.JDBC.equals(catalogType) && StringUtils.isEmpty((String)sourceProperties)) {
            throw new DaapException("\u6570\u636e\u5e93\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DataSourceTypeEnum.JDBC.equals(catalogType)) {
            // empty if block
        }
        return true;
    }

    public void getCatalog(String catalogName, String catalogsProperties) throws DaapException, DatabaseNotExistException, TableNotExistException {
        JSONObject jsonObject = JSONObject.parseObject((String)catalogsProperties);
        DbLinkBaseForm dbLinkBaseForm = (DbLinkBaseForm)JsonUtil.getJsonToBean((Object)jsonObject, DbLinkBaseForm.class);
        DbLinkEntity dbLinkEntity = dbLinkBaseForm.getDbLinkEntity(dbLinkBaseForm);
        String defaultDatabase = dbLinkEntity.getDbName();
        String username = dbLinkEntity.getUserName();
        String pwd = dbLinkEntity.getPassword();
        String baseUrl = dbLinkEntity.getUrl();
        MySqlCatalog jdbcCatalog = (MySqlCatalog)JdbcCatalogUtils.createCatalog((ClassLoader)ClassLoader.getSystemClassLoader(), (String)catalogName, (String)defaultDatabase, (String)username, (String)pwd, (String)baseUrl);
        List listDatabases = jdbcCatalog.listDatabases();
        ArrayList<CatalogDatebase> datebaseList = new ArrayList<CatalogDatebase>();
        for (String dbName : listDatabases) {
            CatalogDatabase database = jdbcCatalog.getDatabase(dbName);
            CatalogDatebase catalogDatebase = new CatalogDatebase(dbName, database.getComment());
            List listTables = jdbcCatalog.listTables(dbName);
            for (String tableName : listTables) {
                ObjectPath objectPath = new ObjectPath(dbName, tableName);
                DefaultCatalogTable table = (DefaultCatalogTable)jdbcCatalog.getTable(objectPath);
                String comment = table.getComment();
                CatalogTable catalogTable = new CatalogTable(tableName, comment);
                catalogDatebase.getCatalogTableList().add(catalogTable);
                Schema unresolvedSchema = table.getUnresolvedSchema();
                List columns = unresolvedSchema.getColumns();
                Schema.UnresolvedPhysicalColumn unresolvedColumn = (Schema.UnresolvedPhysicalColumn)columns.get(0);
                Optional primaryKey = unresolvedSchema.getPrimaryKey();
                Schema schema = Schema.newBuilder().column("name", (AbstractDataType)DataTypes.STRING()).column("age", (AbstractDataType)DataTypes.INT()).build();
            }
            datebaseList.add(catalogDatebase);
        }
    }

    public static void main(String[] args) throws Exception {
        JsbosCatalogImpl jsbosCatalog = new JsbosCatalogImpl();
    }
}

