/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.flink.catalog.utils;

import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.JdbcCatalogUtils;
import org.apache.flink.connector.jdbc.databases.mysql.catalog.MySqlCatalog;
import org.apache.flink.connector.jdbc.databases.mysql.dialect.MySqlDialect;
import org.apache.flink.connector.jdbc.databases.oracle.dialect.OracleDialect;
import org.apache.flink.connector.jdbc.databases.postgres.catalog.PostgresCatalog;
import org.apache.flink.connector.jdbc.databases.postgres.dialect.PostgresDialect;
import org.apache.flink.connector.jdbc.databases.sqlserver.dialect.SqlServerDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectLoader;
import org.apache.flink.util.Preconditions;

public class JsbosJdbcCatalogUtils
extends JdbcCatalogUtils {
    public static void validateJdbcUrl(String url) {
        String[] parts = url.trim().split("\\/+");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
    }

    public static AbstractJdbcCatalog createCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        ClassLoader userClassLoader = ClassLoader.getSystemClassLoader();
        JdbcDialect dialect = JdbcDialectLoader.load((String)baseUrl, (ClassLoader)userClassLoader);
        if (dialect instanceof PostgresDialect) {
            return new PostgresCatalog(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        if (dialect instanceof MySqlDialect) {
            return new MySqlCatalog(userClassLoader, catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        if (dialect instanceof OracleDialect) {
            return null;
        }
        if (dialect instanceof SqlServerDialect) {
            return null;
        }
        throw new UnsupportedOperationException(String.format("Catalog for '%s' is not supported yet.", dialect));
    }
}

