/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.entity.DaapDataSourceEntity;
import com.bringspring.daap.model.daapdatasource.DaapDataSourceCrForm;
import com.bringspring.daap.model.daapdatasource.DaapDataSourceInfoVO;
import com.bringspring.daap.model.daapdatasource.DaapDataSourceListVO;
import com.bringspring.daap.model.daapdatasource.DaapDataSourcePagination;
import com.bringspring.daap.model.daapdatasource.DaapDataSourceUpForm;
import com.bringspring.daap.service.DaapDataSourceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u6e90\u7ba1\u7406\u8868"}, value="daap")
@RequestMapping(value={"/api/daap/DaapDataSource"})
public class DaapDataSourceController {
    private static final Logger log = LoggerFactory.getLogger(DaapDataSourceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapDataSourceService daapDataSourceService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapDataSourcePagination daapDataSourcePagination) throws IOException {
        List<DaapDataSourceEntity> list = this.daapDataSourceService.getList(daapDataSourcePagination);
        for (DaapDataSourceEntity daapDataSourceEntity : list) {
            daapDataSourceEntity.setEnabledMark(this.baseDataUtil.switchSelectValue(String.valueOf(daapDataSourceEntity.getEnabledMark()), "\u6709\u6548", "\u65e0\u6548"));
            daapDataSourceEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(daapDataSourceEntity.getCreatorUserId()));
            daapDataSourceEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(daapDataSourceEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, DaapDataSourceListVO.class);
        for (DaapDataSourceListVO daapDataSourceListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapDataSourcePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapDataSourceCrForm daapDataSourceCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        daapDataSourceCrForm.setCreatorUserId(userInfo.getUserId());
        daapDataSourceCrForm.setCreatorTime(DateUtil.getNow());
        DaapDataSourceEntity entity = (DaapDataSourceEntity)JsonUtil.getJsonToBean((Object)daapDataSourceCrForm, DaapDataSourceEntity.class);
        entity.setId(mainId);
        this.daapDataSourceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapDataSourceInfoVO> info(@PathVariable(value="id") String id) {
        DaapDataSourceEntity entity = this.daapDataSourceService.getInfo(id);
        DaapDataSourceInfoVO vo = (DaapDataSourceInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataSourceInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapDataSourceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapDataSourceEntity entity = this.daapDataSourceService.getInfo(id);
        DaapDataSourceInfoVO vo = (DaapDataSourceInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapDataSourceInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u5f00", "\u5173"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapDataSourceUpForm daapDataSourceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapDataSourceEntity entity = this.daapDataSourceService.getInfo(id);
        if (entity != null) {
            daapDataSourceUpForm.setLastModifyUserId(userInfo.getUserId());
            daapDataSourceUpForm.setLastModifyTime(DateUtil.getNow());
            DaapDataSourceEntity subentity = (DaapDataSourceEntity)JsonUtil.getJsonToBean((Object)daapDataSourceUpForm, DaapDataSourceEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.daapDataSourceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapDataSourceEntity entity = this.daapDataSourceService.getInfo(id);
        if (entity != null) {
            this.daapDataSourceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

