/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.daap.entity.DaapJobClusterEntity;
import com.bringspring.daap.model.daapjobcluster.DaapJobClusterCrForm;
import com.bringspring.daap.model.daapjobcluster.DaapJobClusterInfoVO;
import com.bringspring.daap.model.daapjobcluster.DaapJobClusterListVO;
import com.bringspring.daap.model.daapjobcluster.DaapJobClusterPagination;
import com.bringspring.daap.model.daapjobcluster.DaapJobClusterUpForm;
import com.bringspring.daap.service.DaapJobClusterService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f5c\u4e1a\u5f15\u64ce"}, value="daap")
@RequestMapping(value={"/api/daap/DaapJobCluster"})
public class DaapJobClusterController {
    private static final Logger log = LoggerFactory.getLogger(DaapJobClusterController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DaapJobClusterService daapJobClusterService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapJobClusterPagination daapJobClusterPagination) throws IOException {
        List<DaapJobClusterEntity> list = this.daapJobClusterService.getList(daapJobClusterPagination);
        List listVO = JsonUtil.getJsonToList(list, DaapJobClusterListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapJobClusterPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid DaapJobClusterCrForm daapJobClusterCrForm) throws DataException {
        DaapJobClusterEntity entity = (DaapJobClusterEntity)JsonUtil.getJsonToBean((Object)daapJobClusterCrForm, DaapJobClusterEntity.class);
        entity.setId(RandomUtil.uuId());
        this.daapJobClusterService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapJobClusterInfoVO> info(@PathVariable(value="id") String id) {
        DaapJobClusterEntity entity = this.daapJobClusterService.getInfo(id);
        DaapJobClusterInfoVO vo = (DaapJobClusterInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobClusterInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapJobClusterInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapJobClusterEntity entity = this.daapJobClusterService.getInfo(id);
        DaapJobClusterInfoVO vo = (DaapJobClusterInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobClusterInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapJobClusterUpForm daapJobClusterUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        DaapJobClusterEntity entity = this.daapJobClusterService.getInfo(id);
        if (entity != null) {
            DaapJobClusterEntity subentity = (DaapJobClusterEntity)JsonUtil.getJsonToBean((Object)daapJobClusterUpForm, DaapJobClusterEntity.class);
            this.daapJobClusterService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapJobClusterEntity entity = this.daapJobClusterService.getInfo(id);
        if (entity != null) {
            this.daapJobClusterService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

