/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.daap.entity.DaapJobInstanceEntity;
import com.bringspring.daap.model.daapjobinstance.DaapJobInstanceCrForm;
import com.bringspring.daap.model.daapjobinstance.DaapJobInstanceInfoVO;
import com.bringspring.daap.model.daapjobinstance.DaapJobInstanceListVO;
import com.bringspring.daap.model.daapjobinstance.DaapJobInstancePagination;
import com.bringspring.daap.model.daapjobinstance.DaapJobInstanceUpForm;
import com.bringspring.daap.service.DaapJobInstanceService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f5c\u4e1a\u5b9e\u4f8b"}, value="daap")
@RequestMapping(value={"/api/daap/DaapJobInstance"})
public class DaapJobInstanceController {
    private static final Logger log = LoggerFactory.getLogger(DaapJobInstanceController.class);
    @Autowired
    private DaapJobInstanceService daapJobInstanceService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapJobInstancePagination daapJobInstancePagination) throws IOException {
        List<DaapJobInstanceEntity> list = this.daapJobInstanceService.getList(daapJobInstancePagination);
        for (DaapJobInstanceEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, DaapJobInstanceListVO.class);
        for (DaapJobInstanceListVO daapJobInstanceListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapJobInstancePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid DaapJobInstanceCrForm daapJobInstanceCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        DaapJobInstanceEntity entity = (DaapJobInstanceEntity)JsonUtil.getJsonToBean((Object)daapJobInstanceCrForm, DaapJobInstanceEntity.class);
        entity.setId(mainId);
        this.daapJobInstanceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapJobInstanceInfoVO> info(@PathVariable(value="id") String id) {
        DaapJobInstanceEntity entity = this.daapJobInstanceService.getInfo(id);
        DaapJobInstanceInfoVO vo = (DaapJobInstanceInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobInstanceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<DaapJobInstanceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DaapJobInstanceEntity entity = this.daapJobInstanceService.getInfo(id);
        DaapJobInstanceInfoVO vo = (DaapJobInstanceInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobInstanceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapJobInstanceUpForm daapJobInstanceUpForm) throws DataException {
        DaapJobInstanceEntity entity = this.daapJobInstanceService.getInfo(id);
        if (entity != null) {
            DaapJobInstanceEntity subentity = (DaapJobInstanceEntity)JsonUtil.getJsonToBean((Object)daapJobInstanceUpForm, DaapJobInstanceEntity.class);
            this.daapJobInstanceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapJobInstanceEntity entity = this.daapJobInstanceService.getInfo(id);
        if (entity != null) {
            this.daapJobInstanceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

