/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.daap.entity.DaapJobTypeEntity;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeCrForm;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeInfoVO;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeListTreeVO;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeListVO;
import com.bringspring.daap.model.daapjobtype.DaapJobTypePagination;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeUpForm;
import com.bringspring.daap.service.DaapJobTypeService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u5206\u7c7b"}, value="daap")
@RequestMapping(value={"/api/daap/DaapJobType"})
public class DaapJobTypeController {
    private static final Logger log = LoggerFactory.getLogger(DaapJobTypeController.class);
    @Autowired
    private DaapJobTypeService daapJobTypeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody DaapJobTypePagination daapJobTypePagination) throws IOException {
        List<DaapJobTypeEntity> list = this.daapJobTypeService.getList(daapJobTypePagination);
        List listVO = JsonUtil.getJsonToList(list, DaapJobTypeListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)daapJobTypePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId) {
        List<DaapJobTypeListTreeVO> listVO = this.daapJobTypeService.getListTree(parentId);
        return ActionResult.success(listVO);
    }

    @GetMapping(value={"/getListTreeAndJobSource"})
    public ActionResult getListTreeAndJobSource(@RequestParam String parentId) {
        List<DaapJobTypeListTreeVO> listVO = this.daapJobTypeService.getListTreeAndJobSource(parentId);
        return ActionResult.success(listVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid DaapJobTypeCrForm daapJobTypeCrForm) throws DataException {
        DaapJobTypeEntity entity = (DaapJobTypeEntity)JsonUtil.getJsonToBean((Object)daapJobTypeCrForm, DaapJobTypeEntity.class);
        entity.setId(RandomUtil.uuId());
        this.daapJobTypeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<DaapJobTypeInfoVO> info(@PathVariable(value="id") String id) {
        DaapJobTypeEntity entity = this.daapJobTypeService.getInfo(id);
        DaapJobTypeInfoVO vo = (DaapJobTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, DaapJobTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid DaapJobTypeUpForm daapJobTypeUpForm) throws DataException {
        DaapJobTypeEntity entity = this.daapJobTypeService.getInfo(id);
        if (entity != null) {
            DaapJobTypeEntity subentity = (DaapJobTypeEntity)JsonUtil.getJsonToBean((Object)daapJobTypeUpForm, DaapJobTypeEntity.class);
            this.daapJobTypeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        DaapJobTypeEntity entity = this.daapJobTypeService.getInfo(id);
        if (entity != null) {
            this.daapJobTypeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

