/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.daap.entity.DaapJobInstanceEntity;
import com.bringspring.daap.entity.DaapJobSourceEntity;
import com.bringspring.daap.mapper.DaapJobSourceMapper;
import com.bringspring.daap.model.daapjobsource.DaapJobSourcePagination;
import com.bringspring.daap.service.DaapJobInstanceService;
import com.bringspring.daap.service.DaapJobSourceService;
import com.bringspring.flink.handler.service.FlinkHandleService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapJobSourceServiceImpl
extends ServiceImpl<DaapJobSourceMapper, DaapJobSourceEntity>
implements DaapJobSourceService {
    @Autowired
    private FlinkHandleService flinkHandleService;
    @Autowired
    private DaapJobInstanceService daapJobInstanceService;

    @Override
    public List<DaapJobSourceEntity> getList(DaapJobSourcePagination daapJobSourcePagination) {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)daapJobSourcePagination.getName())) {
            daapJobSourceQueryWrapper.lambda().like(DaapJobSourceEntity::getName, (Object)daapJobSourcePagination.getName());
        }
        if (StringUtil.isNotEmpty((String)daapJobSourcePagination.getTypeId())) {
            daapJobSourceQueryWrapper.lambda().eq(DaapJobSourceEntity::getTypeId, (Object)daapJobSourcePagination.getTypeId());
        }
        Page page = new Page(daapJobSourcePagination.getCurrentPage(), daapJobSourcePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)daapJobSourceQueryWrapper);
        return daapJobSourcePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public DaapJobSourceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapJobSourceEntity::getId, (Object)id);
        return (DaapJobSourceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String check(String id) throws Exception {
        DaapJobSourceEntity info = this.getInfo(id);
        return this.flinkHandleService.check(info.getEtlContent());
    }

    @Override
    public boolean submit(String id) {
        DaapJobSourceEntity info = this.getInfo(id);
        String s = this.flinkHandleService.submitRemote(info.getEtlContent());
        DaapJobInstanceEntity daapJobInstanceEntity = new DaapJobInstanceEntity();
        daapJobInstanceEntity.setName(info.getName() + "\u5b9e\u4f8b");
        daapJobInstanceEntity.setLiftCycle("\u8fdb\u884c\u4e2d");
        daapJobInstanceEntity.setId(RandomUtil.uuId());
        daapJobInstanceEntity.setFlinkJobId(s);
        daapJobInstanceEntity.setJobSourceId(id);
        daapJobInstanceEntity.setEnabledMark(0);
        this.daapJobInstanceService.create(daapJobInstanceEntity);
        return true;
    }

    @Override
    public void create(DaapJobSourceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapJobSourceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DaapJobSourceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

