/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.daap.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtil;
import com.bringspring.daap.entity.DaapJobSourceEntity;
import com.bringspring.daap.entity.DaapJobTypeEntity;
import com.bringspring.daap.mapper.DaapJobTypeMapper;
import com.bringspring.daap.model.daapjobtype.DaapJobTypeListTreeVO;
import com.bringspring.daap.model.daapjobtype.DaapJobTypePagination;
import com.bringspring.daap.service.DaapJobSourceService;
import com.bringspring.daap.service.DaapJobTypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DaapJobTypeServiceImpl
extends ServiceImpl<DaapJobTypeMapper, DaapJobTypeEntity>
implements DaapJobTypeService {
    @Autowired
    private DaapJobSourceService daapJobSourceService;

    @Override
    public List<DaapJobTypeEntity> getList(DaapJobTypePagination daapJobTypePagination) {
        QueryWrapper daapJobTypeQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)daapJobTypePagination.getName())) {
            daapJobTypeQueryWrapper.lambda().like(DaapJobTypeEntity::getName, (Object)daapJobTypePagination.getName());
        }
        Page page = new Page(daapJobTypePagination.getCurrentPage(), daapJobTypePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)daapJobTypeQueryWrapper);
        return daapJobTypePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<DaapJobTypeListTreeVO> getListTree(String parentId) {
        DaapJobTypeEntity info = this.getInfo(parentId);
        DaapJobTypeListTreeVO jobTypeListTreeVO = (DaapJobTypeListTreeVO)JsonUtil.getJsonToBean((Object)info, DaapJobTypeListTreeVO.class);
        jobTypeListTreeVO.setIcon("Folder");
        ArrayList<DaapJobTypeListTreeVO> listByParentId = new ArrayList<DaapJobTypeListTreeVO>();
        listByParentId.add(jobTypeListTreeVO);
        this.recursionTree(listByParentId);
        return listByParentId;
    }

    public void recursionTree(List<DaapJobTypeListTreeVO> returnList) {
        returnList.stream().forEach(item -> {
            item.setIcon("Folder");
            List<DaapJobTypeEntity> listChild = this.getListByParentId(item.getId());
            List listVO = JsonUtil.getJsonToList(listChild, DaapJobTypeListTreeVO.class);
            if (!ObjectUtil.isNotEmpty((Object)listVO)) {
                return;
            }
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    @Override
    public List<DaapJobTypeListTreeVO> getListTreeAndJobSource(String parentId) {
        DaapJobTypeEntity info = this.getInfo(parentId);
        DaapJobTypeListTreeVO jobTypeListTreeVO = (DaapJobTypeListTreeVO)JsonUtil.getJsonToBean((Object)info, DaapJobTypeListTreeVO.class);
        jobTypeListTreeVO.setIcon("Folder");
        ArrayList<DaapJobTypeListTreeVO> listByParentId = new ArrayList<DaapJobTypeListTreeVO>();
        listByParentId.add(jobTypeListTreeVO);
        this.recursionTreeAndJobSource(listByParentId);
        return listByParentId;
    }

    public void recursionTreeAndJobSource(List<DaapJobTypeListTreeVO> returnList) {
        returnList.stream().forEach(item -> {
            item.setIcon("Folder");
            ArrayList<DaapJobTypeListTreeVO> listAll = new ArrayList<DaapJobTypeListTreeVO>();
            List<DaapJobTypeEntity> listChild = this.getListByParentId(item.getId());
            List<DaapJobTypeListTreeVO> jobSourceListByTypeId = this.getJobSourceListByTypeId(item.getId());
            List listVO = JsonUtil.getJsonToList(listChild, DaapJobTypeListTreeVO.class);
            listAll.addAll(jobSourceListByTypeId);
            listAll.addAll(listVO);
            if (ObjectUtil.isNotEmpty(listAll)) {
                item.setChildren(listAll);
            }
            if (!ObjectUtil.isNotEmpty((Object)listVO)) {
                return;
            }
            this.recursionTreeAndJobSource(listVO);
        });
    }

    public List<DaapJobTypeListTreeVO> getJobSourceListByTypeId(String typeId) {
        QueryWrapper jobSourceEntityQueryWrapper = new QueryWrapper();
        jobSourceEntityQueryWrapper.lambda().eq(DaapJobSourceEntity::getTypeId, (Object)typeId);
        List jobSourceEntityList = this.daapJobSourceService.list((Wrapper)jobSourceEntityQueryWrapper);
        List jobSourcelistVO = JsonUtil.getJsonToList((Object)jobSourceEntityList, DaapJobTypeListTreeVO.class);
        jobSourcelistVO.stream().forEach(jobType -> jobType.setIcon("FlinkSQL"));
        return jobSourcelistVO;
    }

    @Override
    public List<DaapJobTypeEntity> getListByParentId(String parentId) {
        QueryWrapper basDeviceTypeQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)basDeviceTypeQueryWrapper.lambda().eq(DaapJobTypeEntity::getParentId, (Object)parentId)).eq(DaapJobTypeEntity::getEnabledMark, (Object)1);
        List list = this.list((Wrapper)basDeviceTypeQueryWrapper);
        return list;
    }

    @Override
    public DaapJobTypeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DaapJobTypeEntity::getId, (Object)id);
        return (DaapJobTypeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(DaapJobTypeEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, DaapJobTypeEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(DaapJobTypeEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

