/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.executor;

import com.bringspring.executor.EnvironmentSetting;
import com.bringspring.executor.ExecutorSetting;
import com.bringspring.executor.LocalBatchExecutor;
import com.bringspring.executor.LocalStreamExecutor;
import com.bringspring.executor.RemoteBatchExecutor;
import com.bringspring.executor.RemoteStreamExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    protected StreamExecutionEnvironment executionEnvironment;
    protected StreamTableEnvironment tableEnvironment;
    protected EnvironmentSetting environmentSetting;
    protected ExecutorSetting executorSetting;
    protected Map<String, Object> setConfig = new HashMap<String, Object>();
    protected boolean useSqlFragment = true;

    public static Executor build() {
        return new LocalStreamExecutor(ExecutorSetting.DEFAULT);
    }

    public static Executor build(EnvironmentSetting environmentSetting, ExecutorSetting executorSetting) {
        if (environmentSetting.isUseRemote()) {
            return Executor.buildRemoteExecutor(environmentSetting, executorSetting);
        }
        return Executor.buildLocalExecutor(executorSetting);
    }

    public static Executor buildLocalExecutor(ExecutorSetting executorSetting) {
        if (executorSetting.isUseBatchModel()) {
            return new LocalBatchExecutor(executorSetting);
        }
        return new LocalStreamExecutor(executorSetting);
    }

    public static Executor buildRemoteExecutor(EnvironmentSetting environmentSetting, ExecutorSetting executorSetting) {
        environmentSetting.setUseRemote(true);
        if (executorSetting.isUseBatchModel()) {
            return new RemoteBatchExecutor(environmentSetting, executorSetting);
        }
        return new RemoteStreamExecutor(environmentSetting, executorSetting);
    }

    public boolean isUseSqlFragment() {
        return this.useSqlFragment;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionEnvironment.getConfig();
    }

    public StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public ExecutorSetting getExecutorSetting() {
        return this.executorSetting;
    }

    public EnvironmentSetting getEnvironmentSetting() {
        return this.environmentSetting;
    }

    public Map<String, Object> getSetConfig() {
        return this.setConfig;
    }

    public void setSetConfig(Map<String, Object> setConfig) {
        this.setConfig = setConfig;
    }

    protected void init() {
        this.initEnvironment();
        this.initExecutionEnvironment();
    }

    public void initEnvironment() {
        if (this.executorSetting.isValidParallelism()) {
            this.executionEnvironment.setParallelism(this.executorSetting.getParallelism().intValue());
        }
        if (this.executorSetting.isValidConfig()) {
            this.executionEnvironment.getConfig().configure((ReadableConfig)Configuration.fromMap(this.executorSetting.getConfig()), null);
        }
    }

    private void initExecutionEnvironment() {
        this.useSqlFragment = this.executorSetting.isUseSqlFragment();
        this.tableEnvironment = StreamTableEnvironment.create((StreamExecutionEnvironment)this.executionEnvironment);
        Configuration configuration = this.tableEnvironment.getConfig().getConfiguration();
        if (this.executorSetting.isValidJobName()) {
            configuration.setString(PipelineOptions.NAME.key(), this.executorSetting.getJobName());
            this.setConfig.put(PipelineOptions.NAME.key(), this.executorSetting.getJobName());
        }
        if (this.executorSetting.isValidConfig()) {
            for (Map.Entry<String, String> entry : this.executorSetting.getConfig().entrySet()) {
                configuration.setString(entry.getKey(), entry.getValue());
            }
        }
    }

    public void submitSql(String statements) {
        this.tableEnvironment.executeSql(statements);
    }

    public TableResult executeStatementSet(List<String> statements) {
        StreamStatementSet statementSet = this.tableEnvironment.createStatementSet();
        for (String item : statements) {
            statementSet.addInsertSql(item);
        }
        return statementSet.execute();
    }

    public void submitStatementSet(List<String> statements) {
        this.executeStatementSet(statements);
    }
}

