/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.flink.handler.service.impl;

import com.bringspring.flink.handler.service.FlinkHandleService;
import com.bringspring.flink.handler.service.environment.FlinkEnvironmentHandle;
import com.bringspring.flink.trans.SqlType;
import com.bringspring.flink.utils.FlinkSqlUtil;
import java.util.Optional;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.springframework.stereotype.Service;

@Service
public class FlinkHandleServiceImpl
implements FlinkHandleService {
    @Override
    public String check(String jobSource) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamTableEnvironmentImpl ste = (StreamTableEnvironmentImpl)StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
        Planner planner = ste.getPlanner();
        Parser parser = ste.getPlanner().getParser();
        SqlParser sqlParser = SqlParser.create((String)jobSource, (SqlParser.Config)SqlParser.config().withParserFactory(FlinkSqlParserImpl.FACTORY).withQuoting(Quoting.BACK_TICK).withUnquotedCasing(Casing.TO_LOWER).withQuotedCasing(Casing.UNCHANGED).withConformance((SqlConformance)FlinkSqlConformance.DEFAULT));
        String errInfo = "\u9a8c\u8bc1\u6210\u529f";
        try {
            SqlNodeList sqlNodeList = sqlParser.parseStmtList();
            return sqlNodeList;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.toString());
            errInfo = "\u51fa\u73b0\u8bed\u6cd5\u9519\u8bef\uff1a" + e.toString().split(": ")[1].split("Was")[0];
            errInfo = e.toString().split(": ").length > 2 ? errInfo + " : " + e.toString().split(": ")[2] : errInfo;
            throw new Exception(errInfo);
        }
        finally {
            return errInfo;
        }
    }

    @Override
    public String submitRemote(String jobSource) {
        StreamTableEnvironment remoteEnvironment = FlinkEnvironmentHandle.createRemoteEnvironment("10.70.10.63", 8081);
        String[] statements = FlinkSqlUtil.getStatements(jobSource, ";");
        StringBuilder jobIDString = new StringBuilder();
        for (String statement : statements) {
            SqlType operationType = FlinkSqlUtil.getOperationType(statement);
            if (operationType.equals((Object)SqlType.INSERT) || operationType.equals((Object)SqlType.SELECT) || operationType.equals((Object)SqlType.SHOW) || operationType.equals((Object)SqlType.DESCRIBE) || operationType.equals((Object)SqlType.DESC)) {
                TableResult tableResult = remoteEnvironment.executeSql(statement);
                Optional jobClient = tableResult.getJobClient();
                JobID jobID = ((JobClient)jobClient.get()).getJobID();
                jobIDString.append(jobID.toString());
                continue;
            }
            remoteEnvironment.executeSql(statement);
        }
        return jobIDString.toString();
    }
}

