/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.flink.trans;

import java.util.regex.Pattern;

public enum SqlType {
    SELECT("SELECT", "^SELECT.*"),
    CREATE("CREATE", "^CREATE(?!.*AS SELECT).*$"),
    DROP("DROP", "^DROP.*"),
    ALTER("ALTER", "^ALTER.*"),
    INSERT("INSERT", "^INSERT.*"),
    DESC("DESC", "^DESC.*"),
    DESCRIBE("DESCRIBE", "^DESCRIBE.*"),
    EXPLAIN("EXPLAIN", "^EXPLAIN.*"),
    USE("USE", "^USE.*"),
    SHOW("SHOW", "^SHOW.*"),
    LOAD("LOAD", "^LOAD.*"),
    UNLOAD("UNLOAD", "^UNLOAD.*"),
    SET("SET", "^SET.*"),
    RESET("RESET", "^RESET.*"),
    EXECUTE("EXECUTE", "^EXECUTE.*"),
    ADD("ADD", "^ADD.*"),
    WATCH("WATCH", "^WATCH.*"),
    CTAS("CTAS", "^CREATE\\s.*AS\\sSELECT.*$"),
    UNKNOWN("UNKNOWN", "^UNKNOWN.*");

    private String type;
    private Pattern pattern;

    private SqlType(String type, String regrex) {
        this.type = type;
        this.pattern = Pattern.compile(regrex, 34);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean match(String statement) {
        return this.pattern.matcher(statement).matches();
    }
}

