/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.flink.utils;

import com.bringspring.common.util.StringUtil;
import com.bringspring.flink.trans.SqlType;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class FlinkSqlUtil {
    private static final String SEMICOLON = ";";

    public static String[] getStatements(String sql) {
        return FlinkSqlUtil.getStatements(sql, SEMICOLON);
    }

    public static String[] getStatements(String sql, String sqlSeparator) {
        if (StringUtil.isEmpty((String)sql)) {
            return new String[0];
        }
        String[] splits = sql.replace(";\r\n", ";\n").split(sqlSeparator);
        String lastStatement = splits[splits.length - 1].trim();
        if (lastStatement.endsWith(SEMICOLON)) {
            splits[splits.length - 1] = lastStatement.substring(0, lastStatement.length() - 1);
        }
        return splits;
    }

    public static SqlType getOperationType(String sql) {
        String sqlTrim = sql.replaceAll(sql, " ").trim().toUpperCase();
        return Arrays.stream(SqlType.values()).filter(sqlType -> sqlType.match(sqlTrim)).findFirst().orElse(SqlType.UNKNOWN);
    }

    public static String removeNote(String sql) {
        if (StringUtil.isNotEmpty((String)sql)) {
            sql = sql.replaceAll("\u00a0", " ").replaceAll("[\r\n]+", "\n");
            Pattern p = Pattern.compile("(?ms)('(?:''|[^'])*')|--.*?$|//.*?$|/\\*.*?\\*/|#.*?$|");
            String presult = p.matcher(sql).replaceAll("$1");
            return presult.trim();
        }
        return sql;
    }

    public static String replaceAllParam(String sql, String name, String value) {
        return sql.replaceAll("\\$\\{" + name + "\\}", value);
    }

    public static String replaceAllParam(String sql, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            sql = FlinkSqlUtil.replaceAllParam(sql, entry.getKey(), entry.getValue());
        }
        return sql;
    }
}

