/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceAiAlertEntity;
import com.bringspring.ecbp.entity.EcbpDeviceAiEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.model.ecbpDeviceAiAlert.EcbpDeviceAiAlertModel;
import com.bringspring.ecbp.model.ecbpDeviceAiAlert.EcbpDeviceAiAlertVo;
import com.bringspring.ecbp.service.EcbpDeviceAiAlertService;
import com.bringspring.ecbp.service.EcbpDeviceAiService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceService;
import com.bringspring.ecbp.service.EcbpRequestService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"ai\u7b97\u6cd5\u7ba1\u7406"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/aiAlert"})
public class EcbpDeviceAiAlertController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceAiAlertController.class);
    @Autowired
    private EcbpDeviceAiService ecbpDeviceAiService;
    @Autowired
    private EcbpDeviceAiAlertService ecbpDeviceAiAlertService;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    @Autowired
    private EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpRequestService ecbpRequestService;

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList(@RequestBody EcbpDeviceAiAlertModel ecbpDeviceAiAlertModel) {
        List<EcbpDeviceAiAlertEntity> list = this.ecbpDeviceAiAlertService.getList(ecbpDeviceAiAlertModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceAiAlertVo.class);
        for (EcbpDeviceAiAlertVo ecbpDeviceAiAlertVo : listVO) {
            EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(ecbpDeviceAiAlertVo.getDeviceId() + "_" + ecbpDeviceAiAlertVo.getAiId())));
            EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceAiAlertVo.getCameraId()));
            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceAiAlertVo.getDeviceId()));
            if (StringUtils.isNotNull((Object)ecbpDeviceEntity)) {
                ecbpDeviceAiAlertVo.setDeviceName(ecbpDeviceEntity.getDeviceName());
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                ecbpDeviceAiAlertVo.setAiName(ecbpDeviceAiEntity.getAiName());
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
                ecbpDeviceAiAlertVo.setCameraName(ecbpDeviceCameraEntity.getCameraName());
            }
            ecbpDeviceAiAlertVo.setChannelName("\u901a\u9053" + ecbpDeviceAiAlertVo.getChannelId());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceAiAlertModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getList"})
    public ActionResult getList(@RequestBody EcbpDeviceAiAlertModel ecbpDeviceAiAlertModel) {
        List<EcbpDeviceAiAlertEntity> list = this.ecbpDeviceAiAlertService.getList(ecbpDeviceAiAlertModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceAiAlertVo.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceAiAlertModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceAiAlertModel ecbpDeviceAiAlertModel) {
        UserInfo userInfo = this.userProvider.get();
        if (ecbpDeviceAiAlertModel != null) {
            EcbpDeviceAiAlertEntity entity = (EcbpDeviceAiAlertEntity)this.ecbpDeviceAiAlertService.getById((Serializable)((Object)ecbpDeviceAiAlertModel.getId()));
            entity.setEnabledMark(Integer.parseInt(ecbpDeviceAiAlertModel.getEnabledMark()));
            entity.setLastModifyUserId(userInfo.getUserId());
            this.ecbpDeviceAiAlertService.updateById(entity);
            this.ecbpRequestService.pushAlertInfoToTwin(entity, 2);
            return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

