/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.ecbp.entity.EcbpDeviceBusinessEntity;
import com.bringspring.ecbp.model.ecbpDeviceBusiness.EcbpDeviceBusinessVo;
import com.bringspring.ecbp.service.EcbpDeviceBusinessService;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u4e1a\u52a1\u573a\u666f\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/business"})
public class EcbpDeviceBusinessController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceBusinessController.class);
    @Autowired
    private EcbpDeviceBusinessService ecbpDeviceBusinessService;

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String deviceId = jsonObject.getString("deviceId");
        List<EcbpDeviceBusinessEntity> list = this.ecbpDeviceBusinessService.getListByDeviceId(deviceId);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceBusinessVo.class);
        return ActionResult.success((Object)listVO);
    }
}

