/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCameraGroupEntity;
import com.bringspring.ecbp.entity.EcbpDeviceChannelEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCmdForceEntity;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.model.ecbpDeviceCamera.EcbpDeviceCameraInfoVo;
import com.bringspring.ecbp.model.ecbpDeviceCamera.EcbpDeviceCameraModel;
import com.bringspring.ecbp.model.ecbpDeviceCamera.EcbpDeviceCameraVo;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupInfoVo;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupModel;
import com.bringspring.ecbp.model.ecbpDeviceCmdForce.EcbpDeviceCmdForceModel;
import com.bringspring.ecbp.service.EcbpDeviceCameraGroupService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceChannelService;
import com.bringspring.ecbp.service.EcbpDeviceCmdForceService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpDeviceService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u6444\u50cf\u5934\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/camera"})
public class EcbpDeviceCameraController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceCameraController.class);
    @Autowired
    private EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    private EcbpDeviceCameraGroupService ecbpDeviceCameraGroupService;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    @Autowired
    private EcbpDeviceChannelService ecbpDeviceChannelService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdForceService ecbpDeviceCmdForceService;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        List<EcbpDeviceCameraEntity> list = this.ecbpDeviceCameraService.getList(ecbpDeviceCameraModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceCameraVo.class);
        List ecbpDeviceCameraGroupEntityList = this.ecbpDeviceCameraGroupService.list();
        for (EcbpDeviceCameraVo ecbpDeviceCameraVo : listVO) {
            if (10 == ecbpDeviceCameraVo.getEnabledMark()) {
                ecbpDeviceCameraVo.setEnabledMarkStr("\u5728\u7ebf");
            } else {
                ecbpDeviceCameraVo.setEnabledMarkStr("\u79bb\u7ebf");
            }
            for (EcbpDeviceCameraGroupEntity entity : ecbpDeviceCameraGroupEntityList) {
                if (!entity.getId().equals(ecbpDeviceCameraVo.getGroupId())) continue;
                ecbpDeviceCameraVo.setGroupName(entity.getGroupName());
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getCameraListByDeviceId"})
    public ActionResult getCameraListByDeviceId(@RequestBody EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        List<EcbpDeviceCameraEntity> cameraList = this.ecbpDeviceCameraService.getChannelCameraList(ecbpDeviceCameraModel);
        List listVO = JsonUtil.getJsonToList(cameraList, EcbpDeviceCameraVo.class);
        List ecbpDeviceCameraGroupEntityList = this.ecbpDeviceCameraGroupService.list();
        for (EcbpDeviceCameraVo ecbpDeviceCameraVo : listVO) {
            if (10 == ecbpDeviceCameraVo.getEnabledMark()) {
                ecbpDeviceCameraVo.setEnabledMarkStr("\u5728\u7ebf");
            } else {
                ecbpDeviceCameraVo.setEnabledMarkStr("\u79bb\u7ebf");
            }
            for (EcbpDeviceCameraGroupEntity entity : ecbpDeviceCameraGroupEntityList) {
                if (!entity.getId().equals(ecbpDeviceCameraVo.getGroupId())) continue;
                ecbpDeviceCameraVo.setGroupName(entity.getGroupName());
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getChannelCameraList"})
    public ActionResult getChannelCameraList(@RequestBody EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        List<EcbpDeviceCameraEntity> cameraList = this.ecbpDeviceCameraService.getChannelCameraList(ecbpDeviceCameraModel);
        EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceCameraModel.getDeviceId()));
        EcbpDeviceChannelEntity ecbpDeviceChannelEntity = (EcbpDeviceChannelEntity)this.ecbpDeviceChannelService.getById((Serializable)((Object)ecbpDeviceCameraModel.getChannelId()));
        List listVO = JsonUtil.getJsonToList(cameraList, EcbpDeviceCameraVo.class);
        for (EcbpDeviceCameraVo ecbpDeviceCameraVo : listVO) {
            ecbpDeviceCameraVo.setDeviceId(ecbpDeviceCameraModel.getDeviceId());
            ecbpDeviceCameraVo.setChannelId(ecbpDeviceCameraModel.getChannelId());
            ecbpDeviceCameraVo.setDeviceName(ecbpDeviceEntity.getDeviceName());
            ecbpDeviceCameraVo.setChannelName(ecbpDeviceChannelEntity.getChannelName());
            EcbpDeviceCmdForceModel ecbpDeviceCmdForceModel = new EcbpDeviceCmdForceModel();
            ecbpDeviceCmdForceModel.setDeviceId(ecbpDeviceCameraModel.getDeviceId());
            ecbpDeviceCmdForceModel.setChannelId(ecbpDeviceCameraModel.getChannelId());
            ecbpDeviceCmdForceModel.setCameraId(ecbpDeviceCameraVo.getCameraId());
            EcbpDeviceCmdForceEntity ecbpDeviceCmdForceEntity = this.ecbpDeviceCmdForceService.getByDeviceIdOrChannelIdOrCameraId(ecbpDeviceCmdForceModel);
            if (StringUtils.isNotNull((Object)ecbpDeviceCmdForceEntity)) {
                ecbpDeviceCameraVo.setEnabledMarkStr("\u542f\u7528");
                continue;
            }
            ecbpDeviceCameraVo.setEnabledMarkStr("\u672a\u542f\u7528");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getGroupList"})
    public ActionResult getGroupList() {
        List<EcbpDeviceCameraEntity> list = this.ecbpDeviceCameraService.getGroupList();
        ArrayList resultListVo = new ArrayList();
        HashMap<String, Object> resultMapVo = new HashMap<String, Object>();
        resultMapVo.put("groupName", "\u5168\u90e8");
        resultMapVo.put("children", list);
        resultListVo.add(resultMapVo);
        return ActionResult.success(resultListVo);
    }

    @PostMapping(value={"/getTreeDataList"})
    public ActionResult getTreeDataList(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String deviceId = jsonObject.getString("deviceId");
        List groupList = this.ecbpDeviceCameraGroupService.list();
        ArrayList<EcbpDeviceCameraGroupEntity> deviceCameraGroupEntityList = new ArrayList<EcbpDeviceCameraGroupEntity>();
        for (EcbpDeviceCameraGroupEntity entity : groupList) {
            if (!entity.getDeviceIds().contains(deviceId)) continue;
            entity.setDeviceIds(deviceId);
            deviceCameraGroupEntityList.add(entity);
        }
        List ls = JsonUtil.getJsonToList(deviceCameraGroupEntityList, EcbpDeviceCameraGroupInfoVo.class);
        List<EcbpDeviceCameraGroupInfoVo> parentGroup = this.buildTree(ls, deviceId + "_0");
        return ActionResult.success((Object)JSONArray.parseArray((String)JSONObject.toJSONString(parentGroup)));
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList() {
        List list = this.ecbpDeviceCameraService.list();
        List listVO = JsonUtil.getJsonToList((Object)list, EcbpDeviceCameraVo.class);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceCameraEntity entity = (EcbpDeviceCameraEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraModel), EcbpDeviceCameraEntity.class);
        entity.setId(mainId);
        entity.setCameraId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecbpDeviceCameraService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceCameraModel.getId()));
        if (ecbpDeviceCameraEntity != null) {
            EcbpDeviceCameraEntity entity = (EcbpDeviceCameraEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraModel), EcbpDeviceCameraEntity.class);
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setGroupId(ecbpDeviceCameraEntity.getGroupId());
            this.ecbpDeviceCameraService.updateById(entity);
            this.ecbpDeviceCmdService.saveOrUpdateCmdCameraByDeviceId(ecbpDeviceCameraModel);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdUpdate"})
    @DSTransactional
    public ActionResult cmdUpdate(@RequestBody @Valid EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        if (ecbpDeviceCameraModel != null) {
            this.ecbpDeviceCmdService.saveOrUpdateCmdCameraByDeviceId(ecbpDeviceCameraModel);
            return ActionResult.success((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u6444\u50cf\u5934\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u6444\u50cf\u5934\u6307\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdGetCameraInfo"})
    @DSTransactional
    public ActionResult cmdGetCameraInfo(@RequestBody @Valid EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        if (ecbpDeviceCameraModel != null) {
            this.ecbpDeviceCmdService.cmdGetCameraInfo(ecbpDeviceCameraModel);
            return ActionResult.success((String)"\u4e0b\u53d1\u83b7\u53d6\u7ec8\u7aef\u6444\u50cf\u5934\u4fe1\u606f\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0b\u53d1\u83b7\u53d6\u7ec8\u7aef\u6444\u50cf\u5934\u4fe1\u606f\u6307\u4ee4\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpDeviceCameraVo> info(@PathVariable(value="id") String id) {
        EcbpDeviceCameraEntity entity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)id));
        EcbpDeviceCameraVo vo = (EcbpDeviceCameraVo)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceCameraVo.class);
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/cameraRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.ecbpDeviceCameraService.removeById((Serializable)((Object)id));
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/delCameraInfoByGroupName/{groupName}"})
    @Transactional
    public ActionResult delCameraInfoByGroupName(@PathVariable(value="groupName") String groupName) {
        this.ecbpDeviceCameraService.delCameraInfoByGroupName(groupName);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/updateCameraInfoByGroupName"})
    @Transactional
    public ActionResult updateCameraInfoByGroupName(@RequestBody @Valid EcbpDeviceCameraGroupModel ecbpDeviceCameraGroupModel) {
        this.ecbpDeviceCameraService.updateCameraInfoByGroupName(ecbpDeviceCameraGroupModel);
        return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
    }

    public List<EcbpDeviceCameraGroupInfoVo> buildTree(List<EcbpDeviceCameraGroupInfoVo> allGroups, String parentId) {
        ArrayList<EcbpDeviceCameraGroupInfoVo> groupList = new ArrayList<EcbpDeviceCameraGroupInfoVo>();
        for (EcbpDeviceCameraGroupInfoVo group : allGroups) {
            if (!group.getParentId().equals(parentId)) continue;
            EcbpDeviceCameraGroupInfoVo parentNode = new EcbpDeviceCameraGroupInfoVo();
            parentNode.setChildren(new ArrayList<Object>());
            List<EcbpDeviceCameraGroupInfoVo> childNode = this.buildTree(allGroups, group.getId());
            parentNode.setId(group.getId());
            parentNode.setParentId(group.getParentId());
            parentNode.setCameraName(group.getGroupName());
            if (childNode.size() > 0) {
                parentNode.getChildren().add(childNode.get(0));
            }
            List<EcbpDeviceCameraEntity> listByGroupId = this.ecbpDeviceCameraService.getListByGroupId(parentNode.getId());
            List cameraList = JsonUtil.getJsonToList(listByGroupId, EcbpDeviceCameraInfoVo.class);
            for (EcbpDeviceCameraInfoVo camera : cameraList) {
                parentNode.getChildren().add(camera);
            }
            groupList.add(parentNode);
        }
        return groupList;
    }
}

