/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceCameraGroupEntity;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupInfoVo;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupModel;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupVo;
import com.bringspring.ecbp.service.EcbpDeviceCameraGroupService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u6444\u50cf\u5934\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/camera/group"})
public class EcbpDeviceCameraGroupController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceCameraGroupController.class);
    @Autowired
    EcbpDeviceCameraGroupService ecbpDeviceCameraGroupService;
    @Autowired
    EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList() {
        ArrayList resultListVo = new ArrayList();
        HashMap<String, Object> resultMapVo = new HashMap<String, Object>();
        List list = this.ecbpDeviceCameraGroupService.list();
        List listVO = JsonUtil.getJsonToList((Object)list, EcbpDeviceCameraGroupVo.class);
        resultMapVo.put("groupName", "\u5168\u90e8");
        resultMapVo.put("children", listVO);
        resultListVo.add(resultMapVo);
        return ActionResult.success(resultListVo);
    }

    @PostMapping(value={"/getRecursionList"})
    public ActionResult getRecursionList(@RequestBody String json) {
        ArrayList resultListVo = new ArrayList();
        HashMap<String, Object> resultMapVo = new HashMap<String, Object>();
        List list = this.ecbpDeviceCameraGroupService.list();
        ArrayList<EcbpDeviceCameraGroupEntity> deviceCameraGroupEntityList = new ArrayList<EcbpDeviceCameraGroupEntity>();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String deviceId = jsonObject.getString("deviceId");
        if (StringUtils.isEmpty((String)deviceId)) {
            return ActionResult.success(resultListVo);
        }
        for (EcbpDeviceCameraGroupEntity entity : list) {
            if (!entity.getDeviceIds().contains(deviceId)) continue;
            entity.setDeviceIds(deviceId);
            deviceCameraGroupEntityList.add(entity);
        }
        List ls = JsonUtil.getJsonToList(deviceCameraGroupEntityList, EcbpDeviceCameraGroupInfoVo.class);
        List<EcbpDeviceCameraGroupInfoVo> parentGroup = this.buildTree(ls, deviceId + "_0", "\u5168\u90e8");
        if (parentGroup.size() > 0) {
            resultMapVo.put("id", deviceId + "_0");
            resultMapVo.put("groupName", "\u5168\u90e8");
            resultMapVo.put("children", parentGroup);
            resultListVo.add(resultMapVo);
        }
        return ActionResult.success(resultListVo);
    }

    public List<EcbpDeviceCameraGroupInfoVo> buildTree(List<EcbpDeviceCameraGroupInfoVo> allGroups, String parentId, String parentName) {
        ArrayList<EcbpDeviceCameraGroupInfoVo> groupList = new ArrayList<EcbpDeviceCameraGroupInfoVo>();
        for (EcbpDeviceCameraGroupInfoVo group : allGroups) {
            if (!group.getParentId().equals(parentId)) continue;
            EcbpDeviceCameraGroupInfoVo parentNode = new EcbpDeviceCameraGroupInfoVo();
            parentNode.setChildren(new ArrayList<Object>());
            List<EcbpDeviceCameraGroupInfoVo> childNode = this.buildTree(allGroups, group.getId(), group.getGroupName());
            parentNode.setId(group.getId());
            parentNode.setParentId(group.getParentId());
            parentNode.setParentName(parentName);
            parentNode.setDeviceIds(group.getDeviceIds());
            parentNode.setGroupName(group.getGroupName());
            if (childNode.size() > 0) {
                parentNode.getChildren().add(childNode.get(0));
            }
            groupList.add(parentNode);
        }
        return groupList;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceCameraGroupModel ecbpDeviceCameraGroupModel) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceCameraGroupEntity entity = (EcbpDeviceCameraGroupEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraGroupModel), EcbpDeviceCameraGroupEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecbpDeviceCameraGroupService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceCameraGroupModel ecbpDeviceCameraGroupModel) {
        UserInfo userInfo = this.userProvider.get();
        if (ecbpDeviceCameraGroupModel != null) {
            EcbpDeviceCameraGroupEntity entity = (EcbpDeviceCameraGroupEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCameraGroupModel), EcbpDeviceCameraGroupEntity.class);
            entity.setLastModifyUserId(userInfo.getUserId());
            this.ecbpDeviceCameraGroupService.updateById(entity);
            this.ecbpDeviceCmdService.saveOrUpdateCmdCameraGroupByDeviceId(ecbpDeviceCameraGroupModel);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdGetCameraGroupInfo"})
    @DSTransactional
    public ActionResult cmdGetCameraGroupInfo(@RequestBody @Valid EcbpDeviceCameraGroupModel ecbpDeviceCameraGroupModel) {
        if (ecbpDeviceCameraGroupModel != null) {
            this.ecbpDeviceCmdService.cmdGetCameraGroupInfo(ecbpDeviceCameraGroupModel);
            return ActionResult.success((String)"\u4e0b\u53d1\u83b7\u53d6\u7ec8\u7aef\u6444\u50cf\u5934\u5206\u7ec4\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0b\u53d1\u83b7\u53d6\u7ec8\u7aef\u6444\u50cf\u5934\u5206\u7ec4\u6307\u4ee4\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
    }

    @DeleteMapping(value={"/cameraRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.ecbpDeviceCameraGroupService.removeById((Serializable)((Object)id));
        this.ecbpDeviceCameraService.removeByGroupId(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

