/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceChannelEntity;
import com.bringspring.ecbp.model.ecbpDeviceChannel.EcbpDeviceChannelModel;
import com.bringspring.ecbp.model.ecbpDeviceChannel.EcbpDeviceChannelVo;
import com.bringspring.ecbp.model.ecbpDeviceStrategy.EcbpDeviceStrategyCrModel;
import com.bringspring.ecbp.service.EcbpDeviceChannelService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u8bbe\u5907\u901a\u9053\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/channel"})
public class EcbpDeviceChannelController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceChannelController.class);
    @Autowired
    private EcbpDeviceChannelService ecbpDeviceChannelService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceChannelModel ecbpDeviceChannelModel) {
        List<EcbpDeviceChannelEntity> list = this.ecbpDeviceChannelService.getList(ecbpDeviceChannelModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceChannelVo.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceChannelModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList() {
        List list = this.ecbpDeviceChannelService.list();
        List listVO = JsonUtil.getJsonToList((Object)list, EcbpDeviceChannelVo.class);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceChannelModel ecbpDeviceChannelModel) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceChannelEntity entity = (EcbpDeviceChannelEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceChannelModel), EcbpDeviceChannelEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecbpDeviceChannelService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceChannelModel ecbpDeviceChannelModel) {
        UserInfo userInfo = this.userProvider.get();
        if (ecbpDeviceChannelModel != null) {
            EcbpDeviceChannelEntity entity = (EcbpDeviceChannelEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceChannelModel), EcbpDeviceChannelEntity.class);
            entity.setLastModifyUserId(userInfo.getUserId());
            this.ecbpDeviceChannelService.updateById(entity);
            EcbpDeviceStrategyCrModel ecbpDeviceStrategyCrModel = new EcbpDeviceStrategyCrModel();
            ecbpDeviceStrategyCrModel.setChannelId(ecbpDeviceChannelModel.getId());
            this.ecbpDeviceCmdService.saveOrUpdateCmdStrategyByDeviceId(ecbpDeviceStrategyCrModel);
            return ActionResult.success((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u901a\u9053\u4fe1\u606f\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u901a\u9053\u4fe1\u606f\u6307\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdGetChannelInfo"})
    @DSTransactional
    public ActionResult cmdGetChannelInfo(@RequestBody @Valid EcbpDeviceChannelModel ecbpDeviceChannelModel) {
        if (ecbpDeviceChannelModel != null) {
            this.ecbpDeviceCmdService.cmdGetChannelInfo(ecbpDeviceChannelModel);
            return ActionResult.success((String)"\u4e0b\u53d1\u83b7\u53d6\u901a\u9053\u4fe1\u606f\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0b\u53d1\u83b7\u53d6\u901a\u9053\u4fe1\u606f\u6307\u4ee4\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpDeviceChannelVo> info(@PathVariable(value="id") String id) {
        EcbpDeviceChannelEntity entity = (EcbpDeviceChannelEntity)this.ecbpDeviceChannelService.getById((Serializable)((Object)id));
        EcbpDeviceChannelVo vo = (EcbpDeviceChannelVo)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceChannelVo.class);
        return ActionResult.success((Object)vo);
    }
}

