/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecbp.entity.EcbpDeviceAiAlertEntity;
import com.bringspring.ecbp.entity.EcbpDeviceAiEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceChannelStateEntity;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.model.ecbpDeviceAiAlert.EcbpDeviceAiAlertModel;
import com.bringspring.ecbp.model.ecbpDeviceChannelState.EcbpDeviceChannelStateModel;
import com.bringspring.ecbp.model.ecbpDeviceChannelState.EcbpDeviceChannelStateVo;
import com.bringspring.ecbp.service.EcbpDeviceAiAlertService;
import com.bringspring.ecbp.service.EcbpDeviceAiService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceChannelStateService;
import com.bringspring.ecbp.service.EcbpDeviceService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u8bbe\u5907\u901a\u9053\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/channelState"})
public class EcbpDeviceChannelStateController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceChannelStateController.class);
    @Autowired
    private EcbpDeviceChannelStateService ecbpDeviceChannelStateService;
    @Autowired
    private EcbpDeviceAiService ecbpDeviceAiService;
    @Autowired
    private EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    @Autowired
    private EcbpDeviceAiAlertService ecbpDeviceAiAlertService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceChannelStateModel ecbpDeviceChannelStateModel) {
        List<EcbpDeviceChannelStateEntity> list = this.ecbpDeviceChannelStateService.getList(ecbpDeviceChannelStateModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceChannelStateVo.class);
        for (EcbpDeviceChannelStateVo deviceChannelStateVo : listVO) {
            EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(deviceChannelStateVo.getDeviceId() + "_" + deviceChannelStateVo.getAiId())));
            EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)deviceChannelStateVo.getCameraId()));
            if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                deviceChannelStateVo.setAiName(ecbpDeviceAiEntity.getAiName());
            } else {
                deviceChannelStateVo.setAiName("\u672a\u914d\u7f6e\u7b97\u6cd5");
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
                deviceChannelStateVo.setCameraName(ecbpDeviceCameraEntity.getCameraName());
                continue;
            }
            deviceChannelStateVo.setCameraName("\u672a\u914d\u7f6e\u6444\u50cf\u5934");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceChannelStateModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList(@RequestBody EcbpDeviceChannelStateModel ecbpDeviceChannelStateModel) {
        List<EcbpDeviceChannelStateEntity> list = this.ecbpDeviceChannelStateService.getList(ecbpDeviceChannelStateModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceChannelStateVo.class);
        for (EcbpDeviceChannelStateVo deviceChannelStateVo : listVO) {
            EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(deviceChannelStateVo.getDeviceId() + "_" + deviceChannelStateVo.getAiId())));
            EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)deviceChannelStateVo.getCameraId()));
            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)deviceChannelStateVo.getDeviceId()));
            EcbpDeviceAiAlertModel ecbpDeviceAiAlertModel = new EcbpDeviceAiAlertModel();
            ecbpDeviceAiAlertModel.setDeviceId(deviceChannelStateVo.getDeviceId());
            ecbpDeviceAiAlertModel.setChannelId(deviceChannelStateVo.getChannelId());
            ecbpDeviceAiAlertModel.setAiId(deviceChannelStateVo.getAiId());
            ecbpDeviceAiAlertModel.setCameraId(deviceChannelStateVo.getCameraId());
            ecbpDeviceAiAlertModel.setEnabledMark("10");
            EcbpDeviceAiAlertEntity alertEntity = this.ecbpDeviceAiAlertService.getLastList(ecbpDeviceAiAlertModel);
            if (StringUtils.isNotNull((Object)alertEntity)) {
                deviceChannelStateVo.setFiles(alertEntity.getFiles());
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                deviceChannelStateVo.setAiName(ecbpDeviceAiEntity.getAiName());
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
                deviceChannelStateVo.setCameraName(ecbpDeviceCameraEntity.getCameraName());
            }
            if (StringUtils.isNotNull((Object)ecbpDeviceEntity)) {
                deviceChannelStateVo.setDeviceName(ecbpDeviceEntity.getDeviceName());
            }
            deviceChannelStateVo.setChannelName("\u901a\u9053" + deviceChannelStateVo.getChannelId());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceChannelStateModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

