/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceCmdEntity;
import com.bringspring.ecbp.model.ecbpDeviceCmd.EcbpDeviceCmdModel;
import com.bringspring.ecbp.model.ecbpDeviceCmd.EcbpDeviceCmdVo;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u8bf7\u6c42"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/EcbpDeviceCmd"})
public class EcbpDeviceCmdController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceCmdController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceCmdModel ecbpDeviceCmdModel) throws IOException {
        List<EcbpDeviceCmdEntity> list = this.ecbpDeviceCmdService.getList(ecbpDeviceCmdModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceCmdVo.class);
        for (EcbpDeviceCmdVo ecbpDeviceCmdVo : listVO) {
            if (10 == ecbpDeviceCmdVo.getEnabledMark()) {
                ecbpDeviceCmdVo.setEnabledMarkStr("\u5f85\u4e0b\u53d1");
                continue;
            }
            if (80 == ecbpDeviceCmdVo.getEnabledMark()) {
                ecbpDeviceCmdVo.setEnabledMarkStr("\u5df2\u4e0b\u53d1");
                continue;
            }
            if (90 != ecbpDeviceCmdVo.getEnabledMark()) continue;
            ecbpDeviceCmdVo.setEnabledMarkStr("\u5df2\u6267\u884c");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceCmdModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcbpDeviceCmdVo> detailInfo(@PathVariable(value="id") String id) {
        EcbpDeviceCmdEntity entity = this.ecbpDeviceCmdService.getInfo(id);
        EcbpDeviceCmdVo vo = (EcbpDeviceCmdVo)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceCmdVo.class);
        return ActionResult.success((Object)vo);
    }
}

