/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.model.ecbpDevice.EcbpDeviceModel;
import com.bringspring.ecbp.model.ecbpDevice.EcbpDeviceVo;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpDeviceService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u8bbe\u5907\u4fe1\u606f"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device"})
public class EcbpDeviceController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceController.class);
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceModel ecbpDeviceModel) {
        List<EcbpDeviceEntity> list = this.ecbpDeviceService.getList(ecbpDeviceModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceVo.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAllList"})
    public ActionResult getAllList() {
        List list = this.ecbpDeviceService.list();
        List listVO = JsonUtil.getJsonToList((Object)list, EcbpDeviceVo.class);
        ArrayList resultListVo = new ArrayList();
        HashMap<String, Object> resultMapVo = new HashMap<String, Object>();
        HashMap<String, Object> onLineResultMapVo = new HashMap<String, Object>();
        HashMap<String, Object> offLineResultMapVo = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> deviceListVo = new ArrayList<HashMap<String, Object>>();
        ArrayList<EcbpDeviceVo> onLineListVo = new ArrayList<EcbpDeviceVo>();
        ArrayList<EcbpDeviceVo> offLineListVo = new ArrayList<EcbpDeviceVo>();
        for (EcbpDeviceVo ecbpDeviceVo : listVO) {
            if (ecbpDeviceVo.getEnabledMark() != null && 10 == ecbpDeviceVo.getEnabledMark()) {
                onLineListVo.add(ecbpDeviceVo);
                continue;
            }
            offLineListVo.add(ecbpDeviceVo);
        }
        onLineResultMapVo.put("deviceName", "\u5728\u7ebf\uff08" + onLineListVo.size() + ")");
        onLineResultMapVo.put("id", "1");
        onLineResultMapVo.put("children", onLineListVo);
        offLineResultMapVo.put("deviceName", "\u79bb\u7ebf\uff08" + offLineListVo.size() + ")");
        offLineResultMapVo.put("id", "2");
        offLineResultMapVo.put("children", offLineListVo);
        deviceListVo.add(onLineResultMapVo);
        deviceListVo.add(offLineResultMapVo);
        resultMapVo.put("deviceName", "\u4e3b\u673a\u4fe1\u606f\uff08" + listVO.size() + ")");
        resultMapVo.put("id", "0");
        resultMapVo.put("children", deviceListVo);
        resultListVo.add(resultMapVo);
        return ActionResult.success(resultListVo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceModel ecbpDeviceModel) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceEntity entity = (EcbpDeviceEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceModel), EcbpDeviceEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecbpDeviceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceModel ecbpDeviceModel) {
        UserInfo userInfo = this.userProvider.get();
        if (ecbpDeviceModel != null) {
            EcbpDeviceEntity entity = (EcbpDeviceEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceModel), EcbpDeviceEntity.class);
            entity.setLastModifyUserId(userInfo.getUserId());
            this.ecbpDeviceService.updateById(entity);
            this.ecbpDeviceCmdService.saveOrUpdateCmdDeviceByDeviceId(ecbpDeviceModel);
            return ActionResult.success((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u8bbe\u5907\u57fa\u672c\u4fe1\u606f\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u8bbe\u5907\u57fa\u672c\u4fe1\u606f\u6307\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdGetDeviceInfo"})
    @DSTransactional
    public ActionResult cmdGetDeviceInfo(@RequestBody @Valid EcbpDeviceModel ecbpDeviceModel) {
        if (ecbpDeviceModel != null) {
            this.ecbpDeviceCmdService.cmdGetDeviceInfo(ecbpDeviceModel);
            return ActionResult.success((String)"\u4e0b\u53d1\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0b\u53d1\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u6307\u4ee4\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpDeviceVo> info(@PathVariable(value="id") String id) {
        EcbpDeviceEntity entity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)id));
        EcbpDeviceVo vo = (EcbpDeviceVo)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceVo.class);
        return ActionResult.success((Object)vo);
    }
}

