/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceAiAlertEntity;
import com.bringspring.ecbp.entity.EcbpDeviceSmartSceneEntity;
import com.bringspring.ecbp.entity.EcbpDeviceSmartSceneItemEntity;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartSceneCrForm;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartSceneInfoVO;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartSceneListVO;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartScenePagination;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartSceneUpForm;
import com.bringspring.ecbp.model.ecbp_device_smart_scene.EcbpDeviceSmartSceneItemListVO;
import com.bringspring.ecbp.model.ecbp_device_smart_scene.EcbpDeviceSmartSceneItemModel;
import com.bringspring.ecbp.service.EcbpDeviceAiAlertService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpDeviceSmartSceneItemService;
import com.bringspring.ecbp.service.EcbpDeviceSmartSceneService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u667a\u80fd\u573a\u666f\u76d1\u63a7\u7b56\u7565"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/EcbpDeviceSmartScene"})
public class EcbpDeviceSmartSceneController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceSmartSceneController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceSmartSceneService ecbpDeviceSmartSceneService;
    @Autowired
    private EcbpDeviceSmartSceneItemService ecbpDeviceSmartSceneItemService;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;
    @Autowired
    private EcbpDeviceAiAlertService ecbpDeviceAiAlertService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceSmartScenePagination ecbpDeviceSmartScenePagination) throws IOException {
        List<EcbpDeviceSmartSceneEntity> list = this.ecbpDeviceSmartSceneService.getList(ecbpDeviceSmartScenePagination);
        for (EcbpDeviceSmartSceneEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceSmartSceneListVO.class);
        for (EcbpDeviceSmartSceneListVO ecbpDeviceSmartSceneVO : listVO) {
            ecbpDeviceSmartSceneVO.setCreatorTimeStr(DateUtil.daFormat((Long)Long.parseLong(ecbpDeviceSmartSceneVO.getCreatorTime())));
            List<EcbpDeviceSmartSceneItemEntity> ecbpDeviceSmartSceneItemEntityList = this.ecbpDeviceSmartSceneService.getEcbpDeviceSmartSceneItem(ecbpDeviceSmartSceneVO.getId());
            if (!ObjectUtil.isNotEmpty(ecbpDeviceSmartSceneItemEntityList)) continue;
            ecbpDeviceSmartSceneVO.setEcbp_device_smart_scene_item(JsonUtil.getJsonToList(ecbpDeviceSmartSceneItemEntityList, EcbpDeviceSmartSceneItemListVO.class));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceSmartScenePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceSmartSceneCrForm ecbpDeviceSmartSceneCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceSmartSceneEntity entity = (EcbpDeviceSmartSceneEntity)JsonUtil.getJsonToBean((Object)ecbpDeviceSmartSceneCrForm, EcbpDeviceSmartSceneEntity.class);
        entity.setId(mainId);
        entity.setEnabledMark(90);
        this.ecbpDeviceSmartSceneService.save(entity);
        List<EcbpDeviceSmartSceneItemModel> sceneItemModelList = ecbpDeviceSmartSceneCrForm.getEcbp_device_smart_scene_item();
        if (sceneItemModelList.size() > 0) {
            for (EcbpDeviceSmartSceneItemModel smartSceneItemModel : sceneItemModelList) {
                EcbpDeviceSmartSceneItemEntity ecbpDeviceSmartSceneItemEntity = (EcbpDeviceSmartSceneItemEntity)JsonUtil.getJsonToBean((Object)smartSceneItemModel, EcbpDeviceSmartSceneItemEntity.class);
                ecbpDeviceSmartSceneItemEntity.setSmartSceneId(entity.getId());
                ecbpDeviceSmartSceneItemEntity.setId(RandomUtil.uuId());
                this.ecbpDeviceSmartSceneItemService.save(ecbpDeviceSmartSceneItemEntity);
            }
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpDeviceSmartSceneInfoVO> info(@PathVariable(value="id") String id) {
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        EcbpDeviceSmartSceneInfoVO vo = (EcbpDeviceSmartSceneInfoVO)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceSmartSceneInfoVO.class);
        QueryWrapper queryWrapperEcbpDeviceSmartSceneItem = new QueryWrapper();
        queryWrapperEcbpDeviceSmartSceneItem.lambda().eq(EcbpDeviceSmartSceneItemEntity::getSmartSceneId, (Object)entity.getId());
        List ecbpDeviceSmartSceneItemEntityList = this.ecbpDeviceSmartSceneItemService.list((Wrapper)queryWrapperEcbpDeviceSmartSceneItem);
        vo.setEcbp_device_smart_scene_item(JsonUtil.getJsonToList((Object)ecbpDeviceSmartSceneItemEntityList, EcbpDeviceSmartSceneItemModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcbpDeviceSmartSceneInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        EcbpDeviceSmartSceneInfoVO vo = (EcbpDeviceSmartSceneInfoVO)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceSmartSceneInfoVO.class);
        QueryWrapper queryWrapperEcbpDeviceSmartSceneItem = new QueryWrapper();
        queryWrapperEcbpDeviceSmartSceneItem.lambda().eq(EcbpDeviceSmartSceneItemEntity::getSmartSceneId, (Object)entity.getId());
        ArrayList ecbpDeviceSmartSceneItemEntityList = this.ecbpDeviceSmartSceneItemService.list((Wrapper)queryWrapperEcbpDeviceSmartSceneItem);
        if (ObjectUtil.isEmpty((Object)ecbpDeviceSmartSceneItemEntityList)) {
            ecbpDeviceSmartSceneItemEntityList = new ArrayList();
        }
        vo.setEcbp_device_smart_scene_item(JsonUtil.getJsonToList(ecbpDeviceSmartSceneItemEntityList, EcbpDeviceSmartSceneItemModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcbpDeviceSmartSceneUpForm ecbpDeviceSmartSceneUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        if (entity != null) {
            EcbpDeviceSmartSceneEntity subentity = (EcbpDeviceSmartSceneEntity)JsonUtil.getJsonToBean((Object)ecbpDeviceSmartSceneUpForm, EcbpDeviceSmartSceneEntity.class);
            this.ecbpDeviceSmartSceneService.update(id, subentity);
            List<EcbpDeviceSmartSceneItemModel> sceneItemModelList = ecbpDeviceSmartSceneUpForm.getEcbp_device_smart_scene_item();
            this.ecbpDeviceSmartSceneItemService.delBySmartSceneId(id);
            if (sceneItemModelList.size() > 0) {
                for (EcbpDeviceSmartSceneItemModel smartSceneItemModel : sceneItemModelList) {
                    EcbpDeviceSmartSceneItemEntity ecbpDeviceSmartSceneItemEntity = (EcbpDeviceSmartSceneItemEntity)JsonUtil.getJsonToBean((Object)smartSceneItemModel, EcbpDeviceSmartSceneItemEntity.class);
                    ecbpDeviceSmartSceneItemEntity.setSmartSceneId(entity.getId());
                    ecbpDeviceSmartSceneItemEntity.setId(RandomUtil.uuId());
                    this.ecbpDeviceSmartSceneItemService.save(ecbpDeviceSmartSceneItemEntity);
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        if (entity != null) {
            this.ecbpDeviceSmartSceneService.delete(entity);
            QueryWrapper queryWrapperEcbpDeviceSmartSceneItem = new QueryWrapper();
            queryWrapperEcbpDeviceSmartSceneItem.lambda().eq(EcbpDeviceSmartSceneItemEntity::getSmartSceneId, (Object)entity.getId());
            this.ecbpDeviceSmartSceneItemService.remove((Wrapper)queryWrapperEcbpDeviceSmartSceneItem);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/startAiStrategy/{id}"})
    @DSTransactional
    public ActionResult startAiStrategy(@PathVariable(value="id") String id, @RequestBody String json) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        if (entity != null) {
            EcbpDeviceSmartSceneEntity subentity = new EcbpDeviceSmartSceneEntity();
            subentity.setEnabledMark(10);
            this.ecbpDeviceSmartSceneService.update(id, subentity);
            this.ecbpDeviceCmdService.startOrStopAiStrategy(entity, "start");
            if (StringUtils.isNotEmpty((String)json)) {
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String aiAlertId = jsonObject.getString("aiAlertId");
                if (StringUtils.isNotNull((Object)aiAlertId)) {
                    EcbpDeviceAiAlertEntity ecbpDeviceAiAlertEntity = new EcbpDeviceAiAlertEntity();
                    ecbpDeviceAiAlertEntity.setEnabledMark(70);
                    ecbpDeviceAiAlertEntity.setId(aiAlertId);
                    this.ecbpDeviceAiAlertService.updateById(ecbpDeviceAiAlertEntity);
                }
                System.out.println("\u544a\u8b66\u4fe1\u606f\u72b6\u6001\u6539\u4e3a\u5904\u7406\u4e2d");
            }
            return ActionResult.success((String)"\u542f\u52a8\u6210\u529f");
        }
        return ActionResult.fail((String)"\u542f\u52a8\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/stopAiStrategy/{id}"})
    @DSTransactional
    public ActionResult stopAiStrategy(@PathVariable(value="id") String id) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceSmartSceneEntity entity = this.ecbpDeviceSmartSceneService.getInfo(id);
        if (entity != null) {
            EcbpDeviceSmartSceneEntity subentity = new EcbpDeviceSmartSceneEntity();
            subentity.setEnabledMark(90);
            this.ecbpDeviceSmartSceneService.update(id, subentity);
            this.ecbpDeviceCmdService.startOrStopAiStrategy(entity, "stop");
            return ActionResult.success((String)"\u505c\u6b62\u6210\u529f");
        }
        return ActionResult.fail((String)"\u505c\u6b62\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/startAiStrategyByIds/{ids}"})
    @DSTransactional
    public ActionResult startAiStrategyByIds(@PathVariable(value="ids") String ids) throws DataException {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.startAiStrategy(allId, "");
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u542f\u52a8\u5931\u8d25");
        }
        return ActionResult.success((String)"\u542f\u52a8\u6210\u529f");
    }

    @GetMapping(value={"/stopAiStrategyByIds/{ids}"})
    @DSTransactional
    public ActionResult stopAiStrategyByIds(@PathVariable(value="ids") String ids) throws DataException {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.stopAiStrategy(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u505c\u6b62\u5931\u8d25");
        }
        return ActionResult.success((String)"\u505c\u6b62\u6210\u529f");
    }
}

