/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyAiEntity;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyEntity;
import com.bringspring.ecbp.model.ecbpDeviceStraegyAi.EcbpDeviceStrategyAiModel;
import com.bringspring.ecbp.model.ecbpDeviceStraegyAi.EcbpDeviceStrategyAiVo;
import com.bringspring.ecbp.model.ecbpDeviceStraegyCamera.EcbpDeviceStrategyCameraModel;
import com.bringspring.ecbp.model.ecbpDeviceStraegyCamera.EcbpDeviceStrategyCameraVo;
import com.bringspring.ecbp.model.ecbpDeviceStrategy.EcbpDeviceStrategyCrModel;
import com.bringspring.ecbp.model.ecbpDeviceStrategy.EcbpDeviceStrategyModel;
import com.bringspring.ecbp.model.ecbpDeviceStrategy.EcbpDeviceStrategyVo;
import com.bringspring.ecbp.service.EcbpDeviceAiService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceChannelService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyAiService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyCameraService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u76d1\u63a7\u7b56\u7565"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/device/strategy"})
public class EcbpDeviceStrategyController {
    private static final Logger log = LoggerFactory.getLogger(EcbpDeviceStrategyController.class);
    @Autowired
    private EcbpDeviceChannelService ecbpDeviceChannelService;
    @Autowired
    EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    EcbpDeviceStrategyService ecbpDeviceStrategyService;
    @Autowired
    EcbpDeviceStrategyCameraService ecbpDeviceStrategyCameraService;
    @Autowired
    EcbpDeviceStrategyAiService ecbpDeviceStrategyAiService;
    @Autowired
    EcbpDeviceAiService ecbpDeviceAiService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpDeviceStrategyModel ecbpDeviceStrategyModel) {
        List<EcbpDeviceStrategyEntity> list = this.ecbpDeviceStrategyService.getList(ecbpDeviceStrategyModel);
        List listVO = JsonUtil.getJsonToList(list, EcbpDeviceStrategyVo.class);
        for (EcbpDeviceStrategyVo entityVo : listVO) {
            if (10 == entityVo.getEnabledMark()) {
                entityVo.setEnabledMarkStr("\u542f\u7528");
            } else {
                entityVo.setEnabledMarkStr("\u505c\u7528");
            }
            List<EcbpDeviceStrategyCameraEntity> strategyCameraList = this.ecbpDeviceStrategyCameraService.getListByStrategyId(entityVo.getId());
            List<EcbpDeviceStrategyAiEntity> strategyAiList = this.ecbpDeviceStrategyAiService.getListByStrategyId(entityVo.getId());
            List strategyCameraListVO = JsonUtil.getJsonToList(strategyCameraList, EcbpDeviceStrategyCameraVo.class);
            List strategyAiListVO = JsonUtil.getJsonToList(strategyAiList, EcbpDeviceStrategyAiVo.class);
            StringBuffer cameraBuffer = new StringBuffer();
            StringBuffer aiBuffer = new StringBuffer();
            for (EcbpDeviceStrategyCameraVo cameraVo : strategyCameraListVO) {
                cameraBuffer.append(cameraVo.getCameraName()).append("/").append(cameraVo.getDuration()).append(",");
            }
            for (EcbpDeviceStrategyAiVo aiVo : strategyAiListVO) {
                aiBuffer.append(aiVo.getAiName()).append("/").append(aiVo.getDuration()).append(",");
            }
            entityVo.setCameraString(cameraBuffer.toString());
            entityVo.setAiString(aiBuffer.toString());
            entityVo.setStrategyCameraList(strategyCameraListVO);
            entityVo.setStrategyAiList(strategyAiListVO);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyModel), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpDeviceStrategyCrModel ecbpDeviceStrategyCrModel) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpDeviceStrategyEntity entity = (EcbpDeviceStrategyEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyCrModel), EcbpDeviceStrategyEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setStrategyId("");
        entity.setLastModifyUserId(userInfo.getUserId());
        this.ecbpDeviceStrategyService.save(entity);
        for (EcbpDeviceStrategyCameraModel ecbpDeviceStrategyCameraModel : ecbpDeviceStrategyCrModel.getStrategyCameraList()) {
            EcbpDeviceStrategyCameraEntity ecbpDeviceStrategyCameraEntity = (EcbpDeviceStrategyCameraEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyCameraModel), EcbpDeviceStrategyCameraEntity.class);
            ecbpDeviceStrategyCameraEntity.setId(RandomUtil.uuId());
            ecbpDeviceStrategyCameraEntity.setStrategyId(entity.getId());
            ecbpDeviceStrategyCameraEntity.setEnabledMark(10);
            this.ecbpDeviceStrategyCameraService.save(ecbpDeviceStrategyCameraEntity);
        }
        for (EcbpDeviceStrategyAiModel ecbpDeviceStrategyAiModel : ecbpDeviceStrategyCrModel.getStrategyAiList()) {
            EcbpDeviceStrategyAiEntity ecbpDeviceStrategyAiEntity = (EcbpDeviceStrategyAiEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyAiModel), EcbpDeviceStrategyAiEntity.class);
            ecbpDeviceStrategyAiEntity.setId(RandomUtil.uuId());
            ecbpDeviceStrategyAiEntity.setStrategyId(entity.getId());
            ecbpDeviceStrategyAiEntity.setEnabledMark(10);
            this.ecbpDeviceStrategyAiService.save(ecbpDeviceStrategyAiEntity);
        }
        this.ecbpDeviceCmdService.saveOrUpdateCmdStrategyByDeviceId(ecbpDeviceStrategyCrModel);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PutMapping
    @DSTransactional
    public ActionResult update(@RequestBody @Valid EcbpDeviceStrategyCrModel ecbpDeviceStrategyCrModel) {
        UserInfo userInfo = this.userProvider.get();
        if (ecbpDeviceStrategyCrModel != null) {
            EcbpDeviceStrategyEntity entity = (EcbpDeviceStrategyEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyCrModel), EcbpDeviceStrategyEntity.class);
            entity.setLastModifyUserId(userInfo.getUserId());
            this.ecbpDeviceStrategyService.updateById(entity);
            this.ecbpDeviceStrategyCameraService.removeByStrategyId(entity.getId());
            this.ecbpDeviceStrategyAiService.removeByStrategyId(entity.getId());
            for (EcbpDeviceStrategyCameraModel ecbpDeviceStrategyCameraModel : ecbpDeviceStrategyCrModel.getStrategyCameraList()) {
                EcbpDeviceStrategyCameraEntity ecbpDeviceStrategyCameraEntity = (EcbpDeviceStrategyCameraEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyCameraModel), EcbpDeviceStrategyCameraEntity.class);
                ecbpDeviceStrategyCameraEntity.setId(entity.getId() + "_" + ecbpDeviceStrategyCameraModel.getCameraId());
                ecbpDeviceStrategyCameraEntity.setStrategyId(entity.getId());
                ecbpDeviceStrategyCameraEntity.setEnabledMark(10);
                this.ecbpDeviceStrategyCameraService.save(ecbpDeviceStrategyCameraEntity);
            }
            for (EcbpDeviceStrategyAiModel ecbpDeviceStrategyAiModel : ecbpDeviceStrategyCrModel.getStrategyAiList()) {
                EcbpDeviceStrategyAiEntity ecbpDeviceStrategyAiEntity = (EcbpDeviceStrategyAiEntity)JsonUtil.getJsonToBean((Object)((Object)ecbpDeviceStrategyAiModel), EcbpDeviceStrategyAiEntity.class);
                ecbpDeviceStrategyAiEntity.setId(entity.getId() + "_" + ecbpDeviceStrategyAiModel.getAiId());
                ecbpDeviceStrategyAiEntity.setStrategyId(entity.getId());
                ecbpDeviceStrategyAiEntity.setEnabledMark(10);
                this.ecbpDeviceStrategyAiService.save(ecbpDeviceStrategyAiEntity);
            }
            this.ecbpDeviceCmdService.saveOrUpdateCmdStrategyByDeviceId(ecbpDeviceStrategyCrModel);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/cmdUpdate"})
    @DSTransactional
    public ActionResult cmdUpdate(@RequestBody @Valid EcbpDeviceStrategyCrModel ecbpDeviceStrategyCrModel) {
        if (ecbpDeviceStrategyCrModel != null) {
            this.ecbpDeviceCmdService.saveOrUpdateCmdStrategyByDeviceId(ecbpDeviceStrategyCrModel);
            return ActionResult.success((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u7b56\u7565\u6307\u4ee4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u751f\u6210\u66f4\u65b0\u7ec8\u7aef\u7b56\u7565\u6307\u4ee4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpDeviceStrategyVo> info(@PathVariable(value="id") String id) {
        EcbpDeviceStrategyEntity entity = (EcbpDeviceStrategyEntity)this.ecbpDeviceStrategyService.getById((Serializable)((Object)id));
        EcbpDeviceStrategyVo entityVo = (EcbpDeviceStrategyVo)JsonUtil.getJsonToBean((Object)entity, EcbpDeviceStrategyVo.class);
        List<EcbpDeviceStrategyCameraEntity> strategyCameraList = this.ecbpDeviceStrategyCameraService.getListByStrategyId(entityVo.getId());
        List<EcbpDeviceStrategyAiEntity> strategyAiList = this.ecbpDeviceStrategyAiService.getListByStrategyId(entityVo.getId());
        List strategyCameraListVO = JsonUtil.getJsonToList(strategyCameraList, EcbpDeviceStrategyCameraVo.class);
        List strategyAiListVO = JsonUtil.getJsonToList(strategyAiList, EcbpDeviceStrategyAiVo.class);
        StringBuffer cameraBuffer = new StringBuffer();
        StringBuffer aiBuffer = new StringBuffer();
        for (EcbpDeviceStrategyCameraVo cameraVo : strategyCameraListVO) {
            cameraBuffer.append(cameraVo.getCameraName()).append("/").append(cameraVo.getDuration()).append(",");
        }
        for (EcbpDeviceStrategyAiVo aiVo : strategyAiListVO) {
            aiBuffer.append(aiVo.getAiName()).append("/").append(aiVo.getDuration()).append(",");
        }
        entityVo.setCameraString(cameraBuffer.toString());
        entityVo.setAiString(aiBuffer.toString());
        entityVo.setStrategyCameraList(strategyCameraListVO);
        entityVo.setStrategyAiList(strategyAiListVO);
        return ActionResult.success((Object)entityVo);
    }

    @DeleteMapping(value={"/strategyRemove/{ids}"})
    @Transactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        int i = 0;
        for (String allId : idList) {
            this.delete(allId);
            ++i;
        }
        if (i == 0) {
            return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.ecbpDeviceStrategyService.removeById((Serializable)((Object)id));
        this.ecbpDeviceStrategyCameraService.removeByStrategyId(id);
        this.ecbpDeviceStrategyAiService.removeByStrategyId(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

