/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecbp.entity.EcbpDeviceCmdEntity;
import com.bringspring.ecbp.entity.EcbpRequestEntity;
import com.bringspring.ecbp.model.EcbChannelState;
import com.bringspring.ecbp.model.EcbRequest;
import com.bringspring.ecbp.model.EcbResponse;
import com.bringspring.ecbp.model.ecbpDeviceCmd.EcbpDeviceCmdModel;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpRequestService;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u5e73\u53f0"}, value="ecbp")
@RequestMapping(value={"/api/service/ecbp"})
public class EcbpHeartbeatController {
    private static final Logger log = LoggerFactory.getLogger(EcbpHeartbeatController.class);
    @Autowired
    private EcbpRequestService ecbpRequestService;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;
    @Autowired
    private SysConfigService sysConfigService;

    @PostMapping(value={"/heartbeat"})
    @DSTransactional
    public EcbResponse updateHeartbeat(@RequestBody EcbRequest ecbRequest) throws BaseException {
        SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiToken");
        EcbResponse ecbResponse = (EcbResponse)JsonUtil.getJsonToBean((Object)ecbRequest, EcbResponse.class);
        if (StringUtils.isNotNull((Object)sysConfigEntity)) {
            String toke = Md5Util.getStringMd5((String)sysConfigEntity.getKeyValue());
            if (!toke.equals(ecbRequest.getToken())) {
                ecbResponse.setCode("401");
                return ecbResponse;
            }
        } else {
            ecbResponse.setCode("500");
            return ecbResponse;
        }
        EcbpRequestEntity ecbpRequest = (EcbpRequestEntity)JsonUtil.getJsonToBean((Object)ecbRequest, EcbpRequestEntity.class);
        this.ecbpRequestService.create(ecbpRequest);
        this.ecbpRequestService.saveSubForms(ecbRequest);
        this.ecbpDeviceCmdService.careateDevciceCmd(ecbRequest);
        EcbpDeviceCmdModel ecbpDeviceCmdModel = new EcbpDeviceCmdModel();
        ecbpDeviceCmdModel.setDeviceId(ecbRequest.getDeviceId());
        ecbpDeviceCmdModel.setEnabledMark(10);
        EcbpDeviceCmdEntity ecbpDeviceCmdOneInfoByDeviceId = this.ecbpDeviceCmdService.getEcbpDeviceCmdOneInfoByDeviceId(ecbpDeviceCmdModel);
        if (StringUtils.isNotNull((Object)ecbpDeviceCmdOneInfoByDeviceId)) {
            String[] parts = ecbpDeviceCmdOneInfoByDeviceId.getCmd().substring(1, ecbpDeviceCmdOneInfoByDeviceId.getCmd().length() - 1).split(", ");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                ecbResponse.getCmd().add(part);
            }
            ecbResponse.setCmdId(ecbpDeviceCmdOneInfoByDeviceId.getId());
            if (StringUtils.isNotEmpty((String)ecbpDeviceCmdOneInfoByDeviceId.getParas())) {
                ecbResponse.getParas().addAll(JsonUtil.getJsonToJsonArray((String)ecbpDeviceCmdOneInfoByDeviceId.getParas()));
            }
            if (StringUtils.isNotEmpty((String)ecbpDeviceCmdOneInfoByDeviceId.getForce())) {
                List ecbChannelStateList = JsonUtil.getJsonToList((String)ecbpDeviceCmdOneInfoByDeviceId.getForce(), EcbChannelState.class);
                ecbChannelStateList = ecbChannelStateList.stream().distinct().collect(Collectors.toList());
                ecbResponse.getForce().addAll(ecbChannelStateList);
            }
        }
        ecbpRequest.setServerResponse(JsonUtil.getObjectToString((Object)ecbResponse));
        this.ecbpRequestService.updateById(ecbpRequest);
        if (StringUtils.isNotNull((Object)ecbpDeviceCmdOneInfoByDeviceId)) {
            ecbpDeviceCmdOneInfoByDeviceId.setEnabledMark(80);
            this.ecbpDeviceCmdService.updateById(ecbpDeviceCmdOneInfoByDeviceId);
        }
        return ecbResponse;
    }

    @PostMapping(value={"/alertVideoTwin/{type}"})
    @DSTransactional
    public Map<String, Object> getCameraListVideo(@PathVariable(value="type") String type) throws BaseException {
        String json = "{}";
        HashMap<String, Object> resultMap = new HashMap();
        resultMap = this.ecbpRequestService.getToTwinVideo(type, json);
        return resultMap;
    }

    @PostMapping(value={"/alertVideoTwin"})
    @DSTransactional
    public Map<String, Object> getCameraVideo(@RequestBody String json) throws BaseException {
        String type = "0";
        HashMap<String, Object> resultMap = new HashMap();
        resultMap = this.ecbpRequestService.getToTwinVideo(type, json);
        return resultMap;
    }

    @PostMapping(value={"/alertVideoList"})
    @DSTransactional
    public Map<String, Object> getAlertVideoList() throws BaseException {
        String json = "{}";
        HashMap<String, Object> resultMap = new HashMap();
        resultMap = this.ecbpRequestService.getCameraListVideo();
        return resultMap;
    }
}

