/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.entity.EcbpRequestEntity;
import com.bringspring.ecbp.model.EcbChannelState;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestCrForm;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestInfoVO;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestListVO;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestPagination;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestUpForm;
import com.bringspring.ecbp.service.EcbpDeviceService;
import com.bringspring.ecbp.service.EcbpRequestService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fb9\u7f18\u8ba1\u7b97\u76d2\u8bf7\u6c42"}, value="ecbp")
@RequestMapping(value={"/api/ecbp/EcbpRequest"})
public class EcbpRequestController {
    private static final Logger log = LoggerFactory.getLogger(EcbpRequestController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private EcbpRequestService ecbpRequestService;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody EcbpRequestPagination ecbpRequestPagination) throws IOException {
        List<EcbpRequestEntity> list = this.ecbpRequestService.getList(ecbpRequestPagination);
        for (EcbpRequestEntity ecbpRequestEntity : list) {
            if (ecbpRequestEntity.getTime().length() != 10) continue;
            ecbpRequestEntity.setTime(ecbpRequestEntity.getTime() + "000");
        }
        List listVO = JsonUtil.getJsonToList(list, EcbpRequestListVO.class);
        for (EcbpRequestListVO ecbpRequestVO : listVO) {
            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpRequestVO.getDeviceId()));
            if (ecbpDeviceEntity != null) {
                ecbpRequestVO.setDeviceName(ecbpDeviceEntity.getDeviceName());
            } else {
                ecbpRequestVO.setDeviceName("\u9ed8\u8ba4\u540d\u79f0");
            }
            List ecbChannelStateList = JsonUtil.getJsonToList((String)ecbpRequestVO.getChannelState(), EcbChannelState.class);
            if (ecbChannelStateList != null && ecbChannelStateList.size() > 0) {
                if (((EcbChannelState)ecbChannelStateList.get(0)).getEnabledMark().contains("alert")) {
                    ecbpRequestVO.setEnabledMark("\u544a\u8b66");
                } else if (((EcbChannelState)ecbChannelStateList.get(0)).getEnabledMark().contains("normal")) {
                    ecbpRequestVO.setEnabledMark("\u6b63\u5e38");
                } else if (((EcbChannelState)ecbChannelStateList.get(0)).getEnabledMark().contains("force")) {
                    ecbpRequestVO.setEnabledMark("\u8c03\u5ea6");
                } else {
                    ecbpRequestVO.setEnabledMark("\u6b63\u5e38");
                }
            } else {
                ecbpRequestVO.setEnabledMark("\u6b63\u5e38");
            }
            JSONArray ecbResponseList = JsonUtil.getJsonToJsonArray((String)ecbpRequestVO.getResponse());
            JSONObject serviceResponseJsonObj = JSONObject.parseObject((String)ecbpRequestVO.getServerResponse());
            if (ecbResponseList != null && ecbResponseList.size() > 0 && StringUtils.isNotEmpty((String)serviceResponseJsonObj.getString("cmdId"))) {
                ecbpRequestVO.setSeqType("\u4e0a\u884c/\u4e0b\u884c");
                continue;
            }
            if (ecbResponseList != null && ecbResponseList.size() < 1 && StringUtils.isNotEmpty((String)serviceResponseJsonObj.getString("cmdId"))) {
                ecbpRequestVO.setSeqType("\u4e0b\u884c");
                continue;
            }
            if (ecbResponseList != null && ecbResponseList.size() > 0) {
                ecbpRequestVO.setSeqType("\u4e0a\u884c");
                continue;
            }
            ecbpRequestVO.setSeqType("\u5fc3\u8df3");
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ecbpRequestPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid EcbpRequestCrForm ecbpRequestCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        EcbpRequestEntity entity = (EcbpRequestEntity)JsonUtil.getJsonToBean((Object)ecbpRequestCrForm, EcbpRequestEntity.class);
        entity.setId(mainId);
        this.ecbpRequestService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<EcbpRequestInfoVO> info(@PathVariable(value="id") String id) {
        EcbpRequestEntity entity = this.ecbpRequestService.getInfo(id);
        EcbpRequestInfoVO vo = (EcbpRequestInfoVO)JsonUtil.getJsonToBean((Object)entity, EcbpRequestInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<EcbpRequestInfoVO> detailInfo(@PathVariable(value="id") String id) {
        EcbpRequestEntity entity = this.ecbpRequestService.getInfo(id);
        if (entity.getTime().length() == 10) {
            entity.setTime(entity.getTime() + "000");
        }
        EcbpRequestInfoVO vo = (EcbpRequestInfoVO)JsonUtil.getJsonToBean((Object)entity, EcbpRequestInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid EcbpRequestUpForm ecbpRequestUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        EcbpRequestEntity entity = this.ecbpRequestService.getInfo(id);
        if (entity != null) {
            EcbpRequestEntity subentity = (EcbpRequestEntity)JsonUtil.getJsonToBean((Object)ecbpRequestUpForm, EcbpRequestEntity.class);
            this.ecbpRequestService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        EcbpRequestEntity entity = this.ecbpRequestService.getInfo(id);
        if (entity != null) {
            this.ecbpRequestService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

