/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecbp.entity.EcbpDeviceCameraEntity;
import com.bringspring.ecbp.mapper.EcbpDeviceCameraMapper;
import com.bringspring.ecbp.model.ecbpDeviceCamera.EcbpDeviceCameraModel;
import com.bringspring.ecbp.model.ecbpDeviceCameraGroup.EcbpDeviceCameraGroupModel;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceChannelService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyCameraService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcbpDeviceCameraServiceImpl
extends ServiceImpl<EcbpDeviceCameraMapper, EcbpDeviceCameraEntity>
implements EcbpDeviceCameraService {
    @Autowired
    private EcbpDeviceChannelService ecbpDeviceChannelService;
    @Autowired
    private EcbpDeviceStrategyService ecbpDeviceStrategyService;
    @Autowired
    private EcbpDeviceStrategyCameraService ecbpDeviceStrategyCameraService;

    @Override
    public List<EcbpDeviceCameraEntity> getList(EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecbpDeviceCameraModel.getCameraName())) {
            daapJobSourceQueryWrapper.lambda().like(EcbpDeviceCameraEntity::getCameraName, (Object)ecbpDeviceCameraModel.getCameraName());
        }
        if (StringUtils.isNotEmpty((String)ecbpDeviceCameraModel.getGroupId())) {
            daapJobSourceQueryWrapper.lambda().eq(EcbpDeviceCameraEntity::getGroupId, (Object)ecbpDeviceCameraModel.getGroupId());
        }
        if (ecbpDeviceCameraModel.getEnabledMark() != null && StringUtils.isNotEmpty((String)ecbpDeviceCameraModel.getEnabledMark().toString())) {
            daapJobSourceQueryWrapper.lambda().eq(EcbpDeviceCameraEntity::getEnabledMark, (Object)ecbpDeviceCameraModel.getEnabledMark());
        }
        Page page = new Page(ecbpDeviceCameraModel.getCurrentPage(), ecbpDeviceCameraModel.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)daapJobSourceQueryWrapper);
        return ecbpDeviceCameraModel.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<EcbpDeviceCameraEntity> getGroupList() {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        daapJobSourceQueryWrapper.groupBy((Object)"GROUP_NAME");
        return this.list((Wrapper)daapJobSourceQueryWrapper);
    }

    @Override
    public void delCameraInfoByGroupName(String groupName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcbpDeviceCameraEntity::getGroupId, (Object)groupName);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void updateCameraInfoByGroupName(EcbpDeviceCameraGroupModel ecbpDeviceCameraGroupModel) {
    }

    @Override
    public List<EcbpDeviceCameraEntity> getListByGroupId(String groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcbpDeviceCameraEntity::getGroupId, (Object)groupId);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public void removeByGroupId(String groupId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcbpDeviceCameraEntity::getGroupId, (Object)groupId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<EcbpDeviceCameraEntity> getChannelCameraList(EcbpDeviceCameraModel ecbpDeviceCameraModel) {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        daapJobSourceQueryWrapper.lambda().like(EcbpDeviceCameraEntity::getDeviceIds, (Object)ecbpDeviceCameraModel.getDeviceId());
        if (StringUtils.isNotEmpty((String)ecbpDeviceCameraModel.getCameraName())) {
            daapJobSourceQueryWrapper.lambda().like(EcbpDeviceCameraEntity::getCameraName, (Object)ecbpDeviceCameraModel.getCameraName());
        }
        Page page = new Page(ecbpDeviceCameraModel.getCurrentPage(), ecbpDeviceCameraModel.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)daapJobSourceQueryWrapper);
        return ecbpDeviceCameraModel.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public void removeByDeviceId(String deviceId) {
        QueryWrapper daapJobSourceQueryWrapper = new QueryWrapper();
        daapJobSourceQueryWrapper.lambda().eq(EcbpDeviceCameraEntity::getDeviceIds, (Object)deviceId);
        this.remove((Wrapper)daapJobSourceQueryWrapper);
    }
}

