/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.ecbp.entity.EcbpDeviceAiAlertEntity;
import com.bringspring.ecbp.entity.EcbpDeviceAiEntity;
import com.bringspring.ecbp.entity.EcbpDeviceBusinessEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCameraGroupEntity;
import com.bringspring.ecbp.entity.EcbpDeviceChannelEntity;
import com.bringspring.ecbp.entity.EcbpDeviceChannelStateEntity;
import com.bringspring.ecbp.entity.EcbpDeviceChannelStateLogEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCmdEntity;
import com.bringspring.ecbp.entity.EcbpDeviceCmdForceEntity;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.entity.EcbpDeviceSmartSceneEntity;
import com.bringspring.ecbp.entity.EcbpDeviceSmartSceneItemEntity;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyAiEntity;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyCameraEntity;
import com.bringspring.ecbp.entity.EcbpDeviceStrategyEntity;
import com.bringspring.ecbp.entity.EcbpDeviceSystemEntity;
import com.bringspring.ecbp.entity.EcbpRequestEntity;
import com.bringspring.ecbp.mapper.EcbpRequestMapper;
import com.bringspring.ecbp.model.EcbAi;
import com.bringspring.ecbp.model.EcbAlert;
import com.bringspring.ecbp.model.EcbBusiness;
import com.bringspring.ecbp.model.EcbCamera;
import com.bringspring.ecbp.model.EcbCameraGroup;
import com.bringspring.ecbp.model.EcbChannel;
import com.bringspring.ecbp.model.EcbRequest;
import com.bringspring.ecbp.model.EcbStrategy;
import com.bringspring.ecbp.model.EcbStrategyAIRelation;
import com.bringspring.ecbp.model.EcbStrategyCameraRelation;
import com.bringspring.ecbp.model.ecbpDeviceAiAlert.EcbpDeviceAiAlertToTwin;
import com.bringspring.ecbp.model.ecbpDeviceChannel.EcbpDeviceChannelModel;
import com.bringspring.ecbp.model.ecbpDeviceSmartScene.EcbpDeviceSmartScenePagination;
import com.bringspring.ecbp.model.ecbprequest.EcbpRequestPagination;
import com.bringspring.ecbp.service.EcbpDeviceAiAlertService;
import com.bringspring.ecbp.service.EcbpDeviceAiService;
import com.bringspring.ecbp.service.EcbpDeviceBusinessService;
import com.bringspring.ecbp.service.EcbpDeviceCameraGroupService;
import com.bringspring.ecbp.service.EcbpDeviceCameraService;
import com.bringspring.ecbp.service.EcbpDeviceChannelService;
import com.bringspring.ecbp.service.EcbpDeviceChannelStateLogService;
import com.bringspring.ecbp.service.EcbpDeviceChannelStateService;
import com.bringspring.ecbp.service.EcbpDeviceCmdService;
import com.bringspring.ecbp.service.EcbpDeviceService;
import com.bringspring.ecbp.service.EcbpDeviceSmartSceneService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyAiService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyCameraService;
import com.bringspring.ecbp.service.EcbpDeviceStrategyService;
import com.bringspring.ecbp.service.EcbpDeviceSystemService;
import com.bringspring.ecbp.service.EcbpRequestService;
import com.bringspring.ecbp.utils.ThingJSUtil;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EcbpRequestServiceImpl
extends ServiceImpl<EcbpRequestMapper, EcbpRequestEntity>
implements EcbpRequestService {
    private static final Logger log = LoggerFactory.getLogger(EcbpRequestServiceImpl.class);
    private static final String AI_ALERT_CODE = "aiAlertCode";
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    @Autowired
    private EcbpDeviceSystemService ecbpDeviceSystemService;
    @Autowired
    private EcbpDeviceChannelService ecbpDeviceChannelService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private EcbpDeviceStrategyService ecbpDeviceStrategyService;
    @Autowired
    private EcbpDeviceStrategyCameraService ecbpDeviceStrategyCameraService;
    @Autowired
    private EcbpDeviceStrategyAiService ecbpDeviceStrategyAiService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private EcbpDeviceAiService ecbpDeviceAiService;
    @Autowired
    private EcbpDeviceAiAlertService ecbpDeviceAiAlertService;
    @Autowired
    private EcbpDeviceCameraService ecbpDeviceCameraService;
    @Autowired
    private EcbpDeviceCameraGroupService ecbpDeviceCameraGroupService;
    @Autowired
    private EcbpDeviceCmdService ecbpDeviceCmdService;
    @Autowired
    private EcbpDeviceChannelStateService ecbpDeviceChannelStateService;
    @Autowired
    private EcbpDeviceChannelStateLogService ecbpDeviceChannelStateLogService;
    @Autowired
    private EcbpDeviceSmartSceneService ecbpDeviceSmartSceneService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private EcbpDeviceBusinessService ecbpDeviceBusinessService;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<EcbpRequestEntity> getList(EcbpRequestPagination ecbpRequestPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecbpRequestNum = 0;
        QueryWrapper ecbpRequestQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecbpRequestPagination.getDeviceId())) {
            ++ecbpRequestNum;
            ecbpRequestQueryWrapper.lambda().like(EcbpRequestEntity::getDeviceId, (Object)ecbpRequestPagination.getDeviceId());
        }
        if (StringUtils.isNotEmpty(ecbpRequestPagination.getTime())) {
            ++ecbpRequestNum;
            List<String> TimeList = ecbpRequestPagination.getTime();
            Long fir = Long.valueOf(TimeList.get(0));
            Long sec = Long.valueOf(TimeList.get(1));
            ((LambdaQueryWrapper)ecbpRequestQueryWrapper.lambda().ge(EcbpRequestEntity::getCreatorTime, (Object)new Date(fir))).le(EcbpRequestEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            ecbpRequestQueryWrapper.lambda().in(EcbpRequestEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecbpRequestPagination.getSidx())) {
            ecbpRequestQueryWrapper.lambda().orderByDesc(EcbpRequestEntity::getId);
        } else {
            try {
                String sidx = ecbpRequestPagination.getSidx();
                EcbpRequestEntity ecbpRequestEntity = new EcbpRequestEntity();
                Field declaredField = ecbpRequestEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecbpRequestQueryWrapper = "asc".equals(ecbpRequestPagination.getSort().toLowerCase()) ? (QueryWrapper)ecbpRequestQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecbpRequestQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(ecbpRequestPagination.getCurrentPage(), ecbpRequestPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)ecbpRequestQueryWrapper);
            return ecbpRequestPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return ecbpRequestPagination.setData(list, list.size());
    }

    @Override
    public List<EcbpRequestEntity> getTypeList(EcbpRequestPagination ecbpRequestPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ecbpRequestNum = 0;
        QueryWrapper ecbpRequestQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)ecbpRequestPagination.getDeviceId())) {
            ++ecbpRequestNum;
            ecbpRequestQueryWrapper.lambda().like(EcbpRequestEntity::getDeviceId, (Object)ecbpRequestPagination.getDeviceId());
        }
        if (StringUtils.isNotEmpty(ecbpRequestPagination.getTime())) {
            ++ecbpRequestNum;
            List<String> TimeList = ecbpRequestPagination.getTime();
            Long fir = Long.valueOf(TimeList.get(0));
            Long sec = Long.valueOf(TimeList.get(1));
            ((LambdaQueryWrapper)ecbpRequestQueryWrapper.lambda().ge(EcbpRequestEntity::getTime, (Object)new Date(fir))).le(EcbpRequestEntity::getTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            ecbpRequestQueryWrapper.lambda().in(EcbpRequestEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)ecbpRequestPagination.getSidx())) {
            ecbpRequestQueryWrapper.lambda().orderByDesc(EcbpRequestEntity::getId);
        } else {
            try {
                String sidx = ecbpRequestPagination.getSidx();
                EcbpRequestEntity ecbpRequestEntity = new EcbpRequestEntity();
                Field declaredField = ecbpRequestEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                ecbpRequestQueryWrapper = "asc".equals(ecbpRequestPagination.getSort().toLowerCase()) ? (QueryWrapper)ecbpRequestQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)ecbpRequestQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(ecbpRequestPagination.getCurrentPage(), ecbpRequestPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)ecbpRequestQueryWrapper);
                return ecbpRequestPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return ecbpRequestPagination.setData(list, list.size());
        }
        return this.list((Wrapper)ecbpRequestQueryWrapper);
    }

    @Override
    public EcbpRequestEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(EcbpRequestEntity::getId, (Object)id);
        return (EcbpRequestEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(EcbpRequestEntity entity) {
        this.redisUtil.insert(entity.getDeviceId(), (Object)entity, 60L);
        this.save(entity);
    }

    @Override
    public boolean update(String id, EcbpRequestEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void saveSubForms(EcbRequest ecbRequest) {
        EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbRequest.getDeviceId()));
        if (StringUtils.isNull((Object)ecbpDeviceEntity)) {
            log.info("\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b58\u5728");
        } else {
            this.saveAiAlertInfo(ecbRequest);
            this.saveChannelState(ecbRequest);
        }
        List<String> response = ecbRequest.getResponse();
        if (response.size() < 1) {
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.get(0));
        JSONArray cmd = jsonObject.getJSONArray("cmd");
        String result = jsonObject.getString("result");
        String cmdId = jsonObject.getString("cmdId");
        if ("success".equals(result)) {
            if (cmd.contains((Object)"allPara")) {
                this.saveDeviceInfo(ecbRequest);
                this.saveDeviceSystemInfo(ecbRequest);
                this.saveBusinessInfo(ecbRequest);
                this.saveChannelInfo(ecbRequest);
                this.saveCameraGroupInfo(ecbRequest);
                this.saveCameraInfo(ecbRequest);
                this.saveAiInfo(ecbRequest);
            } else if (cmd.contains((Object)"device")) {
                this.saveDeviceInfo(ecbRequest);
            } else if (cmd.contains((Object)"system")) {
                this.saveDeviceSystemInfo(ecbRequest);
            } else if (cmd.contains((Object)"aiList")) {
                this.saveAiInfo(ecbRequest);
            } else if (cmd.contains((Object)"channelList")) {
                this.saveChannelInfo(ecbRequest);
            } else if (cmd.contains((Object)"cameraList")) {
                this.saveCameraInfo(ecbRequest);
            } else if (cmd.contains((Object)"cameraGroupList")) {
                this.saveCameraGroupInfo(ecbRequest);
            } else if (cmd.contains((Object)"businessList")) {
                this.saveBusinessInfo(ecbRequest);
            }
        } else {
            log.info("\u6b63\u5e38\u5fc3\u8df3/\u6307\u4ee4\u6267\u884c\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)cmdId)) {
            EcbpDeviceCmdEntity entity = new EcbpDeviceCmdEntity();
            entity.setId(cmdId);
            entity.setResponse(ecbRequest.getResponse().toString());
            entity.setEnabledMark(90);
            this.ecbpDeviceCmdService.updateById(entity);
        }
    }

    @Override
    public Map<String, Object> getToTwinVideo(String type, String json) throws BaseException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String twinId = jsonObject.getString("id");
        if (StringUtils.isEmpty((String)twinId)) {
            twinId = jsonObject.getString("value");
        }
        int code = 200;
        List<Object> resultList = new ArrayList();
        boolean success = true;
        SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiVideoUrl");
        if ("1".equals(type)) {
            System.out.println("\u544a\u8b66\u89c6\u9891\u753b\u9762");
            List<EcbpDeviceSmartSceneEntity> smartSceneEntityList = this.ecbpDeviceSmartSceneService.getSmartSceneStartList("", 10);
            for (EcbpDeviceSmartSceneEntity smartSceneEntity : smartSceneEntityList) {
                List<EcbpDeviceSmartSceneItemEntity> ecbpDeviceSmartSceneItemList = this.ecbpDeviceSmartSceneService.getEcbpDeviceSmartSceneItem(smartSceneEntity.getId());
                for (EcbpDeviceSmartSceneItemEntity deviceSmartSceneItemEntity : ecbpDeviceSmartSceneItemList) {
                    HashMap<String, String> twinMap = new HashMap<String, String>();
                    twinMap.put("ID", deviceSmartSceneItemEntity.getCameraId());
                    if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                        twinMap.put("URL", sysConfigEntity.getKeyValue() + deviceSmartSceneItemEntity.getChannelId() + ".m3u8");
                    } else {
                        twinMap.put("URL", "");
                    }
                    resultList.add(twinMap);
                }
            }
            List distinctList = resultList.stream().collect(Collectors.toMap(map -> map.get("ID"), Function.identity(), (oldValue, newValue) -> oldValue)).values().stream().collect(Collectors.toList());
            resultList = distinctList;
        } else if ("0".equals(type)) {
            if (StringUtils.isNotNull((Object)twinId)) {
                List<EcbpDeviceChannelEntity> ecbpDeviceChannelEntityList;
                System.out.println("\u56fa\u5b9a\u6444\u50cf\u5934\u89c6\u9891\u753b\u9762");
                EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)twinId));
                String deviceId = "";
                if (!StringUtils.isNotNull((Object)ecbpDeviceCameraEntity) || !StringUtils.isNotEmpty((String)ecbpDeviceCameraEntity.getDeviceIds())) {
                    code = 500;
                    success = false;
                    resultMap.put("code", code);
                    resultMap.put("data", resultList);
                    resultMap.put("success", success);
                    return resultMap;
                }
                String[] deviceIds = ecbpDeviceCameraEntity.getDeviceIds().split(",");
                deviceId = deviceIds[0];
                List<EcbpDeviceSmartSceneEntity> smartSceneEntityList = this.ecbpDeviceSmartSceneService.getSmartSceneStartList(deviceId, 10);
                for (EcbpDeviceSmartSceneEntity smartSceneEntity : smartSceneEntityList) {
                    List<EcbpDeviceSmartSceneItemEntity> ecbpDeviceSmartSceneItemList = this.ecbpDeviceSmartSceneService.getEcbpDeviceSmartSceneItem(smartSceneEntity.getId());
                    for (EcbpDeviceSmartSceneItemEntity deviceSmartSceneItemEntity : ecbpDeviceSmartSceneItemList) {
                        if (!twinId.equals(deviceSmartSceneItemEntity.getCameraId())) continue;
                        HashMap<String, String> twinMap = new HashMap<String, String>();
                        twinMap.put("ID", deviceSmartSceneItemEntity.getCameraId());
                        if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                            twinMap.put("URL", sysConfigEntity.getKeyValue() + deviceSmartSceneItemEntity.getChannelId() + ".m3u8");
                        } else {
                            twinMap.put("URL", "");
                        }
                        resultList.add(twinMap);
                        resultMap.put("code", code);
                        resultMap.put("data", resultList);
                        resultMap.put("success", success);
                        return resultMap;
                    }
                }
                EcbpDeviceChannelModel ecbpDeviceChannelModel = new EcbpDeviceChannelModel();
                ecbpDeviceChannelModel.setCurrentPage(1L);
                ecbpDeviceChannelModel.setPageSize(100000L);
                ecbpDeviceChannelModel.setDeviceId(deviceId);
                List<EcbpDeviceChannelEntity> freeChannelList = ecbpDeviceChannelEntityList = this.ecbpDeviceChannelService.getList(ecbpDeviceChannelModel);
                for (EcbpDeviceSmartSceneEntity smartSceneEntity : smartSceneEntityList) {
                    List<EcbpDeviceSmartSceneItemEntity> ecbpDeviceSmartSceneItemList = this.ecbpDeviceSmartSceneService.getEcbpDeviceSmartSceneItem(smartSceneEntity.getId());
                    for (EcbpDeviceSmartSceneItemEntity deviceSmartSceneItemEntity : ecbpDeviceSmartSceneItemList) {
                        freeChannelList = freeChannelList.stream().filter(entity -> !entity.getId().equals(deviceSmartSceneItemEntity.getChannelId())).collect(Collectors.toList());
                    }
                }
                EcbpDeviceCmdForceEntity ecbpDeviceCmdForceEntity = new EcbpDeviceCmdForceEntity();
                HashMap<String, String> twinMap = new HashMap<String, String>();
                if (freeChannelList.size() > 0) {
                    ecbpDeviceCmdForceEntity.setChannelId(freeChannelList.get(0).getId());
                    twinMap.put("URL", sysConfigEntity.getKeyValue() + freeChannelList.get(0).getId() + ".m3u8");
                } else {
                    ecbpDeviceCmdForceEntity.setChannelId(ecbpDeviceChannelEntityList.get(0).getId());
                    twinMap.put("URL", sysConfigEntity.getKeyValue() + ecbpDeviceChannelEntityList.get(0).getId() + ".m3u8");
                }
                ecbpDeviceCmdForceEntity.setCameraId(twinId);
                this.ecbpDeviceCmdService.saveOrUpdateCmdForceByDeviceId(ecbpDeviceCmdForceEntity, "start");
                twinMap.put("ID", twinId);
                resultList.add(twinMap);
            } else {
                System.out.println("\u5168\u90e8\u89c6\u9891\u753b\u9762");
                EcbpDeviceChannelModel ecbpDeviceChannelModel = new EcbpDeviceChannelModel();
                ecbpDeviceChannelModel.setCurrentPage(1L);
                ecbpDeviceChannelModel.setPageSize(100000L);
                List<EcbpDeviceChannelEntity> ecbpDeviceChannelEntityList = this.ecbpDeviceChannelService.getList(ecbpDeviceChannelModel);
                for (EcbpDeviceChannelEntity channelEntity : ecbpDeviceChannelEntityList) {
                    HashMap<String, String> twinMap = new HashMap<String, String>();
                    twinMap.put("ID", "");
                    twinMap.put("URL", sysConfigEntity.getKeyValue() + channelEntity.getId() + ".m3u8");
                    resultList.add(twinMap);
                }
            }
        }
        resultMap.put("code", code);
        resultMap.put("data", resultList);
        resultMap.put("success", success);
        return resultMap;
    }

    @Override
    public Map<String, Object> getCameraListVideo() throws BaseException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int code = 200;
        List<Object> resultList = new ArrayList();
        boolean success = true;
        SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiVideoUrl");
        System.out.println("\u544a\u8b66\u89c6\u9891\u753b\u9762");
        List<EcbpDeviceSmartSceneEntity> smartSceneEntityList = this.ecbpDeviceSmartSceneService.getSmartSceneStartList("", 10);
        for (EcbpDeviceSmartSceneEntity smartSceneEntity : smartSceneEntityList) {
            List<EcbpDeviceSmartSceneItemEntity> ecbpDeviceSmartSceneItemList = this.ecbpDeviceSmartSceneService.getEcbpDeviceSmartSceneItem(smartSceneEntity.getId());
            for (EcbpDeviceSmartSceneItemEntity deviceSmartSceneItemEntity : ecbpDeviceSmartSceneItemList) {
                HashMap<String, String> twinMap = new HashMap<String, String>();
                if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                    twinMap.put("address", sysConfigEntity.getKeyValue() + deviceSmartSceneItemEntity.getChannelId() + ".m3u8");
                } else {
                    twinMap.put("address", "");
                }
                resultList.add(twinMap);
            }
        }
        List distinctList = resultList.stream().collect(Collectors.toMap(map -> map.get("ID"), Function.identity(), (oldValue, newValue) -> oldValue)).values().stream().collect(Collectors.toList());
        resultList = distinctList;
        resultMap.put("code", code);
        resultMap.put("data", resultList);
        resultMap.put("success", success);
        return resultMap;
    }

    private void saveChannelState(EcbRequest ecbRequest) {
        if (StringUtils.isNotNull(ecbRequest.getChannelState()) && ecbRequest.getChannelState().size() > 0) {
            List ecbpDeviceChannelStateEntityList = JsonUtil.getJsonToList(ecbRequest.getChannelState(), EcbpDeviceChannelStateEntity.class);
            List ecbpDeviceChannelStateLogEntityList = JsonUtil.getJsonToList(ecbRequest.getChannelState(), EcbpDeviceChannelStateLogEntity.class);
            this.ecbpDeviceChannelStateService.delByDeviceId(ecbRequest.getDeviceId());
            for (EcbpDeviceChannelStateEntity entity : ecbpDeviceChannelStateEntityList) {
                entity.setDeviceId(ecbRequest.getDeviceId());
                entity.setId(RandomUtil.uuId());
                entity.setDataState(10);
            }
            this.ecbpDeviceChannelStateService.saveBatch(ecbpDeviceChannelStateEntityList);
            ExecutorService executor = Executors.newFixedThreadPool(1);
            Callable<String> task = () -> {
                for (EcbpDeviceChannelStateLogEntity entity : ecbpDeviceChannelStateLogEntityList) {
                    entity.setDeviceId(ecbRequest.getDeviceId());
                    entity.setId(RandomUtil.uuId());
                    entity.setDataState(10);
                }
                this.ecbpDeviceChannelStateLogService.saveBatch(ecbpDeviceChannelStateLogEntityList);
                return "Hello";
            };
            Future<String> future = executor.submit(task);
            executor.shutdown();
        }
    }

    public void saveDeviceInfo(EcbRequest ecbRequest) {
        if (StringUtils.isNotNull((Object)ecbRequest.getDevice())) {
            EcbpDeviceEntity deviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbRequest.getDeviceId()));
            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)JsonUtil.getJsonToBean((Object)ecbRequest.getDevice(), EcbpDeviceEntity.class);
            ecbpDeviceEntity.setId(ecbRequest.getDeviceId());
            ecbpDeviceEntity.setDeviceId(ecbRequest.getDeviceId());
            ecbpDeviceEntity.setToken(ecbRequest.getToken());
            if (StringUtils.isNotNull((Object)deviceEntity)) {
                ecbpDeviceEntity.setDeviceName(deviceEntity.getDeviceName());
                ecbpDeviceEntity.setEnabledMark(10);
                this.ecbpDeviceService.updateById(ecbpDeviceEntity);
            } else {
                ecbpDeviceEntity.setEnabledMark(10);
                this.ecbpDeviceService.save(ecbpDeviceEntity);
            }
        }
    }

    public void saveDeviceSystemInfo(EcbRequest ecbRequest) {
        if (StringUtils.isNotNull((Object)ecbRequest.getSystem())) {
            EcbpDeviceSystemEntity deviceSystemEntity = (EcbpDeviceSystemEntity)this.ecbpDeviceSystemService.getById((Serializable)((Object)ecbRequest.getDeviceId()));
            EcbpDeviceSystemEntity ecbpDeviceSystemEntity = (EcbpDeviceSystemEntity)JsonUtil.getJsonToBean((Object)ecbRequest.getSystem(), EcbpDeviceSystemEntity.class);
            ecbpDeviceSystemEntity.setId(ecbRequest.getDeviceId());
            ecbpDeviceSystemEntity.setDeviceId(ecbRequest.getDeviceId());
            if (StringUtils.isNotNull((Object)deviceSystemEntity)) {
                this.ecbpDeviceSystemService.updateById(ecbpDeviceSystemEntity);
            } else {
                this.ecbpDeviceSystemService.save(ecbpDeviceSystemEntity);
            }
        }
    }

    public void saveCameraGroupInfo(EcbRequest ecbRequest) {
        List<EcbpDeviceCameraGroupEntity> cameraGroupByDeviceId = this.ecbpDeviceCameraGroupService.getCameraGroupByDeviceId(ecbRequest.getDeviceId());
        this.ecbpDeviceCameraGroupService.removeBatchByIds(cameraGroupByDeviceId);
        if (ecbRequest.getCameraGroupList().size() > 0) {
            for (EcbCameraGroup ecbCameraGroup : ecbRequest.getCameraGroupList()) {
                EcbpDeviceCameraGroupEntity ecbpDeviceCameraGroupEntity = (EcbpDeviceCameraGroupEntity)JsonUtil.getJsonToBean((Object)ecbCameraGroup, EcbpDeviceCameraGroupEntity.class);
                ecbpDeviceCameraGroupEntity.setId(ecbRequest.getDeviceId() + "_" + ecbCameraGroup.getId());
                ecbpDeviceCameraGroupEntity.setParentId(ecbRequest.getDeviceId() + "_" + ecbCameraGroup.getParentId());
                ecbpDeviceCameraGroupEntity.setDeviceIds(ecbRequest.getDeviceId());
                this.ecbpDeviceCameraGroupService.save(ecbpDeviceCameraGroupEntity);
            }
        }
    }

    public void saveChannelInfo(EcbRequest ecbRequest) {
        if (ecbRequest.getChannelList().size() > 0) {
            this.ecbpDeviceChannelService.delByDeviceId(ecbRequest.getDeviceId());
            for (EcbChannel ecbChannel : ecbRequest.getChannelList()) {
                EcbpDeviceChannelEntity ecbpDeviceChannelEntity = (EcbpDeviceChannelEntity)JsonUtil.getJsonToBean((Object)ecbChannel, EcbpDeviceChannelEntity.class);
                String deviceChannelId = ecbRequest.getDeviceId() + "_" + ecbpDeviceChannelEntity.getId();
                ecbpDeviceChannelEntity.setChannelName("\u901a\u9053" + ecbpDeviceChannelEntity.getId());
                ecbpDeviceChannelEntity.setId(deviceChannelId);
                ecbpDeviceChannelEntity.setEnabledMark(10);
                ecbpDeviceChannelEntity.setDeviceId(ecbRequest.getDeviceId());
                ecbpDeviceChannelEntity.setProtocal(ecbpDeviceChannelEntity.getProtocal());
                this.ecbpDeviceChannelService.save(ecbpDeviceChannelEntity);
                List<EcbpDeviceStrategyEntity> strategyEntityListByChannelId = this.ecbpDeviceStrategyService.getListByChannelId(deviceChannelId);
                for (EcbpDeviceStrategyEntity ecbpDeviceStrategyEntity : strategyEntityListByChannelId) {
                    this.ecbpDeviceStrategyCameraService.removeByStrategyId(ecbpDeviceStrategyEntity.getId());
                    this.ecbpDeviceStrategyAiService.removeByStrategyId(ecbpDeviceStrategyEntity.getId());
                }
                this.ecbpDeviceStrategyService.removeByChannelId(deviceChannelId);
                if (ecbChannel.getStrategyList().size() <= 0) continue;
                for (EcbStrategy ecbStrategy : ecbChannel.getStrategyList()) {
                    EcbpDeviceStrategyEntity ecbpDeviceStrategyEntity = (EcbpDeviceStrategyEntity)JsonUtil.getJsonToBean((Object)ecbStrategy, EcbpDeviceStrategyEntity.class);
                    String strategyId = deviceChannelId + "_" + ecbStrategy.getId();
                    ecbpDeviceStrategyEntity.setId(strategyId);
                    ecbpDeviceStrategyEntity.setStrategyId(ecbStrategy.getId());
                    ecbpDeviceStrategyEntity.setChannelId(ecbpDeviceChannelEntity.getId());
                    this.ecbpDeviceStrategyService.save(ecbpDeviceStrategyEntity);
                    if (ecbStrategy.getCameraList().size() > 0) {
                        for (EcbStrategyCameraRelation ecbStrategyCameraRelation : ecbStrategy.getCameraList()) {
                            EcbpDeviceStrategyCameraEntity ecbpDeviceStrategyCameraEntity = (EcbpDeviceStrategyCameraEntity)JsonUtil.getJsonToBean((Object)ecbStrategyCameraRelation, EcbpDeviceStrategyCameraEntity.class);
                            String strategyCameraId = strategyId + "_" + ecbStrategyCameraRelation.getCameraId();
                            ecbpDeviceStrategyCameraEntity.setId(strategyCameraId);
                            ecbpDeviceStrategyCameraEntity.setStrategyId(strategyId);
                            ecbpDeviceStrategyCameraEntity.setEnabledMark(10);
                            this.ecbpDeviceStrategyCameraService.save(ecbpDeviceStrategyCameraEntity);
                        }
                    }
                    if (ecbStrategy.getAiList().size() <= 0) continue;
                    for (EcbStrategyAIRelation ecbStrategyAIRelation : ecbStrategy.getAiList()) {
                        EcbpDeviceStrategyAiEntity ecbpDeviceStrategyAiEntity = (EcbpDeviceStrategyAiEntity)JsonUtil.getJsonToBean((Object)ecbStrategyAIRelation, EcbpDeviceStrategyAiEntity.class);
                        String strategyAiId = strategyId + "_" + ecbStrategyAIRelation.getAiId();
                        ecbpDeviceStrategyAiEntity.setId(strategyAiId);
                        ecbpDeviceStrategyAiEntity.setStrategyId(strategyId);
                        ecbpDeviceStrategyAiEntity.setEnabledMark(10);
                        this.ecbpDeviceStrategyAiService.save(ecbpDeviceStrategyAiEntity);
                    }
                }
            }
        }
    }

    public void saveCameraInfo(EcbRequest ecbRequest) {
        this.ecbpDeviceCameraService.removeByDeviceId(ecbRequest.getDeviceId());
        if (ecbRequest.getCameraList().size() > 0) {
            for (EcbCamera ecbCamera : ecbRequest.getCameraList()) {
                EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)JsonUtil.getJsonToBean((Object)ecbCamera, EcbpDeviceCameraEntity.class);
                ecbpDeviceCameraEntity.setId(ecbCamera.getCameraId());
                ecbpDeviceCameraEntity.setProtocal(ecbpDeviceCameraEntity.getProtocal());
                ecbpDeviceCameraEntity.setGroupId(ecbRequest.getDeviceId() + "_" + ecbCamera.getGroupId());
                ecbpDeviceCameraEntity.setDeviceIds(ecbRequest.getDeviceId());
                this.ecbpDeviceCameraService.save(ecbpDeviceCameraEntity);
            }
        }
    }

    public void saveAiInfo(EcbRequest ecbRequest) {
        if (ecbRequest.getAiList().size() > 0) {
            for (EcbAi ecbAi : ecbRequest.getAiList()) {
                String aiId = ecbRequest.getDeviceId() + "_" + ecbAi.getAiId();
                EcbpDeviceAiEntity deviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)aiId));
                EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)JsonUtil.getJsonToBean((Object)ecbAi, EcbpDeviceAiEntity.class);
                ecbpDeviceAiEntity.setId(aiId);
                ecbpDeviceAiEntity.setDeviceId(ecbRequest.getDeviceId());
                if (StringUtils.isNotNull((Object)deviceAiEntity)) {
                    this.ecbpDeviceAiService.updateById(ecbpDeviceAiEntity);
                    continue;
                }
                this.ecbpDeviceAiService.save(ecbpDeviceAiEntity);
            }
        }
    }

    public void saveAiAlertInfo(EcbRequest ecbRequest) {
        ArrayList<EcbpDeviceAiAlertEntity> flowList = new ArrayList<EcbpDeviceAiAlertEntity>();
        if (ecbRequest.getAlertList().size() > 0) {
            for (EcbAlert ecbAlert : ecbRequest.getAlertList()) {
                String aiAlertId = RandomUtil.uuId();
                EcbpDeviceAiAlertEntity ecbpDeviceAiAlertEntity = (EcbpDeviceAiAlertEntity)JsonUtil.getJsonToBean((Object)ecbAlert, EcbpDeviceAiAlertEntity.class);
                ecbpDeviceAiAlertEntity.setId(aiAlertId);
                ecbpDeviceAiAlertEntity.setEnabledMark(10);
                ecbpDeviceAiAlertEntity.setDeviceId(ecbRequest.getDeviceId());
                this.ecbpDeviceAiAlertService.save(ecbpDeviceAiAlertEntity);
                flowList.add(ecbpDeviceAiAlertEntity);
                ExecutorService executor = Executors.newFixedThreadPool(1);
                Callable<String> task = () -> {
                    List list = this.roleService.getListByEnCode("aiAilertManager");
                    if (list.size() > 0) {
                        List data = this.userRelationService.getListByObjectId(((RoleEntity)list.get(0)).getId());
                        ArrayList<String> ids = new ArrayList<String>();
                        for (UserRelationEntity entity : data) {
                            ids.add(entity.getUserId());
                        }
                        if (ids.size() > 0) {
                            EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(ecbpDeviceAiAlertEntity.getDeviceId() + "_" + ecbpDeviceAiAlertEntity.getAiId())));
                            EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getCameraId()));
                            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getDeviceId()));
                            StringBuilder s = new StringBuilder();
                            s.append(ecbpDeviceEntity.getDeviceName()).append("/\u901a\u9053").append(ecbpDeviceAiAlertEntity.getChannelId()).append(" ").append(ecbpDeviceCameraEntity.getCameraName()).append("(").append(ecbpDeviceAiEntity.getAiName()).append(")\u4ea7\u751f\u4e86\u65b0\u7684\u544a\u8b66\u4fe1\u606f");
                            this.sendMessage(ids, "AI\u544a\u8b66\u63d0\u9192", s.toString(), "");
                        }
                    }
                    return "Hello";
                };
                Future<String> future = executor.submit(task);
                executor.shutdown();
                this.pushAlertInfoToTwin(ecbpDeviceAiAlertEntity, 1);
                EcbpDeviceSmartScenePagination ecbpDeviceSmartScenePagination = new EcbpDeviceSmartScenePagination();
                ecbpDeviceSmartScenePagination.setDeviceId(ecbRequest.getDeviceId());
                ecbpDeviceSmartScenePagination.setOperateType("auto");
                List<EcbpDeviceSmartSceneEntity> ecbpDeviceSmartSceneEntityList = this.ecbpDeviceSmartSceneService.getList(ecbpDeviceSmartScenePagination);
                for (EcbpDeviceSmartSceneEntity deviceSmartSceneEntity : ecbpDeviceSmartSceneEntityList) {
                    JSONArray jsonToJsonArray = JsonUtil.getJsonToJsonArray((String)deviceSmartSceneEntity.getCameraIds());
                    for (int i = 0; i < jsonToJsonArray.size(); ++i) {
                        if (!jsonToJsonArray.get(i).equals(ecbAlert.getCameraId())) continue;
                        this.ecbpDeviceCmdService.startOrStopAiStrategy(deviceSmartSceneEntity, "start");
                        EcbpDeviceSmartSceneEntity subentity = new EcbpDeviceSmartSceneEntity();
                        subentity.setEnabledMark(10);
                        this.ecbpDeviceSmartSceneService.update(deviceSmartSceneEntity.getId(), subentity);
                        ecbpDeviceAiAlertEntity.setEnabledMark(70);
                        this.ecbpDeviceAiAlertService.updateById(ecbpDeviceAiAlertEntity);
                    }
                }
            }
        }
    }

    private void sendMessage(List<String> userId, String title, String content, String url) throws Exception {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(Integer.valueOf(40));
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId(this.sysConfigService.getConfigByKeyName("diskSizeMessage").getKeyValue());
        sentMessageForm.setTitle(title);
        sentMessageForm.setContent(content);
        sentMessageForm.setBodyText(new HashMap());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("content", content);
        map.put("AppUrl", this.sysConfigService.getSystemAddress("app") + url);
        sentMessageForm.setParameterMap(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
        this.serviceUtil.sendMessage(messageListAll);
    }

    public void saveAiAlertFlow(List<EcbpDeviceAiAlertEntity> flowList) throws WorkFlowException {
        for (EcbpDeviceAiAlertEntity ecbpDeviceAiAlertEntity : flowList) {
            String flowTaskId = RandomUtil.uuId();
            String flowEngineId = "554210123359202949";
            String processId = ecbpDeviceAiAlertEntity.getId();
            JSONObject jsonObject = new JSONObject();
            EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(ecbpDeviceAiAlertEntity.getDeviceId() + "_" + ecbpDeviceAiAlertEntity.getAiId())));
            EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getCameraId()));
            EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getDeviceId()));
            jsonObject.put("jsbos_ecbp_device_jsbos_deviceName", (Object)ecbpDeviceEntity.getDeviceName());
            jsonObject.put("jsbos_ecbp_device_camera_jsbos_cameraName", (Object)ecbpDeviceCameraEntity.getCameraName());
            jsonObject.put("jsbos_ecbp_device_ai_jsbos_aiName", (Object)ecbpDeviceAiEntity.getAiName());
            jsonObject.put("flowId", (Object)"554210123359202949");
            jsonObject.put("creatorTime", (Object)new Date());
            jsonObject.put("files", (Object)ecbpDeviceAiAlertEntity.getFiles());
            StringBuilder s = new StringBuilder();
            s.append(ecbpDeviceEntity.getDeviceName()).append("/\u901a\u9053").append(ecbpDeviceAiAlertEntity.getChannelId()).append(" ").append(ecbpDeviceCameraEntity.getCameraName()).append("(").append(ecbpDeviceAiEntity.getAiName()).append(")\u4ea7\u751f\u4e86\u544a\u8b66");
            jsonObject.put("description", (Object)s.toString());
            Integer flowStatus = 0;
            String title = s.toString();
            FlowUtil.saveOrSubmit((String)flowTaskId, (String)flowEngineId, (String)processId, (Object)jsonObject, (Integer)flowStatus, (String)title);
        }
    }

    public void saveBusinessInfo(EcbRequest ecbRequest) {
        if (ecbRequest.getBusinessList().size() > 0) {
            for (EcbBusiness ecbBusiness : ecbRequest.getBusinessList()) {
                String businessId = ecbRequest.getDeviceId() + "_" + ecbBusiness.getBusinessId();
                EcbpDeviceBusinessEntity deviceBusinessEntity = (EcbpDeviceBusinessEntity)this.ecbpDeviceBusinessService.getById((Serializable)((Object)businessId));
                EcbpDeviceBusinessEntity ecbpDeviceBusinessEntity = (EcbpDeviceBusinessEntity)JsonUtil.getJsonToBean((Object)ecbBusiness, EcbpDeviceBusinessEntity.class);
                ecbpDeviceBusinessEntity.setId(businessId);
                ecbpDeviceBusinessEntity.setEnabledMark(10);
                ecbpDeviceBusinessEntity.setDeviceId(ecbRequest.getDeviceId());
                if (StringUtils.isNotNull((Object)deviceBusinessEntity)) {
                    this.ecbpDeviceBusinessService.updateById(ecbpDeviceBusinessEntity);
                    continue;
                }
                this.ecbpDeviceBusinessService.save(ecbpDeviceBusinessEntity);
            }
        }
    }

    @Override
    public void pushAlertInfoToTwin(EcbpDeviceAiAlertEntity ecbpDeviceAiAlertEntity, int status) {
        EcbpDeviceAiAlertToTwin aiAlertToTwin = new EcbpDeviceAiAlertToTwin();
        EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(ecbpDeviceAiAlertEntity.getDeviceId() + "_" + ecbpDeviceAiAlertEntity.getAiId())));
        EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getCameraId()));
        EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getDeviceId()));
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isNotNull((Object)ecbpDeviceEntity)) {
            stringBuffer.append(ecbpDeviceEntity.getDeviceName()).append(": \u901a\u9053").append(ecbpDeviceAiAlertEntity.getChannelId());
        }
        if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
            stringBuffer.append(" ").append(ecbpDeviceCameraEntity.getCameraName());
        }
        if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
            stringBuffer.append(" (").append(ecbpDeviceAiEntity.getAiName()).append(")");
        }
        aiAlertToTwin.setTwinID(ecbpDeviceAiAlertEntity.getCameraId());
        aiAlertToTwin.setSeverity(1);
        aiAlertToTwin.setStatus(status);
        aiAlertToTwin.setSourceAlertKey(ecbpDeviceAiEntity.getAiName());
        aiAlertToTwin.setSummary(stringBuffer.toString());
        aiAlertToTwin.setSourceIdentifier(ecbpDeviceAiAlertEntity.getId());
        aiAlertToTwin.setLastOccurrence(DateUtil.dateFormat((Date)ecbpDeviceAiAlertEntity.getCreatorTime()));
        ArrayList<EcbpDeviceAiAlertToTwin> ls = new ArrayList<EcbpDeviceAiAlertToTwin>();
        ls.add(aiAlertToTwin);
        String twinUrl = "";
        try {
            SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiTwinUrl");
            if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                twinUrl = sysConfigEntity.getKeyValue();
                log.info("\u63a8\u9001\u5230\u6570\u5b57\u5b6a\u751f\u7684\u544a\u8b66\u6570\u636e---------------");
                log.info(JsonUtil.getObjectToString(ls));
                String res = ThingJSUtil.httpPostPushAssetsData(twinUrl, JsonUtil.getObjectToString(ls));
                JSONObject resObject = JSONObject.parseObject((String)res);
                if (resObject.getBoolean("success").booleanValue()) {
                    log.info("\u63a8\u9001\u6210\u529f" + String.valueOf(resObject));
                } else {
                    log.info("\u63a8\u9001\u5931\u8d25", (Object)res);
                }
            } else {
                log.info("\u63a8\u9001\u5931\u8d25,\u6570\u5b57\u5b6a\u751f\u5730\u5740\u672a\u914d\u7f6e");
            }
        }
        catch (Exception exception) {
            log.info("\u670d\u52a1\u5668\u5f02\u5e38", (Object)exception.getMessage());
        }
    }

    public void pushChannelStateAlertInfoToTwin(List<EcbpDeviceChannelStateEntity> list) {
        block13: {
            ArrayList<EcbpDeviceAiAlertToTwin> ls = new ArrayList<EcbpDeviceAiAlertToTwin>();
            if (list.size() > 0) {
                for (EcbpDeviceChannelStateEntity entity : list) {
                    EcbpDeviceAiAlertToTwin aiAlertToTwin = new EcbpDeviceAiAlertToTwin();
                    EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(entity.getDeviceId() + "_" + entity.getAiId())));
                    EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)entity.getCameraId()));
                    EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)entity.getDeviceId()));
                    StringBuffer stringBuffer = new StringBuffer();
                    if (StringUtils.isNotNull((Object)ecbpDeviceEntity)) {
                        stringBuffer.append(ecbpDeviceEntity.getDeviceName()).append(": \u901a\u9053").append(entity.getChannelId());
                    }
                    if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
                        stringBuffer.append(" ").append(ecbpDeviceCameraEntity.getCameraName());
                    }
                    if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                        stringBuffer.append(" (").append(ecbpDeviceAiEntity.getAiName()).append(")");
                    }
                    aiAlertToTwin.setTwinID(entity.getCameraId());
                    aiAlertToTwin.setSeverity(1);
                    aiAlertToTwin.setStatus(Integer.valueOf(entity.getEnabledMark()));
                    if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                        aiAlertToTwin.setSourceAlertKey(ecbpDeviceAiEntity.getAiName());
                    } else {
                        aiAlertToTwin.setSourceAlertKey("\u672a\u914d\u7f6e\u7b97\u6cd5");
                    }
                    aiAlertToTwin.setSummary(stringBuffer.toString());
                    aiAlertToTwin.setSourceIdentifier(entity.getId());
                    aiAlertToTwin.setLastOccurrence(DateUtil.dateFormat((Date)entity.getCreatorTime()));
                    ls.add(aiAlertToTwin);
                }
                String twinUrl = "";
                try {
                    SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiTwinUrl");
                    if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                        twinUrl = sysConfigEntity.getKeyValue();
                        log.info("\u63a8\u9001\u5230\u6570\u5b57\u5b6a\u751f\u7684\u544a\u8b66\u6570\u636e---------------");
                        log.info(JsonUtil.getObjectToString(ls));
                        String res = ThingJSUtil.httpPostPushAssetsData(twinUrl, JsonUtil.getObjectToString(ls));
                        JSONObject resObject = JSONObject.parseObject((String)res);
                        if (resObject.getBoolean("success").booleanValue()) {
                            log.info("\u63a8\u9001\u6210\u529f" + String.valueOf(resObject));
                        } else {
                            log.info("\u63a8\u9001\u5931\u8d25", (Object)res);
                        }
                        break block13;
                    }
                    log.info("\u63a8\u9001\u5931\u8d25,\u6570\u5b57\u5b6a\u751f\u5730\u5740\u672a\u914d\u7f6e");
                }
                catch (Exception exception) {
                    log.info("\u670d\u52a1\u5668\u5f02\u5e38", (Object)exception.getMessage());
                }
            } else {
                log.info("\u6ca1\u6709\u9700\u8981\u63a8\u9001\u7684\u6570\u636e");
            }
        }
    }

    @Override
    public void delete(EcbpRequestEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public void offAlertInfo(String deviceId) {
        block11: {
            Date date = DateUtil.dateAddHours(null, (int)-2);
            List<EcbpDeviceAiAlertEntity> listByCreateTime = this.ecbpDeviceAiAlertService.getListByCreateTime(deviceId, date);
            ArrayList<EcbpDeviceAiAlertToTwin> ls = new ArrayList<EcbpDeviceAiAlertToTwin>();
            for (EcbpDeviceAiAlertEntity ecbpDeviceAiAlertEntity : listByCreateTime) {
                EcbpDeviceAiAlertToTwin aiAlertToTwin = new EcbpDeviceAiAlertToTwin();
                EcbpDeviceAiEntity ecbpDeviceAiEntity = (EcbpDeviceAiEntity)this.ecbpDeviceAiService.getById((Serializable)((Object)(ecbpDeviceAiAlertEntity.getDeviceId() + "_" + ecbpDeviceAiAlertEntity.getAiId())));
                EcbpDeviceCameraEntity ecbpDeviceCameraEntity = (EcbpDeviceCameraEntity)this.ecbpDeviceCameraService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getCameraId()));
                EcbpDeviceEntity ecbpDeviceEntity = (EcbpDeviceEntity)this.ecbpDeviceService.getById((Serializable)((Object)ecbpDeviceAiAlertEntity.getDeviceId()));
                StringBuffer stringBuffer = new StringBuffer();
                if (StringUtils.isNotNull((Object)ecbpDeviceEntity)) {
                    stringBuffer.append(ecbpDeviceEntity.getDeviceName()).append(": \u901a\u9053").append(ecbpDeviceAiAlertEntity.getChannelId());
                }
                if (StringUtils.isNotNull((Object)ecbpDeviceCameraEntity)) {
                    stringBuffer.append(" ").append(ecbpDeviceCameraEntity.getCameraName());
                }
                if (StringUtils.isNotNull((Object)ecbpDeviceAiEntity)) {
                    stringBuffer.append(" (").append(ecbpDeviceAiEntity.getAiName()).append(")");
                }
                aiAlertToTwin.setTwinID(ecbpDeviceAiAlertEntity.getCameraId());
                aiAlertToTwin.setSeverity(1);
                aiAlertToTwin.setStatus(2);
                aiAlertToTwin.setSourceAlertKey(ecbpDeviceAiEntity.getAiName());
                aiAlertToTwin.setSummary(stringBuffer.toString());
                aiAlertToTwin.setSourceIdentifier(ecbpDeviceAiAlertEntity.getId());
                aiAlertToTwin.setLastOccurrence(DateUtil.dateFormat((Date)ecbpDeviceAiAlertEntity.getCreatorTime()));
                ls.add(aiAlertToTwin);
                ecbpDeviceAiAlertEntity.setEnabledMark(90);
            }
            if (ls.size() > 0) {
                String twinUrl = "";
                try {
                    SysConfigEntity sysConfigEntity = this.sysConfigService.getConfigByKeyName("aiTwinUrl");
                    if (StringUtils.isNotNull((Object)sysConfigEntity)) {
                        twinUrl = sysConfigEntity.getKeyValue();
                        log.info("\u5173\u95ed\u5230\u6570\u5b57\u5b6a\u751f\u7684\u544a\u8b66\u6570\u636e---------------");
                        log.info(JsonUtil.getObjectToString(ls));
                        String res = ThingJSUtil.httpPostPushAssetsData(twinUrl, JsonUtil.getObjectToString(ls));
                        JSONObject resObject = JSONObject.parseObject((String)res);
                        if (resObject.getBoolean("success").booleanValue()) {
                            log.info("\u5173\u95ed\u6210\u529f" + String.valueOf(resObject));
                            this.ecbpDeviceAiAlertService.updateBatchById(listByCreateTime);
                        } else {
                            log.info("\u5173\u95ed\u5931\u8d25", (Object)res);
                        }
                        break block11;
                    }
                    log.info("\u5173\u95ed\u5931\u8d25,\u6570\u5b57\u5b6a\u751f\u5730\u5740\u672a\u914d\u7f6e");
                }
                catch (Exception exception) {
                    log.info("\u670d\u52a1\u5668\u5f02\u5e38", (Object)exception.getMessage());
                }
            } else {
                log.info("\u6ca1\u6709\u8981\u5173\u95ed\u7684\u6570\u636e");
            }
        }
    }
}

