/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ecbp.task;

import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.ecbp.entity.EcbpDeviceEntity;
import com.bringspring.ecbp.service.EcbpDeviceService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class EcbpDeviceStatusDisk {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private EcbpDeviceService ecbpDeviceService;
    private static DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Scheduled(cron="0 0/1 * * * ?")
    public void cron() {
        LocalDateTime now = LocalDateTime.now();
        System.out.println("\u5b9a\u65f6\u76d1\u63a7\u8bbe\u5907\u7684\u5728\u7ebf\u79bb\u7ebf\u72b6\u6001" + pattern.format(now));
        List deviceList = this.ecbpDeviceService.list();
        for (EcbpDeviceEntity ecbpDeviceEntity : deviceList) {
            Object obj = this.redisUtil.getString(ecbpDeviceEntity.getDeviceId());
            if (StringUtils.isNull((Object)obj)) {
                ecbpDeviceEntity.setEnabledMark(90);
                this.ecbpDeviceService.updateById(ecbpDeviceEntity);
                continue;
            }
            ecbpDeviceEntity.setEnabledMark(10);
            this.ecbpDeviceService.updateById(ecbpDeviceEntity);
        }
    }
}

